/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.nattable;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultRowHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayerListener;
import org.eclipse.nebula.widgets.nattable.layer.event.ColumnDeleteEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.ColumnInsertEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.resize.event.ColumnResizeEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scrollable;
import org.simantics.browsing.ui.nattable.GEColumnHeaderDataProvider;
import org.simantics.browsing.ui.nattable.NatTableGraphExplorer;

public class NatTableColumnLayout
extends Layout
implements ILayerListener {
    private static int COLUMN_TRIM = Util.isWindows() ? 4 : (Util.isMac() ? 24 : 3);
    NatTable natTable;
    GEColumnHeaderDataProvider columnHeaderDataProvider;
    DefaultRowHeaderDataLayer rowHeaderDataLayer;
    Map<Integer, ColumnLayoutData> layoutDatas = new HashMap<Integer, ColumnLayoutData>();
    private boolean inupdateMode = false;
    private boolean relayout = true;
    boolean updateCalled = false;

    public NatTableColumnLayout(NatTable natTable, GEColumnHeaderDataProvider columnHeaderDataProvider) {
        this.natTable = natTable;
        this.columnHeaderDataProvider = columnHeaderDataProvider;
        this.natTable.addLayerListener((ILayerListener)this);
    }

    public NatTableColumnLayout(NatTable natTable, GEColumnHeaderDataProvider columnHeaderDataProvider, DefaultRowHeaderDataLayer rowHeaderDataLayer) {
        this.natTable = natTable;
        this.columnHeaderDataProvider = columnHeaderDataProvider;
        this.natTable.addLayerListener((ILayerListener)this);
        this.rowHeaderDataLayer = rowHeaderDataLayer;
    }

    public void setColumnData(int column, ColumnLayoutData data) {
        this.layoutDatas.put(column, data);
    }

    protected void setColumnWidths(Scrollable tree, int[] widths) {
        int i;
        double displayScale = NatTableGraphExplorer.getDisplayScale();
        if (displayScale != 1.0) {
            i = 0;
            while (i < widths.length) {
                widths[i] = (int)Math.floor((double)widths[i] / displayScale);
                ++i;
            }
        }
        i = 0;
        while (i < widths.length) {
            this.columnHeaderDataProvider.getDataLayer().setColumnWidthByPosition(i, widths[i]);
            ++i;
        }
    }

    public void handleLayerEvent(ILayerEvent event) {
        if (this.inupdateMode) {
            return;
        }
        if (event instanceof ColumnResizeEvent) {
            ColumnResizeEvent evt = (ColumnResizeEvent)event;
            for (Range r : evt.getColumnPositionRanges()) {
                int colIndex = evt.getLayer().getColumnIndexByPosition(r.start);
                int w = this.columnHeaderDataProvider.getDataLayer().getColumnWidthByPosition(colIndex);
                this.setColumnData(colIndex, (ColumnLayoutData)new ColumnPixelData(w));
            }
            this.update();
        } else if (event instanceof ColumnInsertEvent || event instanceof ColumnDeleteEvent) {
            this.update();
        }
    }

    private void update() {
        if (this.updateCalled) {
            return;
        }
        this.updateCalled = true;
        this.natTable.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!NatTableColumnLayout.this.natTable.isDisposed()) {
                    NatTableColumnLayout.this.natTable.update();
                    NatTableColumnLayout.this.natTable.getParent().layout();
                }
                NatTableColumnLayout.this.updateCalled = false;
            }
        });
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        return this.computeTableTreeSize(this.getControl(composite), wHint, hHint);
    }

    Scrollable getControl(Composite composite) {
        return this.natTable;
    }

    protected void layout(Composite composite, boolean flushCache) {
        Rectangle area = composite.getClientArea();
        Scrollable table = this.getControl(composite);
        int tableWidth = table.getSize().x;
        int trim = this.computeTrim(area, table, tableWidth);
        int width = Math.max(0, area.width - trim);
        if (this.rowHeaderDataLayer != null) {
            width -= this.rowHeaderDataLayer.getWidth();
        }
        if (width > 1) {
            this.layoutTableTree(table, width, area, tableWidth < area.width);
        }
        if (this.relayout) {
            this.relayout = false;
            composite.layout();
        }
    }

    protected ColumnLayoutData getLayoutData(Scrollable tableTree, int columnIndex) {
        return this.layoutDatas.get(columnIndex);
    }

    protected int getColumnCount(Scrollable tableTree) {
        return this.columnHeaderDataProvider.getColumnCount();
    }

    private Point computeTableTreeSize(Scrollable scrollable, int wHint, int hHint) {
        Point result = scrollable.computeSize(wHint, hHint);
        int width = 0;
        int size = this.getColumnCount(scrollable);
        if (this.rowHeaderDataLayer != null) {
            width += this.rowHeaderDataLayer.getWidth();
        }
        int i = 0;
        while (i < size) {
            ColumnPixelData col;
            ColumnLayoutData layoutData = this.getLayoutData(scrollable, i);
            if (layoutData instanceof ColumnPixelData) {
                col = (ColumnPixelData)layoutData;
                width += col.width;
                if (col.addTrim) {
                    width += this.getColumnTrim();
                }
            } else if (layoutData instanceof ColumnWeightData) {
                col = (ColumnWeightData)layoutData;
                width += col.minimumWidth;
            } else {
                Assert.isTrue((boolean)false, (String)"Unknown column layout data");
            }
            ++i;
        }
        if (width > result.x) {
            result.x = width;
        }
        return result;
    }

    private void layoutTableTree(Scrollable scrollable, int width, Rectangle area, boolean increase) {
        boolean recalculate;
        int numberOfColumns = this.getColumnCount(scrollable);
        int[] widths = new int[numberOfColumns];
        int[] weightColumnIndices = new int[numberOfColumns];
        int numberOfWeightColumns = 0;
        int fixedWidth = 0;
        int totalWeight = 0;
        int i = 0;
        while (i < numberOfColumns) {
            ColumnLayoutData col = this.getLayoutData(scrollable, i);
            if (col instanceof ColumnPixelData) {
                ColumnPixelData cpd = (ColumnPixelData)col;
                int pixels = cpd.width;
                if (cpd.addTrim) {
                    pixels += this.getColumnTrim();
                }
                widths[i] = pixels;
                fixedWidth += pixels;
            } else if (col instanceof ColumnWeightData) {
                ColumnWeightData cw = (ColumnWeightData)col;
                weightColumnIndices[numberOfWeightColumns] = i;
                ++numberOfWeightColumns;
                totalWeight += cw.weight;
            } else {
                Assert.isTrue((boolean)false, (String)"Unknown column layout data");
            }
            ++i;
        }
        block1: do {
            recalculate = false;
            int i2 = 0;
            while (i2 < numberOfWeightColumns) {
                int allowedWidth;
                int colIndex = weightColumnIndices[i2];
                ColumnWeightData cw = (ColumnWeightData)this.getLayoutData(scrollable, colIndex);
                int minWidth = cw.minimumWidth;
                int n = allowedWidth = totalWeight == 0 ? 0 : (width - fixedWidth) * cw.weight / totalWeight;
                if (allowedWidth < minWidth) {
                    totalWeight -= cw.weight;
                    fixedWidth += minWidth;
                    widths[colIndex] = minWidth;
                    System.arraycopy(weightColumnIndices, i2 + 1, weightColumnIndices, i2, --numberOfWeightColumns - i2);
                    recalculate = true;
                    continue block1;
                }
                widths[colIndex] = allowedWidth;
                ++i2;
            }
        } while (recalculate);
        if (increase) {
            scrollable.setSize(area.width, area.height);
        }
        this.inupdateMode = true;
        this.setColumnWidths(scrollable, widths);
        scrollable.update();
        this.inupdateMode = false;
        if (!increase) {
            scrollable.setSize(area.width, area.height);
        }
    }

    private int computeTrim(Rectangle area, Scrollable scrollable, int currentWidth) {
        int trim = currentWidth > 1 ? currentWidth - scrollable.getClientArea().width : 2 * scrollable.getBorderWidth() + 1;
        return trim;
    }

    protected int getColumnTrim() {
        return COLUMN_TRIM;
    }
}

