/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.graph.impl.contribution;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.CheckedState;
import org.simantics.browsing.ui.DataSource;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.graph.impl.request.ResourceQuery;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Listener;
import org.simantics.db.procedure.Procedure;
import org.simantics.utils.ui.ErrorLogger;

public abstract class FinalCheckedStateContributionImpl {
    protected final PrimitiveQueryUpdater updater;
    private final ResourceQuery<CheckedState> labelQuery;
    private final Procedure<CheckedState> procedure;
    private final NodeContext context;
    private final BuiltinKeys.CheckedStateKey key;
    private CheckedState state = null;

    public Object getIdentity(BuiltinKeys.CheckedStateKey key) {
        return key;
    }

    public CheckedState getState() {
        if (this.state == null) {
            DataSource source = this.updater.getDataSource(AsyncReadGraph.class);
            assert (source != null);
            source.schedule(graph -> {
                if (this.procedure instanceof Listener) {
                    graph.asyncRequest(this.labelQuery, (Listener)this.procedure);
                } else {
                    graph.asyncRequest(this.labelQuery, this.procedure);
                }
            });
        }
        return this.state;
    }

    public FinalCheckedStateContributionImpl(PrimitiveQueryUpdater updater, NodeContext context, BuiltinKeys.CheckedStateKey key) {
        this.updater = updater;
        this.context = context;
        this.key = key;
        this.labelQuery = new ResourceQuery<CheckedState>(this.getIdentity(key), context){

            public CheckedState perform(ReadGraph graph) throws DatabaseException {
                try {
                    return FinalCheckedStateContributionImpl.this.getState(graph, this.context);
                }
                catch (DatabaseException e) {
                    throw e;
                }
                catch (Throwable t) {
                    ErrorLogger.defaultLogError((String)"LazyGraphLabeler.labelQuery produced unexpected exception.", (Throwable)t);
                    return null;
                }
            }

            public String toString() {
                return FinalCheckedStateContributionImpl.this + " with context " + this.context;
            }
        };
        this.procedure = this.createProcedure();
    }

    protected Procedure<CheckedState> createProcedure() {
        return new Procedure<CheckedState>(){

            public void execute(CheckedState result) {
                FinalCheckedStateContributionImpl.this.replaceResult(result);
            }

            public void exception(Throwable t) {
                ErrorLogger.defaultLogError((String)"LazyContributionImpl.childQuery failed, see exception for details.", (Throwable)t);
            }
        };
    }

    protected void replaceResult(CheckedState result) {
        this.state = result;
        this.updater.scheduleReplace(this.context, (NodeContext.PrimitiveQueryKey)this.key, (Object)this.state);
    }

    public abstract CheckedState getState(ReadGraph var1, NodeContext var2) throws DatabaseException;
}

