/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl;

import com.koloboke.collect.impl.Containers;
import com.koloboke.collect.impl.InternalDoubleObjMapOps;
import com.koloboke.collect.map.DoubleObjMap;
import com.koloboke.function.DoubleObjConsumer;
import com.koloboke.function.DoubleObjPredicate;
import java.util.Map;

public final class CommonDoubleObjMapOps {
    public static boolean containsAllEntries(final InternalDoubleObjMapOps<?> map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof DoubleObjMap) {
            DoubleObjMap m2 = (DoubleObjMap)another;
            if (m2.valueEquivalence().equals((Object)map.valueEquivalence())) {
                if (map.size() < m2.size()) {
                    return false;
                }
                if (m2 instanceof InternalDoubleObjMapOps) {
                    return ((InternalDoubleObjMapOps)m2).allEntriesContainingIn(map);
                }
            }
            return m2.forEachWhile(new DoubleObjPredicate(){

                public boolean test(double a, Object b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry((Double)e.getKey(), e.getValue())) continue;
            return false;
        }
        return true;
    }

    public static <V> void putAll(final InternalDoubleObjMapOps<V> map, Map<? extends Double, ? extends V> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof DoubleObjMap) {
            if (another instanceof InternalDoubleObjMapOps) {
                ((InternalDoubleObjMapOps)another).reversePutAllTo(map);
            } else {
                ((DoubleObjMap)another).forEach(new DoubleObjConsumer<V>(){

                    public void accept(double key, V value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<Double, V> e : another.entrySet()) {
                map.justPut(e.getKey(), e.getValue());
            }
        }
    }

    private CommonDoubleObjMapOps() {
    }
}

