/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system;

import com.impossibl.postgres.system.Setting;
import com.impossibl.postgres.system.SettingGlobal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;

public class Settings {
    private static final Logger logger = Logger.getLogger(Settings.class.getName());
    private Map<String, Setting<?>> known = new HashMap();
    private Map<String, String> values = new HashMap<String, String>();

    public Settings() {
        this(SettingGlobal.getAllGroups());
    }

    public Settings(Setting.Group ... groups) {
        for (Setting.Group group : groups) {
            this.known.putAll(group.getAllNamedSettings());
        }
    }

    public Settings duplicateKnowingAll() {
        Settings copy = new Settings();
        copy.values = new HashMap<String, String>(this.values);
        return copy;
    }

    public Settings duplicateKnowing(Setting.Group ... groups) {
        Settings copy = new Settings(groups);
        copy.values = new HashMap<String, String>(this.values);
        return copy;
    }

    public Set<Setting<?>> knownSet() {
        return new HashSet(this.known.values());
    }

    public boolean hasStoredValue(Setting<?> setting) {
        return this.values.containsKey(setting.getName());
    }

    public boolean enabled(Setting<Boolean> setting) {
        Boolean value = this.get(setting);
        return value != null && value != false;
    }

    public <T> T get(Setting<T> setting) {
        String value = this.values.get(setting.getName());
        if (value != null) {
            return setting.fromString(value);
        }
        return setting.getDefault();
    }

    public <T> T getStored(Setting<T> setting) {
        String value = this.values.get(setting.getName());
        if (value != null) {
            return setting.fromString(value);
        }
        return null;
    }

    public String getText(Setting<?> setting) {
        String value = this.values.get(setting.getName());
        if (value != null) {
            return value;
        }
        return setting.getDefaultText();
    }

    public <T> void set(Setting<T> setting, T value) {
        if (!this.known.containsKey(setting.getName())) {
            logger.warning("Applying unknown setting: " + setting.getName());
        }
        if (value == null) {
            this.values.remove(setting.getName());
        } else {
            this.values.put(setting.getName(), setting.toString(value));
        }
    }

    public void setText(Setting<?> setting, String value) {
        try {
            setting.fromString(value);
        }
        catch (Exception e) {
            logger.severe("Setting '" + value + "' to an invalid value: " + value);
        }
        if (value == null) {
            this.values.remove(setting.getName());
        } else {
            this.values.put(setting.getName(), value);
        }
    }

    public void set(String name, String text) {
        Setting<?> setting = this.known.get(name);
        if (setting == null) {
            logger.warning("Applying unknown setting: " + name);
            if (text == null) {
                this.values.remove(name);
            } else {
                this.values.put(name, text);
            }
            return;
        }
        this.setText(setting, text);
    }

    public void setAll(Settings settings) {
        settings.values.forEach(this::set);
    }

    public void setAll(Map<String, String> settings) {
        settings.forEach(this::set);
    }

    public void setAll(Properties properties) {
        for (String propertyName : properties.stringPropertyNames()) {
            this.set(propertyName, properties.getProperty(propertyName));
        }
    }

    public void unset(Setting<?> setting) {
        this.set(setting, null);
    }

    public void unset(String name) {
        this.set(name, null);
    }

    public Setting<?> mapUnknownSetting(Setting<?> setting) {
        for (String name : setting.getNames()) {
            Setting<?> mapped = this.known.get(name);
            if (mapped == null) continue;
            return mapped;
        }
        return null;
    }

    public Properties asProperties() {
        Properties properties = new Properties();
        this.values.forEach(properties::setProperty);
        return properties;
    }

    public Settings addMappedUnknownSetting(Setting<?> setting, Properties to) {
        if ((setting = this.mapUnknownSetting(setting)) == null) {
            return this;
        }
        String text = this.getText(setting);
        if (text != null) {
            to.setProperty(setting.getName(), text);
        }
        return this;
    }
}

