/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.api.data;

import java.io.Serializable;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Period;
import java.time.chrono.ChronoPeriod;
import java.time.chrono.IsoChronology;
import java.time.temporal.ChronoUnit;
import java.time.temporal.IsoFields;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

public final class Interval
implements TemporalAmount,
Serializable {
    public static final Interval ZERO = new Interval(Period.ZERO, Duration.ZERO);
    private static final long serialVersionUID = 8815521625671589L;
    private static final List<TemporalUnit> SUPPORTED_UNITS = Collections.unmodifiableList(Arrays.asList(ChronoUnit.YEARS, ChronoUnit.MONTHS, ChronoUnit.DAYS, ChronoUnit.SECONDS, ChronoUnit.NANOS));
    private static final long SECONDS_PER_DAY = 86400L;
    private final Period period;
    private final Duration duration;

    public static Interval of(Period period, Duration duration) {
        Objects.requireNonNull(period, "The period must not be null");
        Objects.requireNonNull(duration, "The duration must not be null");
        return new Interval(period, duration);
    }

    public static Interval of(Period period) {
        Objects.requireNonNull(period, "The period must not be null");
        return new Interval(period, Duration.ZERO);
    }

    public static Interval of(Duration duration) {
        Objects.requireNonNull(duration, "The duration must not be null");
        return new Interval(Period.ZERO, duration);
    }

    public static Interval from(TemporalAmount amount) {
        if (amount instanceof Interval) {
            return (Interval)amount;
        }
        if (amount instanceof Period) {
            return Interval.of((Period)amount);
        }
        if (amount instanceof Duration) {
            return Interval.of((Duration)amount);
        }
        if (amount instanceof ChronoPeriod && !IsoChronology.INSTANCE.equals(((ChronoPeriod)amount).getChronology())) {
            throw new DateTimeException("Period requires ISO chronology: " + amount);
        }
        Objects.requireNonNull(amount, "amount");
        int years = 0;
        int months = 0;
        int days = 0;
        Duration duration = Duration.ZERO;
        for (TemporalUnit unit : amount.getUnits()) {
            long value = amount.get(unit);
            if (value == 0L) continue;
            if (unit.isDurationEstimated()) {
                if (unit == ChronoUnit.DAYS) {
                    days = Math.addExact(days, Math.toIntExact(value));
                    continue;
                }
                if (unit == ChronoUnit.WEEKS) {
                    days = Math.addExact(days, Math.toIntExact(Math.multiplyExact(value, 7)));
                    continue;
                }
                if (unit == ChronoUnit.MONTHS) {
                    months = Math.addExact(months, Math.toIntExact(value));
                    continue;
                }
                if (unit == IsoFields.QUARTER_YEARS) {
                    months = Math.addExact(months, Math.toIntExact(Math.multiplyExact(value, 3)));
                    continue;
                }
                if (unit == ChronoUnit.YEARS) {
                    years = Math.addExact(years, Math.toIntExact(value));
                    continue;
                }
                if (unit == ChronoUnit.DECADES) {
                    years = Math.addExact(years, Math.toIntExact(Math.multiplyExact(value, 10)));
                    continue;
                }
                if (unit == ChronoUnit.CENTURIES) {
                    years = Math.addExact(years, Math.toIntExact(Math.multiplyExact(value, 100)));
                    continue;
                }
                if (unit == ChronoUnit.MILLENNIA) {
                    years = Math.addExact(years, Math.toIntExact(Math.multiplyExact(value, 1000)));
                    continue;
                }
                throw new DateTimeException("Unknown unit: " + unit);
            }
            duration = duration.plus(amount.get(unit), unit);
        }
        return Interval.of(Period.of(years, months, days), duration);
    }

    public static Interval parse(CharSequence text) {
        Objects.requireNonNull(text, "text");
        String upper = text.toString().toUpperCase(Locale.ENGLISH);
        String negate = "";
        if (upper.startsWith("+")) {
            upper = upper.substring(1);
        } else if (upper.startsWith("-")) {
            upper = upper.substring(1);
            negate = "-";
        }
        if (upper.startsWith("PT")) {
            return Interval.of(Duration.parse(text));
        }
        int tpos = upper.indexOf(84);
        if (tpos < 0) {
            return Interval.of(Period.parse(text));
        }
        Period period = Period.parse(negate + upper.substring(0, tpos));
        Duration duration = Duration.parse(negate + "P" + upper.substring(tpos));
        return Interval.of(period, duration);
    }

    public static Interval between(Temporal startInclusive, Temporal endExclusive) {
        LocalDate startDate = startInclusive.query(TemporalQueries.localDate());
        LocalDate endDate = endExclusive.query(TemporalQueries.localDate());
        Period period = Period.ZERO;
        if (startDate != null && endDate != null) {
            period = Period.between(startDate, endDate);
        }
        LocalTime startTime = startInclusive.query(TemporalQueries.localTime());
        LocalTime endTime = endExclusive.query(TemporalQueries.localTime());
        startTime = startTime != null ? startTime : LocalTime.MIDNIGHT;
        endTime = endTime != null ? endTime : LocalTime.MIDNIGHT;
        Duration duration = Duration.between(startTime, endTime);
        return Interval.of(period, duration);
    }

    private Interval(Period period, Duration duration) {
        this.period = period;
        this.duration = duration;
    }

    private Object readResolve() {
        return Interval.of(this.period, this.duration);
    }

    @Override
    public long get(TemporalUnit unit) {
        if (unit instanceof ChronoUnit) {
            switch ((ChronoUnit)unit) {
                case YEARS: {
                    return this.period.getYears();
                }
                case MONTHS: {
                    return this.period.getMonths();
                }
                case DAYS: {
                    return this.period.getDays();
                }
                case SECONDS: {
                    return this.duration.getSeconds();
                }
                case NANOS: {
                    return this.duration.getNano();
                }
            }
        }
        throw new UnsupportedTemporalTypeException("Unsupported unit: " + unit);
    }

    @Override
    public List<TemporalUnit> getUnits() {
        return SUPPORTED_UNITS;
    }

    public Period getPeriod() {
        return this.period;
    }

    public Interval withPeriod(Period period) {
        return Interval.of(period, this.duration);
    }

    public Duration getDuration() {
        return this.duration;
    }

    public Interval withDuration(Duration duration) {
        return Interval.of(this.period, duration);
    }

    public boolean isZero() {
        return this.period.isZero() && this.duration.isZero();
    }

    public Interval plus(TemporalAmount amountToAdd) {
        Interval other = Interval.from(amountToAdd);
        return Interval.of(this.period.plus(other.period), this.duration.plus(other.duration));
    }

    public Interval minus(TemporalAmount amountToAdd) {
        Interval other = Interval.from(amountToAdd);
        return Interval.of(this.period.minus(other.period), this.duration.minus(other.duration));
    }

    public Interval multipliedBy(int scalar) {
        if (scalar == 1) {
            return this;
        }
        return Interval.of(this.period.multipliedBy(scalar), this.duration.multipliedBy(scalar));
    }

    public Interval negated() {
        return this.multipliedBy(-1);
    }

    public Interval normalizedYears() {
        return this.withPeriod(this.period.normalized());
    }

    public Interval normalizedStandardDays() {
        long totalSecs = (long)this.period.getDays() * 86400L + this.duration.getSeconds();
        int splitDays = Math.toIntExact(totalSecs / 86400L);
        long splitSecs = totalSecs % 86400L;
        if (splitDays == this.period.getDays() && splitSecs == this.duration.getSeconds()) {
            return this;
        }
        return Interval.of(this.period.withDays(splitDays), this.duration.withSeconds(splitSecs));
    }

    @Override
    public Temporal addTo(Temporal temporal) {
        return temporal.plus(this.period).plus(this.duration);
    }

    @Override
    public Temporal subtractFrom(Temporal temporal) {
        return temporal.minus(this.period).minus(this.duration);
    }

    public boolean equals(Object otherAmount) {
        if (this == otherAmount) {
            return true;
        }
        if (otherAmount instanceof Interval) {
            Interval other = (Interval)otherAmount;
            return this.period.equals(other.period) && this.duration.equals(other.duration);
        }
        return false;
    }

    public int hashCode() {
        return this.period.hashCode() ^ this.duration.hashCode();
    }

    public String toString() {
        if (this.period.isZero()) {
            return this.duration.toString();
        }
        if (this.duration.isZero()) {
            return this.period.toString();
        }
        return this.period.toString() + this.duration.toString().substring(1);
    }
}

