package org.simantics.structural.synchronization.utils;

import gnu.trove.map.hash.THashMap;
import gnu.trove.procedure.TObjectObjectProcedure;
import gnu.trove.procedure.TObjectProcedure;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;

import org.simantics.databoard.annotations.Optional;

abstract public class ComponentBase<T extends ComponentBase<T>> {

    public int componentId;
	
    public String uid;
    protected transient T parent;
    
    @Optional public String solverComponentName;
    public boolean attached;
    
    public ComponentBase() {
    }

    public ComponentBase(String uid) {
    	this.uid = uid;
    }
    
    public ComponentBase(String uid, int moduleId) {
    	this.uid = uid;
    	this.componentId = moduleId;
    }

    public ComponentBase(int moduleId) {
    	this.componentId = moduleId;
    }
    
    /**
     * Detaches a child by its UID.
     */
    public void detachByUid(final String uid) {
        final AtomicReference<String> nameRef = new AtomicReference<String>();
        getChildMap().forEachEntry(new TObjectObjectProcedure<String, T>() {
            @Override
            public boolean execute(String name, T conf) {
                if(conf.uid.equals(uid)) {
                    nameRef.set(name);
                    return false;
                }
                else
                    return true;
            }
        });
        String name = nameRef.get();
        getChildMap().remove(name);
    }
    
    public Collection<T> getChildren() {
        if(getChildMap() == null)
            return Collections.emptyList();
        else
            return getChildMap().values();
    }
    
	public T getChild(String name) {
        if(getChildMap() == null)
            return null;
        else
            return getChildMap().get(name);
    }

    public THashMap<String, T> setChildMapAndReturnOld(
            THashMap<String, T> newChildMap) {
        THashMap<String, T> oldChildMap = getChildMap();
        setChildMap(newChildMap);
        return oldChildMap;
    }
    
    public int getModuleId() {
        return componentId;
    }

    public String getUid() {
        return uid;
    }
    
    public void setModuleId(int moduleId) {
        this.componentId = moduleId;
    }
    
    public void setUid(String uid) {
        this.uid = uid;
    }
    
    public boolean isComposite() {
        return getChildMap() != null;
    }

    public void printConfiguration(final int indentation) {
        printConfiguration(new PrintWriter(System.out), indentation);
    }

    public void printConfiguration(final PrintWriter out, final int indentation) {
        out.println(uid + " " + solverComponentName + "(" + componentId + ")");
        if(getChildMap() != null)
        	getChildMap().forEachEntry(new TObjectObjectProcedure<String, T>() {
                @Override
                public boolean execute(String a, T b) {
                    for(int i=0;i<indentation;++i)
                        out.print("    ");
                    out.print(a + " ");
                    b.printConfiguration(out, indentation+1);
                    return true;
                }
            });
    }
    
    public void clearParent() {
        this.parent = null;
    }
    
    public T getParent() {
    	return parent;
    }
    
    public void mapModuleIds(final int[] idMap) {
        if(componentId > 0)
            componentId = idMap[componentId];
        if(getChildMap() != null)
        	getChildMap().forEachValue(new TObjectProcedure<T>() {
                @Override
                public boolean execute(T component) {
                    component.mapModuleIds(idMap);
                    return true;
                }
            });
    }
        
    abstract public THashMap<String,T> getChildMap();
    abstract public void setChildMap(THashMap<String, T> newChildMap);

    public int componentHashCode() {
    	return hashCode();
//        final int prime = 31;
//        int result = 1;
//        result = prime * result + ((parent == null) ? 0 : parent.hashCode());
//        result = prime * result + ((uid == null) ? 0 : uid.hashCode());
//        result = prime * result + getChildren().hashCode();
//        return result;
    }

    public boolean componentEquals(Object obj) {
    	return this.equals(obj);
//        if (this == obj)
//            return true;
//        if (obj == null)
//            return false;
//        if (getClass() != obj.getClass())
//            return false;
//        ComponentBase<?> other = (ComponentBase<?>) obj;
//        if (parent == null) {
//            if (other.parent != null)
//                return false;
//        } else if (!parent.equals(other.parent))
//            return false;
//        if (uid == null) {
//            if (other.uid != null)
//                return false;
//        } else if (!uid.equals(other.uid))
//            return false;
//        
//        return getChildren().equals(other.getChildren());
//        
//        //return true;
//        
    }

}
