package org.simantics.structural.synchronization.protocol;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import org.simantics.databoard.binding.mutable.Variant;

public class SerializedVariable {

	private Map<String,SerializedVariable> children;
	private Map<String,SerializedVariable> properties;
	final public Variant value;
	final public String name;
	
	public SerializedVariable(String name, Variant value) {
		this.name = name;
		this.value = value;
	}
	
	@SuppressWarnings("unchecked")
	public <T> T getPossiblePropertyValue(String name) {
		if(properties == null) return null;
		SerializedVariable p = properties.get(name);
		if(p == null) return null;
		else return (T)p.value.getValue();
	}

	@SuppressWarnings("unchecked")
	public <T> T getPropertyValue(String name) {
		if(properties == null) throw new AssertionError("Property '" + name + "' does not exist.");
		SerializedVariable p = properties.get(name);
		if(p == null) throw new AssertionError("Property '" + name + "' does not exist.");
		else return (T)p.value.getValue();
	}
	
	public Collection<SerializedVariable> getProperties(){
		if(properties == null) return Collections.emptyList();
		return properties.values();
	}
	
	public static String print(SerializedVariable var, int indent) {
		StringBuilder b = new StringBuilder();
		b.append(var.name + " " + var.value.getValue());
		if(var.children != null) {
			for(Map.Entry<String, SerializedVariable> child : var.children.entrySet()) {
				b.append("\n");
				for(int i=0;i<indent;i++) b.append(" ");
				b.append("/" + print(child.getValue(), indent+2));
			}
		}
		if(var.properties != null) {
			for(Map.Entry<String, SerializedVariable> property : var.properties.entrySet()) {
				b.append("\n");
				for(int i=0;i<indent;i++) b.append(" ");
				b.append("#" + print(property.getValue(), indent+2));
			}
		}
		return b.toString();
	}
	
	public void addProperty(String name, SerializedVariable property) {
		if(properties == null) properties = new HashMap<String,SerializedVariable>();
		properties.put(name, property);
	}
	
}
