package org.simantics.structural.synchronization.base;

import java.util.function.BiConsumer;

public interface SolverNameUtil {

	String getFreshName(String parentName, String name);
	String ensureNameIsVariationOf(String parentName, int id, String name);

	/**
	 * The name utility can internally keep track of
	 * <code>suggested name -> generated
	 * fresh name</code> associations that it has had to perform during its
	 * lifetime in {@link #getFreshName(String, String)}. If the implementation
	 * keeps track of these renames, the purpose of this method is to check
	 * whether at the time of invocation it is possible to rename the solver
	 * components to their suggested names or not. For every rename that is
	 * performed, the specified consumer shall be invoked with the arguments
	 * <code>(previous name, new name)</code> after the rename has been
	 * performed.
	 * 
	 * <p>
	 * This method is intended to be invoked right at the end of
	 * synchronization.
	 * 
	 * @param callback
	 *            a binary consumer that takes as first argument the previous
	 *            name of the renamed component and as second argument the new
	 *            (current) name of the component or <code>null</code> to skip
	 *            callback invocation
	 */
	default void applySuggestedNames(BiConsumer<String, String> callback) {}

}
