/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.simulator.variable.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.VariantBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.error.RuntimeBindingException;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.type.Datatype;
import org.simantics.simulator.variable.NodeManager;
import org.simantics.simulator.variable.exceptions.NoSuchNodeException;
import org.simantics.simulator.variable.exceptions.NodeManagerException;

public abstract class AbstractNodeManager<Node>
implements NodeManager<Node> {
    static final Binding NO_BINDING = new VariantBinding(){

        public Object getContent(Object variant, Binding contentBinding) throws BindingException {
            throw new Error();
        }

        public Object getContent(Object variant) throws BindingException {
            throw new Error();
        }

        public Datatype getContentType(Object variant) throws BindingException {
            throw new Error();
        }

        public Binding getContentBinding(Object variant) throws BindingException {
            throw new Error();
        }

        public Object create(Binding contentBinding, Object content) throws BindingException {
            throw new Error();
        }

        public void setContent(Object variant, Binding contentBinding, Object content) throws BindingException {
            throw new Error();
        }

        public boolean isInstance(Object obj) {
            return true;
        }

        public void assertInstaceIsValid(Object obj, Set<Object> validInstances) throws BindingException {
            throw new Error();
        }

        public int compare(Object o1, Object o2) throws RuntimeBindingException {
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return -System.identityHashCode(o2);
            }
            if (o2 == null) {
                return System.identityHashCode(o1);
            }
            if (o1.equals(o2)) {
                return 0;
            }
            return System.identityHashCode(o1) - System.identityHashCode(o2);
        }
    };

    @Override
    public List<String> getChildNames(Node node) throws NodeManagerException {
        List<Node> children = this.getChildren(node);
        ArrayList<String> names = new ArrayList<String>(children.size());
        for (Node child : children) {
            names.add(this.getName(child));
        }
        return names;
    }

    @Override
    public List<String> getPropertyNames(Node node) throws NodeManagerException {
        List<Node> properties = this.getProperties(node);
        ArrayList<String> names = new ArrayList<String>(properties.size());
        for (Node property : properties) {
            names.add(this.getName(property));
        }
        return names;
    }

    @Override
    public Object getValue(Node node, String propertyName, Binding binding) throws NodeManagerException, BindingException {
        Node property = this.getProperty(node, propertyName);
        if (property == null) {
            throw new NoSuchNodeException("Didn't find a property " + propertyName);
        }
        return this.getValue(property, binding);
    }

    @Override
    public void setValue(Node node, String propertyName, Object value, Binding binding) throws NodeManagerException, BindingException {
        Node property = this.getProperty(node, propertyName);
        if (property == null) {
            throw new NoSuchNodeException("Didn't find a property " + propertyName);
        }
        this.setValue(property, value, binding);
    }

    @Override
    public Variant getValue(Node node) throws NodeManagerException {
        Datatype datatype = this.getDatatype(node);
        Binding binding = datatype != null ? Bindings.getBinding((Datatype)datatype) : NO_BINDING;
        try {
            Object value = this.getValue(node, binding);
            if (value instanceof Variant) {
                return (Variant)value;
            }
            return new Variant(binding, value);
        }
        catch (BindingException bindingException) {
            assert (false);
            return new Variant();
        }
    }

    @Override
    public Variant getValue(Node node, String propertyName) throws NodeManagerException {
        Node property = this.getProperty(node, propertyName);
        if (property == null) {
            throw new NoSuchNodeException("Didn't find a property " + propertyName);
        }
        return this.getValue(property);
    }

    @Override
    public String getPropertyURI(Node parent, Node property) {
        return null;
    }
}

