/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.document.ui.actions;

import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Display;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.document.AddDocumentAction;
import org.simantics.document.DocumentResource;
import org.simantics.layer0.Layer0;
import org.simantics.utils.ui.ExceptionUtils;
import org.simantics.utils.ui.validators.URLValidator;

/**
 * Action for adding URI-links as documents.
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 *
 */
public class AddUrlDocument extends AddDocumentAction {

	public AddUrlDocument(ReadGraph graph, String relationUri)
			throws DatabaseException {
		super(graph, relationUri);
	}


	@Override
	public Runnable create(Object target) {
		if(!(target instanceof Resource))
			return null;
		final Resource resource = (Resource)target;
		return new Runnable() {
			
			@Override
			public void run() {
				InputDialog dialog = new InputDialog(Display.getCurrent().getActiveShell(), Messages.AddUrlDocument_AddURL, Messages.AddUrlDocument_InputURL, "", new URLValidator()); //$NON-NLS-3$
				if (dialog.open() != InputDialog.OK)
					return;
				final String uriString = dialog.getValue();
				Simantics.getSession().asyncRequest(new WriteRequest() {
					@Override
					public void perform(WriteGraph graph)
							throws DatabaseException {
					    graph.markUndoPoint();
					    
						Layer0 l0 = Layer0.getInstance(graph);
						DocumentResource doc = DocumentResource.getInstance(graph);
						Resource urlDocument = graph.newResource();
						graph.claim(urlDocument, l0.InstanceOf, doc.UrlDocument);
						graph.claimLiteral(urlDocument, l0.HasName, uriString);
						graph.claimLiteral(urlDocument, doc.HasUrl, uriString);
						
						linkDocument(graph, resource, urlDocument);
					}
				}, e -> {
					if (e != null)
						ExceptionUtils.logAndShowError(Messages.AddUrlDocument_CannotAddURLLink, e);
				});
			}
		};
	}
	
}
