package org.simantics.db.service;



public final class ResourceUID {
    public static final ResourceUID Null = new ResourceUID(null);
    private final ClusterUID clusterUID;
    private final short index;
    private ResourceUID(ResourceUID a) {
        assert(null == a);
        clusterUID = ClusterUID.Null;
        index = 0;
    }
    public ResourceUID(long first, long second, long index) {
        this.clusterUID = ClusterUID.make(first, second);
        if (index < 1 || index > 1<<14) // TODO: use ClusterTraits.RESOURCE_USED_BITS
            throw new IllegalArgumentException("Trying to create illegal resource. index=" + index + " cluster=" + clusterUID);
        this.index = (short)index;
    }
    public ResourceUID(long[] longs, int offset) {
        if (longs.length < offset + 3)
            throw new IllegalArgumentException("Not enough data to create resource uid. length=" + longs.length + " offset=" + offset); 
        this.clusterUID = ClusterUID.make(longs[offset+0], longs[offset+1]);
        index = (short)longs[offset+2];
        if (index < 1 || index > 1<<14) // TODO: use ClusterTraits.RESOURCE_USED_BITS
            throw new IllegalArgumentException("Trying to create illegal resource. index=" + index + " cluster=" + clusterUID);
    }
    public int getIndex() {
        return index;
    }
    public ClusterUID asCID() {
        return clusterUID;
    }
    public static ResourceUID parse(String s) {
    	String[] ss = s.split("#");
    	if(ss.length != 3) throw new IllegalArgumentException("'" + s + "' is not a valid serialized ResourceUID");
    	long first = Long.parseLong(ss[0]);
    	long second = Long.parseLong(ss[1]);
    	short index = Short.parseShort(ss[2]);
    	return new ResourceUID(first, second, index);
    }
    public String serialized() {
    	return /*clusterUID.first +*/ "0#" + clusterUID.second + "#" + index;
    }
    public void toLong(long[] longs, int offset) {
        int i = clusterUID.toLong(longs, offset);
        longs[i] = index;
    }
    @Override
    public String toString() {
        return clusterUID.toString() + "." + index;
    }
    @Override
    public boolean equals(Object o) {
        if (this == o)
            return true;
        else if (!(o instanceof ResourceUID))
            return false;
        ResourceUID x = (ResourceUID)o;
        return clusterUID.equals(x.clusterUID) && index == x.index;
    }
    @Override
    public int hashCode() {
        int result = clusterUID.hashCode();
        result = 31 * result + index;
        return result;
    }
}
