/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.function.Consumer;
import org.simantics.db.debug.ListenerReport;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.query.CacheCollectionResult;
import org.simantics.db.impl.query.CacheEntry;
import org.simantics.db.impl.query.CacheEntryBase;
import org.simantics.db.impl.query.ListenerEntry;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.impl.query.UpdateEntry;
import org.simantics.db.procedure.ListenerBase;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.datastructures.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryListening {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryListening.class);
    private final QueryProcessor processor;
    private final Scheduler scheduler;
    private final Consumer<Runnable> consumer;
    private final Map<ListenerBase, ListenerEntry> addedEntries = new HashMap<ListenerBase, ListenerEntry>();
    private THashSet<ListenerEntry> scheduledListeners = new THashSet();
    private boolean firingListeners = false;
    final THashMap<CacheEntry, ArrayList<ListenerEntry>> listeners = new THashMap(10, 0.75f);

    QueryListening(QueryProcessor processor) {
        this.processor = processor;
        this.scheduler = new Scheduler(processor);
        this.consumer = this.scheduler.newConsumer();
        this.scheduler.start();
    }

    public boolean hasScheduledUpdates() {
        return !this.scheduledListeners.isEmpty();
    }

    void sync() {
        try {
            this.scheduler.flush();
        }
        catch (Throwable t) {
            LOGGER.error("Error while waiting for query dependency management", t);
        }
    }

    void registerDependencies(ReadGraphImpl graph, CacheEntry child, CacheEntry parent, ListenerBase listener, Object procedure, boolean inferred) {
        if (inferred) {
            assert (listener == null);
            return;
        }
        if (parent != null) {
            try {
                if (!child.isImmutable(graph)) {
                    this.consumer.accept(new RegisterParentRunnable(parent, child));
                }
            }
            catch (DatabaseException e) {
                LOGGER.error("Error while registering query dependencies", (Throwable)e);
            }
        }
        if (listener != null && !listener.isDisposed()) {
            this.consumer.accept(new RegisterListenerRunnable(this, listener, procedure, parent, child));
        }
    }

    void registerFirstKnown(ListenerBase base, Object result) {
        if (base == null) {
            return;
        }
        this.consumer.accept(() -> {
            ListenerEntry entry = this.addedEntries.remove(base);
            if (entry != null) {
                entry.setLastKnown(result);
            }
        });
    }

    void scheduleListener(ListenerEntry entry) {
        assert (entry != null);
        this.scheduledListeners.add((Object)entry);
    }

    boolean hasListener(CacheEntry entry) {
        return this.listeners.get((Object)entry) != null;
    }

    boolean hasListenerAfterDisposing(CacheEntry entry) {
        if (this.listeners.get((Object)entry) != null) {
            ArrayList entries = (ArrayList)this.listeners.get((Object)entry);
            ArrayList<ListenerEntry> list = null;
            for (ListenerEntry e : entries) {
                if (!e.base.isDisposed()) continue;
                if (list == null) {
                    list = new ArrayList<ListenerEntry>();
                }
                list.add(e);
            }
            if (list != null) {
                for (ListenerEntry e : list) {
                    entries.remove(e);
                }
            }
            if (entries.isEmpty()) {
                this.listeners.remove((Object)entry);
                return false;
            }
            return true;
        }
        return false;
    }

    void processListenerReport(CacheEntry<?> entry, Map<CacheEntry, Set<ListenerBase>> workarea) {
        if (!workarea.containsKey(entry)) {
            HashSet<ListenerBase> ls = new HashSet<ListenerBase>();
            for (ListenerEntry listenerEntry : this.getListenerEntries(entry)) {
                ls.add(listenerEntry.base);
            }
            workarea.put(entry, ls);
            for (CacheEntry cacheEntry : entry.getParents(this.processor)) {
                this.processListenerReport(cacheEntry, workarea);
                ls.addAll((Collection)workarea.get(cacheEntry));
            }
        }
    }

    public synchronized ListenerReport getListenerReport() throws IOException {
        class ListenerReportImpl
        implements ListenerReport {
            Map<CacheEntry, Set<ListenerBase>> workarea = new HashMap<CacheEntry, Set<ListenerBase>>();

            ListenerReportImpl() {
            }

            public void print(PrintStream b) {
                HashMap<ListenerBase, Integer> hist = new HashMap<ListenerBase, Integer>();
                for (Map.Entry<CacheEntry, Set<ListenerBase>> e : this.workarea.entrySet()) {
                    Iterator<ListenerBase> iterator = e.getValue().iterator();
                    while (iterator.hasNext()) {
                        ListenerBase l;
                        Integer i = (Integer)hist.get(l = iterator.next());
                        hist.put(l, i != null ? i - 1 : -1);
                    }
                }
                for (Pair p : CollectionUtils.valueSortedEntries(hist)) {
                    b.print(-((Integer)p.second).intValue() + " " + p.first + "\n");
                }
                b.flush();
            }
        }
        ListenerReportImpl result = new ListenerReportImpl();
        Collection<CacheEntryBase> all = this.processor.allCaches(new CacheCollectionResult()).toCollection();
        for (CacheEntryBase entry : all) {
            this.hasListenerAfterDisposing(entry);
        }
        for (CacheEntryBase entry : all) {
            this.processListenerReport(entry, result.workarea);
        }
        return result;
    }

    public synchronized String reportListeners(File file) throws IOException {
        if (!this.processor.isAlive()) {
            return "Disposed!";
        }
        PrintStream b = new PrintStream(new BufferedOutputStream(new FileOutputStream(file)));
        ListenerReport report = this.getListenerReport();
        report.print(b);
        return "Done reporting listeners.";
    }

    public void fireListeners(ReadGraphImpl graph) {
        assert (!this.processor.updating);
        assert (!this.processor.cache.collecting);
        assert (!this.firingListeners);
        this.firingListeners = true;
        try {
            while (!this.scheduledListeners.isEmpty()) {
                CacheEntry entry;
                THashSet<ListenerEntry> entries = this.scheduledListeners;
                this.scheduledListeners = new THashSet();
                ArrayList<ListenerEntry> schedule = new ArrayList<ListenerEntry>();
                for (ListenerEntry listenerEntry : entries) {
                    if (this.pruneListener(listenerEntry)) continue;
                    entry = listenerEntry.entry;
                    assert (entry != null);
                    Object newValue = this.processor.compareTo(graph, entry, listenerEntry.getLastKnown());
                    if (newValue == ListenerEntry.NOT_CHANGED) continue;
                    schedule.add(listenerEntry);
                    listenerEntry.setLastKnown(entry.getResult());
                }
                for (ListenerEntry listenerEntry : schedule) {
                    entry = listenerEntry.entry;
                    try {
                        entry.performFromCache(graph, listenerEntry.procedure);
                    }
                    catch (Throwable t) {
                        LOGGER.error("Unexpected exception ", t);
                    }
                }
            }
        }
        finally {
            this.firingListeners = false;
        }
    }

    void updateParents(int indent, CacheEntry entry, LinkedList<UpdateEntry> todo) {
        Iterable<CacheEntry<?>> oldParents = entry.getParents(this.processor);
        for (CacheEntry<?> parent : oldParents) {
            if (parent.isDiscarded()) continue;
            todo.push(new UpdateEntry(entry, parent, indent + 2));
        }
    }

    private boolean pruneListener(ListenerEntry entry) {
        if (entry.base.isDisposed()) {
            assert (entry != null);
            ArrayList list = (ArrayList)this.listeners.get((Object)entry.entry);
            if (list != null) {
                boolean success = list.remove(entry);
                assert (success);
                if (list.isEmpty()) {
                    this.listeners.remove((Object)entry.entry);
                }
            }
            return true;
        }
        return false;
    }

    private List<ListenerEntry> getListenerEntries(CacheEntry entry) {
        this.hasListenerAfterDisposing(entry);
        if (this.listeners.get((Object)entry) != null) {
            return (List)this.listeners.get((Object)entry);
        }
        return Collections.emptyList();
    }

    private static class RegisterListenerRunnable
    implements Runnable {
        private final QueryListening queryListening;
        private final ListenerBase base;
        private final Object procedure;
        private final CacheEntry parent;
        private final CacheEntry entry;

        public RegisterListenerRunnable(QueryListening queryListening, ListenerBase base, Object procedure, CacheEntry parent, CacheEntry entry) {
            this.queryListening = queryListening;
            this.base = base;
            this.procedure = procedure;
            this.parent = parent;
            this.entry = entry;
        }

        @Override
        public void run() {
            ListenerEntry result;
            int currentIndex;
            assert (this.entry != null);
            assert (this.procedure != null);
            ArrayList<ListenerEntry> list = (ArrayList<ListenerEntry>)this.queryListening.listeners.get((Object)this.entry);
            if (list == null) {
                list = new ArrayList<ListenerEntry>(1);
                this.queryListening.listeners.put((Object)this.entry, list);
            }
            if ((currentIndex = list.indexOf(result = new ListenerEntry(this.entry, this.base, this.procedure))) > -1) {
                ListenerEntry current = (ListenerEntry)list.get(currentIndex);
                if (!current.base.isDisposed()) {
                    return;
                }
                list.set(currentIndex, result);
            } else {
                list.add(result);
            }
            this.queryListening.addedEntries.put(this.base, result);
        }
    }

    private static class RegisterParentRunnable
    implements Runnable {
        private final CacheEntry parent;
        private final CacheEntry child;

        public RegisterParentRunnable(CacheEntry parent, CacheEntry child) {
            this.parent = parent;
            this.child = child;
        }

        @Override
        public void run() {
            this.child.addParent(this.parent);
        }
    }

    private static class Scheduler {
        private static final int BUFFER_SIZE = 100;
        private final QueryProcessor processor;
        private final ThreadQueue queues = new ThreadQueue();
        private Semaphore flush = null;

        Scheduler(QueryProcessor processor) {
            this.processor = processor;
        }

        private boolean isTerminated() {
            return this.processor.isDisposed();
        }

        Consumer<Runnable> newConsumer() {
            return task -> {
                ArrayList l = (ArrayList)this.queues.get();
                l.add(task);
                if (l.size() == 100) {
                    this.queues.remove();
                    this.queues.sendToExecution();
                }
            };
        }

        void start() {
            Thread thread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void run() {
                    var1_1 = Scheduler.access$0(this);
                    synchronized (var1_1) {
                        block11: {
                            while (true) {
                                if (Scheduler.access$1(this)) {
                                    return;
                                }
                                try {
                                    qs = Scheduler.access$0(this).getDispatchedQueues();
                                    var4_5 = qs.iterator();
                                    block6: while (true) {
                                        block12: {
                                            if (var4_5.hasNext()) break block12;
                                            if (Scheduler.access$2(this) == null) break block11;
                                            var4_5 = ThreadQueue.access$2(Scheduler.access$0(this)).values().iterator();
                                            if (true) ** GOTO lbl34
                                        }
                                        queue = var4_5.next();
                                        var6_7 = queue.iterator();
                                        while (true) {
                                            if (!var6_7.hasNext()) continue block6;
                                            r = var6_7.next();
                                            r.run();
                                        }
                                        break;
                                    }
                                }
                                catch (InterruptedException e) {
                                    QueryListening.access$0().error("Unexpected interrupt", (Throwable)e);
                                }
                                break;
                            }
                            do {
                                queue = var4_5.next();
                                for (Runnable r : queue) {
                                    r.run();
                                }
                                queue.clear();
lbl34:
                                // 2 sources

                            } while (var4_5.hasNext());
                            s = Scheduler.access$2(this);
                            Scheduler.access$3(this, null);
                            s.release();
                        }
                        Scheduler.access$0(this).wait(1000L);
                        ** continue;
                    }
                }
            };
            thread.setName("QueryListening");
            thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Semaphore createFlush() {
            ThreadQueue threadQueue = this.queues;
            synchronized (threadQueue) {
                this.flush = new Semaphore(0);
                this.queues.notify();
                return this.flush;
            }
        }

        void flush() {
            try {
                this.createFlush().acquire();
            }
            catch (InterruptedException e) {
                LOGGER.error("Unexpected interrupt", (Throwable)e);
            }
        }

        static /* synthetic */ ThreadQueue access$0(Scheduler scheduler) {
            return scheduler.queues;
        }

        static /* synthetic */ boolean access$1(Scheduler scheduler) {
            return scheduler.isTerminated();
        }

        static /* synthetic */ Semaphore access$2(Scheduler scheduler) {
            return scheduler.flush;
        }

        static /* synthetic */ void access$3(Scheduler scheduler, Semaphore semaphore) {
            scheduler.flush = semaphore;
        }
    }

    private static class ThreadQueue
    extends ThreadLocal<ArrayList<Runnable>> {
        private final Map<Thread, ArrayList<Runnable>> allQueues = new HashMap<Thread, ArrayList<Runnable>>();
        private ArrayList<ArrayList<Runnable>> dispatchedQueues = new ArrayList();

        private ThreadQueue() {
        }

        @Override
        protected synchronized ArrayList<Runnable> initialValue() {
            ArrayList<Runnable> result = new ArrayList<Runnable>();
            this.allQueues.put(Thread.currentThread(), result);
            return result;
        }

        synchronized void sendToExecution() {
            ArrayList<Runnable> rs = this.allQueues.remove(Thread.currentThread());
            this.dispatchedQueues.add(rs);
            this.notify();
        }

        synchronized ArrayList<ArrayList<Runnable>> getDispatchedQueues() {
            ArrayList<ArrayList<Runnable>> result = this.dispatchedQueues;
            this.dispatchedQueues = new ArrayList();
            return result;
        }

        static /* synthetic */ Map access$2(ThreadQueue threadQueue) {
            return threadQueue.allQueues;
        }
    }
}

