/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import gnu.trove.impl.hash.THash;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.query.CacheEntry;
import org.simantics.db.impl.query.Query;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.impl.query.QuerySupport;

public abstract class QueryIdentityHash
extends THash {
    static final long serialVersionUID = -3461112548087185871L;
    protected transient CacheEntry[] _set;
    protected static final CacheEntry REMOVED = new CacheEntry(){

        @Override
        public void addParent(CacheEntry entry) {
        }

        @Override
        public void clearResult(QuerySupport support) {
        }

        @Override
        public void discard() {
        }

        @Override
        public void except(Throwable t) {
        }

        public Iterable<CacheEntry> getParents(QueryProcessor processor) {
            return null;
        }

        @Override
        public Query getQuery() {
            return null;
        }

        @Override
        public boolean hasParents() {
            return false;
        }

        @Override
        public boolean isDiscarded() {
            return false;
        }

        @Override
        public boolean isExcepted() {
            return false;
        }

        @Override
        public boolean isFresh() {
            return false;
        }

        @Override
        public boolean isPending() {
            return false;
        }

        @Override
        public boolean isReady() {
            return false;
        }

        @Override
        public boolean isRefuted() {
            return false;
        }

        @Override
        public void refute() {
        }

        @Override
        CacheEntry pruneFirstParents() {
            return null;
        }

        @Override
        public void removeParent(CacheEntry entry) {
        }

        @Override
        public void setPending(QuerySupport querySupport) {
        }

        @Override
        public void setReady() {
        }

        @Override
        public void setResult(Object result) {
        }

        @Override
        boolean isImmutable(ReadGraphImpl graph) {
            return true;
        }

        @Override
        boolean shouldBeCollected() {
            return false;
        }

        @Override
        CacheEntry getFirstParent(QueryProcessor processor) {
            return null;
        }

        @Override
        boolean moreThanOneParent(QueryProcessor processor) {
            return false;
        }

        @Override
        int parentCount(QueryProcessor processor) {
            return 0;
        }

        @Override
        short getLevel() {
            return 0;
        }

        @Override
        short setLevel(short level) {
            return level;
        }

        @Override
        void prepareRecompute(QuerySupport querySupport) {
        }

        @Override
        int getGCStatus() {
            return 0;
        }

        @Override
        int setGCStatus(int status) {
            return 0;
        }

        @Override
        void setGCStatusFlag(int flag, boolean value) {
        }

        @Override
        public Object getOriginalRequest() {
            throw new UnsupportedOperationException();
        }

        Object performFromCache(ReadGraphImpl graph, Object procedure) throws DatabaseException {
            return null;
        }

        public Object getResult() {
            return null;
        }

        @Override
        void pruneParentSet() {
        }
    };

    public QueryIdentityHash() {
    }

    public QueryIdentityHash(int initialCapacity) {
        super(initialCapacity, 0.75f);
    }

    public final int capacity() {
        return this._set.length;
    }

    protected final void removeAt(int index) {
        this._set[index] = REMOVED;
        super.removeAt(index);
    }

    protected final int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._set = new CacheEntry[capacity];
        return capacity;
    }

    public final boolean contains(Object obj) {
        return this.index(obj) >= 0;
    }

    protected final int index(Object obj) {
        CacheEntry[] set = this._set;
        int length = set.length;
        int hash = obj.hashCode() & Integer.MAX_VALUE;
        int index = hash % length;
        CacheEntry cur = set[index];
        if (cur == null) {
            return -1;
        }
        if (cur == REMOVED || cur != obj) {
            int probe = 1 + hash % (length - 2);
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while ((cur = set[index]) != null && (cur == REMOVED || cur != obj));
        }
        return cur == null ? -1 : index;
    }

    protected final int insertionIndex(Object obj) {
        CacheEntry[] set = this._set;
        int length = set.length;
        int hash = obj.hashCode() & Integer.MAX_VALUE;
        int index = hash % length;
        CacheEntry cur = set[index];
        if (cur == null) {
            return index;
        }
        if (cur != REMOVED && cur == obj) {
            return -index - 1;
        }
        int probe = 1 + hash % (length - 2);
        if (cur != REMOVED) {
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while ((cur = set[index]) != null && cur != REMOVED && cur != obj);
        }
        if (cur == REMOVED) {
            int firstRemoved = index;
            while (cur != null && (cur == REMOVED || cur != obj)) {
                if ((index -= probe) < 0) {
                    index += length;
                }
                cur = set[index];
            }
            return cur != null ? -index - 1 : firstRemoved;
        }
        return cur != null ? -index - 1 : index;
    }
}

