/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.tests;

import junit.framework.TestCase;

import org.simantics.databoard.Datatypes;
import org.simantics.databoard.annotations.Length;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.RecordType;
import org.simantics.databoard.util.Range;

public class TestMultiDimension extends TestCase {
	
	public static class Image {

		public Image() {}
		
		public @Length({"320", "240"}) RGB[][] pixels;
		
	}
	
	public static class RGB {
		
		int r;
		int g;
		int b;
		
	}	
	
	public void testMultiDim() {
        Datatype dt = Datatypes.getDatatypeUnchecked( Image.class );
        RecordType rt = (RecordType) dt;
        ArrayType at = (ArrayType) rt.getComponentType(0);
        assertEquals(at.getLength(), Range.create(320));
        ArrayType at2 = (ArrayType) at.componentType;
        assertEquals(at2.getLength(), Range.create(240));
         
	}
	
}

