/*******************************************************************************
 * Copyright (c) 2017 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.nativemem.internal.linux;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;

import org.simantics.nativemem.internal.Resource;

/**
 * @author Tuukka Lehtonen
 * @since 1.29.0
 */
public class Stat {

	private static final String SELF_STATM = "/proc/self/statm";
	private static final Charset ASCII = Charset.forName("US-ASCII");

	public static long getCurrentRSS(Resource r) {
		try (BufferedReader rdr = Files.newBufferedReader(Paths.get(SELF_STATM), ASCII)) {
			String line = rdr.readLine();
			String[] nums = line.split(" ");
			if (nums.length == 0)
				return 0L;
			long rss = Long.parseLong(nums[0]);
			long pageSize = r.sysconf(Resource._SC_PAGESIZE);
			return rss * pageSize;
		} catch (NumberFormatException e) {
			return 0L;
		} catch (IOException e) {
			return 0L;
		}
	}

}