/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.layer0.utils.instantiation;

import java.util.ArrayList;
import java.util.List;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.Literals;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;

public class Instance {
    public Resource equals = null;
    public List<RelatedInstance> relatedInstances = new ArrayList<RelatedInstance>();
    public Object value = null;

    public Instance() {
    }

    public Instance(Resource equals) {
        this.equals = equals;
    }

    public Resource instantiate(WriteGraph graph) throws DatabaseException {
        if (this.equals != null) {
            return this.equals;
        }
        Resource ret = graph.newResource();
        for (RelatedInstance instance : this.relatedInstances) {
            int i = 0;
            while (i < instance.cardinality) {
                graph.claim(ret, instance.relation, instance.instance.instantiate(graph));
                ++i;
            }
        }
        if (this.value != null) {
            graph.claimValue(ret, this.value);
        }
        return ret;
    }

    public Resource instantiateUsing(WriteGraph graph, Resource resource) throws DatabaseException {
        if (this.equals != null) {
            return this.equals;
        }
        Resource ret = resource;
        for (RelatedInstance instance : this.relatedInstances) {
            int i = 0;
            while (i < instance.cardinality) {
                graph.claim(ret, instance.relation, instance.instance.instantiate(graph));
                ++i;
            }
        }
        if (this.value != null) {
            graph.claimValue(ret, this.value);
        }
        return ret;
    }

    public void print(StringBuilder builder, int indentation, ReadGraph graph) throws DatabaseException {
        ++indentation;
        if (this.equals != null) {
            builder.append(NameUtils.getSafeName((ReadGraph)graph, (Resource)this.equals));
        } else {
            if (this.value != null) {
                builder.append(Literals.literalToString((Object)this.value));
                builder.append(" : ");
            } else {
                builder.append("* : ");
            }
            for (RelatedInstance instance : this.relatedInstances) {
                builder.append("\n");
                int i = 0;
                while (i < indentation) {
                    builder.append("    ");
                    ++i;
                }
                builder.append(NameUtils.getSafeName((ReadGraph)graph, (Resource)instance.relation));
                if (instance.cardinality != 1) {
                    builder.append("[" + instance.cardinality + "]");
                }
                builder.append(" = ");
                instance.instance.print(builder, indentation, graph);
            }
        }
    }

    public String toString(ReadGraph graph) throws DatabaseException {
        StringBuilder builder = new StringBuilder();
        this.print(builder, 0, graph);
        return builder.toString();
    }

    public static class RelatedInstance {
        Resource relation;
        Instance instance;
        int cardinality;
    }
}

