package org.simantics.db.testing.impl;
/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/


import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

import org.junit.Test;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.testing.base.ExistingDatabaseTest;
import org.simantics.layer0.Layer0;
public class TempTest extends ExistingDatabaseTest {
    @Test
    public void test() throws DatabaseException {
    	final Resource rl = getSession().getRootLibrary();
        getSession().syncRequest(new ReadRequest() {
            @Override
            public void run(ReadGraph g) throws DatabaseException {
                Layer0 b = Layer0.getInstance(g);
                Collection<Resource> rs = g.getObjects(rl, b.IsRelatedTo);
                Set<Resource> done = new HashSet<Resource>();
                Set<Resource> todo = new HashSet<Resource>();
                for (Resource r : rs)
                    todo.add(r);
                while (!todo.isEmpty()) {
                    Resource r = todo.iterator().next();
                    todo.remove(r);
                    done.add(r);
                    Collection<Resource> rs2 = g.getObjects(r, b.IsRelatedTo);
                    for (Resource rr : rs2)
                        if (!done.contains(rr))
                            todo.add(rr);
                    if (DEBUG)
                        System.out.println("" + done.size());
                }
                System.out.println("" + done.size());
            }
        });
    }
}