package org.simantics.db.testing.base;
/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/


import org.junit.Test;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;

abstract public class WriteReadTest extends ExistingDatabaseTest {
    protected Resource written;
    @Test
    public void test() throws Exception {
    	Session s = getSession();
    	s.syncRequest(new WriteRequest() {

    		@Override
    		public void perform(WriteGraph graph) throws DatabaseException {
    			written = graph.newResource();
    			write(graph);
    		}

    	});
    	s.syncRequest(new ReadRequest() {

    		@Override
    		public void run(ReadGraph graph) throws DatabaseException {
    			read(graph);
    		}

    	});
    }
    protected void write(WriteGraph graph) throws DatabaseException {}
    protected void read(ReadGraph graph) throws DatabaseException {}
}
