/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.graph.impl;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;
import org.simantics.db.Resource;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.utils.ui.ISelectionUtils;

/**
 * @author Antti Villberg
 */
public class WorkbenchSelectionResourceInputSource extends WorkbenchSelectionInputSource {

    /**
     * @thread SWT
     */
    @Override
    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        Object old = this.selection;
        this.selection = ISelectionUtils.getSinglePossibleKey(selection, SelectionHints.KEY_MAIN, Resource.class);
        //System.err.println("WorkbenchSelectionResourceInputSource.selectionChanged(" + part + ", " + this.selection + ")");
        fireIfInputChanged(old, selection);
    }

}
