/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.graph.impl;

import org.simantics.browsing.ui.common.property.IProperty;
import org.simantics.browsing.ui.common.property.IPropertyFactory;
import org.simantics.db.Resource;
import org.simantics.db.common.ResourceArray;
import org.simantics.utils.datastructures.slice.ValueRange;

/**
 * @author Tuukka Lehtonen
 */
public class ResourcePropertyFactory implements IPropertyFactory<ResourceProperty> {

    final IProperty.Type type;
    final Resource       subject;
    final Resource       predicate;
    final Resource       value;
    final ResourceArray  path;

    public ResourcePropertyFactory(IProperty.Type type, Resource subject, Resource predicate, Resource value, ResourceArray path) {
        this.type = type;
        this.subject = subject;
        this.predicate = predicate;
        this.value = value;
        this.path = path;
    }

    @Override
    public ResourceProperty create(ValueRange range) {
        if (range != null)
            return new ResourceArrayProperty(type, range, subject, predicate, value, path);
        return new ResourceProperty(type, subject, predicate, value, path);
    }

}
