/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.fmi.experiment;

import hdf.hdf5lib.H5;
import hdf.hdf5lib.HDF5Constants;
import hdf.hdf5lib.exceptions.HDF5Exception;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HDF5Support {
    private static final Logger LOGGER = LoggerFactory.getLogger(HDF5Support.class);
    private final File workingDirectory;
    private Set<String> storedIdSet = new LinkedHashSet<String>();
    private long file_id = -1L;
    private long time_mem_space = -1L;
    private long time_dset = -1L;
    private long time_file_space = -1L;
    private long time_plist = -1L;
    private long time_attribute_dataspace_id = -1L;
    private long time_attribute_id = -1L;
    private long file_space = -1L;
    private long mem_space = -1L;
    private long dset = -1L;
    private long plist = -1L;
    private long attribute_dataspace_id = -1L;
    private long attribute_id = -1L;
    private long columnCount = -1L;
    private int storedTimeSteps = 0;
    private String[] idsToStore = null;
    private int[] resultIndices = null;
    private double[] results = null;
    private Map<String, Integer> idIndices = new HashMap<String, Integer>();

    public HDF5Support(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public void store(String id) {
        if (this.idsToStore != null) {
            throw new IllegalStateException("Data collection has already started. Cannot update stored items anymore.");
        }
        this.storedIdSet.add(id);
    }

    public void start() {
        this.columnCount = this.storedIdSet.size();
        if (this.columnCount == 0L) {
            return;
        }
        this.results = new double[(int)this.columnCount];
        this.idsToStore = new String[(int)this.columnCount];
        int pos = 0;
        for (String id : this.storedIdSet) {
            this.idIndices.put(id, pos);
            this.idsToStore[pos++] = id;
        }
        this.storedIdSet = null;
        File f = new File(this.workingDirectory, "data.h5");
        try {
            this.file_id = H5.H5Fcreate((String)f.getAbsolutePath(), (int)HDF5Constants.H5F_ACC_TRUNC, (long)HDF5Constants.H5P_DEFAULT, (long)HDF5Constants.H5P_DEFAULT);
        }
        catch (Exception e) {
            LOGGER.error("Failed to create HDF5 file:" + f.getAbsolutePath(), (Throwable)e);
            return;
        }
        try {
            long[] lArray = new long[2];
            lArray[1] = this.columnCount;
            this.file_space = H5.H5Screate_simple((int)2, (long[])lArray, (long[])new long[]{HDF5Constants.H5S_UNLIMITED, this.columnCount});
            long[] lArray2 = new long[2];
            lArray2[1] = 1L;
            this.time_file_space = H5.H5Screate_simple((int)2, (long[])lArray2, (long[])new long[]{HDF5Constants.H5S_UNLIMITED, 1L});
        }
        catch (Exception e) {
            LOGGER.error("Failed to create HDF5 dataset space", (Throwable)e);
        }
        try {
            this.plist = H5.H5Pcreate((long)HDF5Constants.H5P_DATASET_CREATE);
            H5.H5Pset_layout((long)this.plist, (int)HDF5Constants.H5D_CHUNKED);
            H5.H5Pset_chunk((long)this.plist, (int)2, (long[])new long[]{2L, this.columnCount});
            this.time_plist = H5.H5Pcreate((long)HDF5Constants.H5P_DATASET_CREATE);
            H5.H5Pset_layout((long)this.time_plist, (int)HDF5Constants.H5D_CHUNKED);
            H5.H5Pset_chunk((long)this.time_plist, (int)2, (long[])new long[]{2L, 1L});
        }
        catch (Exception e) {
            LOGGER.error("Failed to create HDF5 plists", (Throwable)e);
        }
        try {
            this.dset = H5.H5Dcreate((long)this.file_id, (String)"subscriptions", (long)HDF5Constants.H5T_NATIVE_DOUBLE, (long)this.file_space, (long)HDF5Constants.H5P_DEFAULT, (long)this.plist, (long)HDF5Constants.H5P_DEFAULT);
            this.time_dset = H5.H5Dcreate((long)this.file_id, (String)"time", (long)HDF5Constants.H5T_NATIVE_DOUBLE, (long)this.time_file_space, (long)HDF5Constants.H5P_DEFAULT, (long)this.time_plist, (long)HDF5Constants.H5P_DEFAULT);
        }
        catch (Exception e) {
            LOGGER.error("Failed to create HDF5 datasets", (Throwable)e);
        }
        try {
            long type = H5.H5Tcopy((long)HDF5Constants.H5T_C_S1);
            H5.H5Tset_size((long)type, (long)HDF5Constants.H5T_VARIABLE);
            this.attribute_dataspace_id = H5.H5Screate_simple((int)1, (long[])new long[]{this.columnCount}, (long[])new long[]{this.columnCount});
            this.attribute_id = H5.H5Acreate((long)this.dset, (String)"variableName", (long)type, (long)this.attribute_dataspace_id, (long)HDF5Constants.H5P_DEFAULT, (long)HDF5Constants.H5P_DEFAULT);
            int subSize = this.idIndices.keySet().size();
            String[] prod_titles = new String[subSize];
            for (String key : this.idIndices.keySet()) {
                int position = this.idIndices.get(key);
                prod_titles[position] = key;
            }
            H5.H5AwriteVL((long)this.attribute_id, (long)type, (String[])prod_titles);
            this.time_attribute_dataspace_id = H5.H5Screate_simple((int)1, (long[])new long[]{1L}, (long[])new long[]{1L});
            this.time_attribute_id = H5.H5Acreate((long)this.time_dset, (String)"variableName", (long)type, (long)this.time_attribute_dataspace_id, (long)HDF5Constants.H5P_DEFAULT, (long)HDF5Constants.H5P_DEFAULT);
            H5.H5AwriteVL((long)this.time_attribute_id, (long)type, (String[])new String[]{"time"});
        }
        catch (Exception e) {
            LOGGER.error("Failed to create HDF5 attributes", (Throwable)e);
        }
        try {
            H5.H5Pclose((long)this.plist);
            H5.H5Pclose((long)this.time_plist);
            H5.H5Sclose((long)this.file_space);
            H5.H5Sclose((long)this.time_file_space);
            H5.H5Sclose((long)this.attribute_dataspace_id);
            H5.H5Aclose((long)this.attribute_id);
            H5.H5Sclose((long)this.time_attribute_dataspace_id);
            H5.H5Aclose((long)this.time_attribute_id);
        }
        catch (Exception e) {
            LOGGER.error("Failed to close HDF5 properly", (Throwable)e);
        }
    }

    public void end() {
        if (this.columnCount == 0L) {
            return;
        }
        try {
            H5.H5Dclose((long)this.time_dset);
            H5.H5Dclose((long)this.dset);
            H5.H5Fclose((long)this.file_id);
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    public void invalidateSubscriptionNames() {
        this.resultIndices = null;
    }

    public void update(List<String> subNames, double[] subResults, double time) throws NullPointerException, HDF5Exception {
        if (this.columnCount == 0L) {
            return;
        }
        if (this.resultIndices == null) {
            this.resultIndices = new int[subNames.size()];
            int subIndex = 0;
            for (String s : subNames) {
                Integer index = this.idIndices.get(s);
                this.resultIndices[subIndex] = index != null ? index : -1;
                ++subIndex;
            }
        }
        int i = 0;
        while (i < subResults.length) {
            int index = -1;
            if (this.resultIndices.length > i) {
                index = this.resultIndices[i];
            }
            if (index != -1) {
                this.results[index] = subResults[i];
            }
            ++i;
        }
        try {
            this.mem_space = H5.H5Screate_simple((int)2, (long[])new long[]{1L, this.columnCount}, null);
            this.time_mem_space = H5.H5Screate_simple((int)2, (long[])new long[]{1L, 1L}, null);
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
        try {
            H5.H5Dset_extent((long)this.dset, (long[])new long[]{this.storedTimeSteps + 1, this.columnCount});
            H5.H5Dset_extent((long)this.time_dset, (long[])new long[]{this.storedTimeSteps + 1, 1L});
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
        try {
            this.file_space = H5.H5Dget_space((long)this.dset);
            this.time_file_space = H5.H5Dget_space((long)this.time_dset);
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
        long[] lArray = new long[2];
        lArray[0] = this.storedTimeSteps;
        long[] start = lArray;
        long[] count = new long[]{1L, this.columnCount};
        long[] time_count = new long[]{1L, 1L};
        try {
            H5.H5Sselect_hyperslab((long)this.file_space, (int)HDF5Constants.H5S_SELECT_SET, (long[])start, null, (long[])count, null);
            H5.H5Sselect_hyperslab((long)this.time_file_space, (int)HDF5Constants.H5S_SELECT_SET, (long[])start, null, (long[])time_count, null);
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
        try {
            H5.H5Dwrite_double((long)this.dset, (long)HDF5Constants.H5T_NATIVE_DOUBLE, (long)this.mem_space, (long)this.file_space, (long)HDF5Constants.H5P_DEFAULT, (double[])this.results);
            H5.H5Dwrite_double((long)this.time_dset, (long)HDF5Constants.H5T_NATIVE_DOUBLE, (long)this.time_mem_space, (long)this.time_file_space, (long)HDF5Constants.H5P_DEFAULT, (double[])new double[]{time});
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
        try {
            H5.H5Sclose((long)this.file_space);
            H5.H5Sclose((long)this.mem_space);
            H5.H5Sclose((long)this.time_file_space);
            H5.H5Sclose((long)this.time_mem_space);
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
        ++this.storedTimeSteps;
    }
}

