/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.fmi.experiment;

import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.File;
import java.math.BigDecimal;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Semaphore;
import org.eclipse.core.runtime.IProgressMonitor;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.BooleanBinding;
import org.simantics.databoard.binding.NumberBinding;
import org.simantics.databoard.binding.StringBinding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.fmi.experiment.FMIChildNode;
import org.simantics.fmi.experiment.FMIExperimentDataFrame;
import org.simantics.fmi.experiment.FMIFolderNode;
import org.simantics.fmi.experiment.FMINodeBase;
import org.simantics.fmi.experiment.FMIValueNode;
import org.simantics.fmi.experiment.FMIVariableNode;
import org.simantics.fmi.experiment.HDF5Subscriptions;
import org.simantics.fmi.experiment.HDF5Support;
import org.simantics.fmi.experiment.IFMIExperiment;
import org.simantics.fmil.core.FMIL;
import org.simantics.fmil.core.FMILException;
import org.simantics.simulator.ExperimentState;
import org.simantics.simulator.toolkit.DynamicExperimentThread;
import org.simantics.simulator.toolkit.DynamicExperimentThreadListener;
import org.simantics.simulator.toolkit.StandardExperimentStates;
import org.simantics.simulator.variable.exceptions.NoValueException;
import org.simantics.simulator.variable.exceptions.NodeManagerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FMIExperiment
implements IFMIExperiment {
    private static final Logger LOGGER = LoggerFactory.getLogger(FMIExperiment.class);
    private static boolean FORCE_DOUBLE = false;
    private FMIExperimentDataFrame frame;
    private FMIL fmu;
    private String identifier;
    private HDF5Subscriptions subscriptions;
    private Set<String> variableNames;
    private TObjectIntMap<String> variableTypes;
    protected FMISimulatorThread thread;
    private final FMIFolderNode ROOT = new FMIFolderNode(null, "");
    private final HDF5Support hdf;
    private boolean initialized = false;
    private Semaphore stopSemaphore = new Semaphore(0);
    private DynamicExperimentThreadListener stopListener = new DynamicExperimentThreadListener(){

        public void stateChanged(ExperimentState newState) {
            if (newState == StandardExperimentStates.STOPPED) {
                FMIExperiment.this.stopSemaphore.release();
            }
        }
    };

    @Override
    public FMINodeBase getRootNode() {
        return this.ROOT;
    }

    private void createNodeImpl(FMIFolderNode folder, String variableName) {
        String[] parts = variableName.split("\\.");
        int i = 0;
        while (i < parts.length) {
            if (i == parts.length - 1) {
                FMIVariableNode variable = new FMIVariableNode(folder, parts[i]);
                folder.addChild(variable);
            } else {
                FMIChildNode node = folder.getChild(parts[i]);
                if (node == null) {
                    FMIFolderNode child = new FMIFolderNode(folder, parts[i]);
                    folder.addChild(child);
                    folder = child;
                } else {
                    folder = (FMIFolderNode)node;
                }
            }
            ++i;
        }
    }

    private void createNodes(String[] names) {
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            this.createNodeImpl(this.ROOT, name);
            ++n2;
        }
    }

    public FMIExperiment(File fmuFile) throws Exception {
        this(new File(Paths.get(".", new String[0]).toAbsolutePath().normalize().toString()), fmuFile, UUID.randomUUID().toString());
    }

    public FMIExperiment(File workingDirectory, File fmuFile, String id) throws Exception {
        Semaphore started = new Semaphore(0);
        this.hdf = new HDF5Support(workingDirectory);
        this.thread = new FMISimulatorThread(started, fmuFile, id);
        if (Boolean.parseBoolean(System.getProperty("org.simantics.fmi.forcedouble"))) {
            FORCE_DOUBLE = true;
        }
        this.thread.start();
        started.acquire();
        if (this.thread.error != null) {
            throw this.thread.error;
        }
        if (this.fmu == null) {
            throw new IllegalStateException("No fmu loaded!");
        }
    }

    @Override
    public void addListener(DynamicExperimentThreadListener listener) {
        this.thread.addListener(listener);
    }

    @Override
    public void removeListener(DynamicExperimentThreadListener listener) {
        this.thread.removeListener(listener);
    }

    public <T> T getService(Class<T> clazz) {
        return null;
    }

    @Override
    public Collection<String> getVariables() {
        return this.variableNames;
    }

    @Override
    public boolean subscribe(String id) throws FMILException {
        return this.fmu.subscribe(id);
    }

    @Override
    public boolean store(String id) throws FMILException {
        return this.store(id, false);
    }

    public boolean store(String name, boolean force) throws FMILException {
        block6: {
            block5: {
                if (this.initialized) {
                    throw new IllegalStateException("Stored variables cannot be set after initialization.");
                }
                try {
                    if (!force) break block5;
                    this.subscribe(name);
                    this.hdf.store(name);
                    return true;
                }
                catch (Exception e) {
                    LOGGER.error("Failed to subscribe/store variable <" + name + ">. Ignoring", (Throwable)e);
                    return false;
                }
            }
            Object value = this.getVariableValueById(name);
            if (value == null) break block6;
            this.subscribe(name);
            this.hdf.store(name);
            return true;
        }
        LOGGER.error("Tried to subscribe to a variable that might be Internal datatype: <" + name + ">. Ignoring.");
        System.err.println("Tried to subscribe to a variable that might be Internal datatype: <" + name + ">. Ignoring.");
        return false;
    }

    protected <V> V callInThread(Callable<V> call) {
        Semaphore done = new Semaphore(0);
        RuntimeException[] e = new RuntimeException[1];
        Object[] value = new Object[1];
        this.thread.queue(() -> {
            try {
                try {
                    objectArray[0] = call.call();
                }
                catch (RuntimeException e2) {
                    runtimeExceptionArray[0] = e2;
                    done.release();
                }
                catch (Exception e1) {
                    LOGGER.error("Error from FMU task", (Throwable)e1);
                    done.release();
                }
            }
            finally {
                done.release();
            }
        });
        try {
            done.acquire();
        }
        catch (InterruptedException e1) {
            throw new RuntimeException("Wait for FMI simulation thread " + this.thread.getName() + " was interrupted", e1);
        }
        if (e[0] != null) {
            throw e[0];
        }
        return (V)value[0];
    }

    @Override
    public void setVariableValueById(String id, Object value, Binding binding) {
        block14: {
            if (Thread.currentThread() != this.thread) {
                this.callInThread(() -> {
                    this.setVariableValueById(id, value, binding);
                    return null;
                });
                return;
            }
            try {
                if (this.variableNames.contains(id)) {
                    switch (this.variableTypes.get((Object)id)) {
                        case 0: {
                            if (binding instanceof NumberBinding) {
                                this.fmu.setRealValue(id, ((NumberBinding)binding).getValue(value).doubleValue());
                                break block14;
                            }
                            throw new IllegalArgumentException("Invalid binding for variable '" + id + "' (real): " + binding);
                        }
                        case 1: 
                        case 4: {
                            if (binding instanceof NumberBinding) {
                                this.fmu.setIntegerValue(id, ((NumberBinding)binding).getValue(value).intValue());
                                break block14;
                            }
                            throw new IllegalArgumentException("Invalid binding for variable '" + id + "' (integer): " + binding);
                        }
                        case 2: {
                            if (binding instanceof BooleanBinding) {
                                this.fmu.setBooleanValue(id, ((BooleanBinding)binding).getValue_(value));
                                break block14;
                            }
                            throw new IllegalArgumentException("Invalid binding for variable '" + id + "' (integer): " + binding);
                        }
                        case 3: {
                            if (binding instanceof StringBinding) {
                                this.fmu.setStringValue(id, ((StringBinding)binding).getValue(value));
                                break block14;
                            }
                            throw new IllegalArgumentException("Invalid binding for variable '" + id + "' (integer): " + binding);
                        }
                        default: {
                            throw new IllegalStateException("Invalid FMI type code (" + this.variableTypes.get((Object)id) + ") for variable '" + id + "'");
                        }
                    }
                }
                this.frame.setValue(id, value);
            }
            catch (BindingException | FMILException e) {
                LOGGER.error("Cannot set variable value for id '" + id + "'", e);
            }
        }
    }

    @Override
    public Object getVariableValueById(String id) {
        if (Thread.currentThread() != this.thread) {
            return this.callInThread(() -> this.getVariableValueById(id));
        }
        try {
            if (this.variableNames.contains(id)) {
                switch (this.variableTypes.get((Object)id)) {
                    case 0: {
                        return this.fmu.getRealValue(id);
                    }
                    case 1: 
                    case 4: {
                        return this.fmu.getIntegerValue(id);
                    }
                    case 2: {
                        return this.fmu.getBooleanValue(id);
                    }
                    case 3: {
                        return this.fmu.getStringValue(id);
                    }
                }
                throw new IllegalStateException("Unknwon FMI variable type code (" + this.variableTypes.get((Object)id) + ") for variable '" + id + "'");
            }
            return this.frame.getValue(id);
        }
        catch (FMILException e) {
            LOGGER.error("Cannot retrieve variable value for id '" + id + "'", (Throwable)e);
            return null;
        }
    }

    @Override
    public Object getVariableValueById(String id, Binding binding) {
        if (Thread.currentThread() != this.thread) {
            return this.callInThread(() -> this.getVariableValueById(id, binding));
        }
        try {
            if (this.variableNames.contains(id)) {
                switch (this.variableTypes.get((Object)id)) {
                    case 0: {
                        if (binding instanceof NumberBinding) {
                            return ((NumberBinding)binding).create((Number)this.fmu.getRealValue(id));
                        }
                        throw new IllegalArgumentException("Non-suitable binding for real variable '" + id + "': " + binding);
                    }
                    case 1: 
                    case 4: {
                        if (binding instanceof NumberBinding) {
                            return ((NumberBinding)binding).create((Number)this.fmu.getIntegerValue(id));
                        }
                        throw new IllegalArgumentException("Non-suitable binding for integer variable '" + id + "': " + binding);
                    }
                    case 2: {
                        if (binding instanceof BooleanBinding) {
                            return ((BooleanBinding)binding).create(this.fmu.getBooleanValue(id));
                        }
                        throw new IllegalArgumentException("Non-suitable binding for boolean variable '" + id + "': " + binding);
                    }
                    case 3: {
                        if (binding instanceof StringBinding) {
                            return ((StringBinding)binding).create(this.fmu.getStringValue(id));
                        }
                        throw new IllegalArgumentException("Non-suitable binding for string variable '" + id + "': " + binding);
                    }
                }
                throw new IllegalStateException("Unknwon FMI variable type code (" + this.variableTypes.get((Object)id) + ") for variable '" + id + "'");
            }
            Object value = this.frame.getValue(id);
            if (value == null) {
                return value;
            }
            if (!binding.isInstance(value)) {
                throw new IllegalArgumentException("Non-suitable binding for variable '" + id + "' (" + value.getClass().getName() + "): " + binding);
            }
            return value;
        }
        catch (BindingException | FMILException e) {
            LOGGER.error("Cannot retrive variable value for id '" + id + "'", e);
            return null;
        }
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public ExperimentState getStateL() {
        return this.thread.getExperimentState();
    }

    public void changeStateL(ExperimentState state) {
        this.thread.changeState(state);
    }

    protected boolean inState(Class<? extends ExperimentState> state) {
        return this.thread.inState(state);
    }

    public void shutdown(IProgressMonitor monitor) {
        this.changeStateL(StandardExperimentStates.TO_BE_DISPOSED);
    }

    protected void doDispose() {
        block7: {
            if (this.inState(StandardExperimentStates.Disposed.class)) {
                return;
            }
            this.changeStateL(StandardExperimentStates.DISPOSED);
            try {
                try {
                    if (this.fmu != null) {
                        this.fmu.unloadFMU();
                    }
                }
                catch (FMILException e) {
                    LOGGER.error("FMIExperiment.shutdown: fmu.unloadFMU failed", (Throwable)e);
                    this.fmu = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                this.fmu = null;
                throw throwable;
            }
            this.fmu = null;
        }
        this.hdf.end();
    }

    private void fetchSubscriptionsAndTime() throws Exception {
        double time = this.fmu.getTime();
        List subs = this.fmu.getSubscribedNames();
        double[] results = this.fmu.getSubscribedResults();
        this.frame = this.frame != null ? new FMIExperimentDataFrame(time, this.frame) : new FMIExperimentDataFrame(time, results.length);
        int i = 0;
        while (i < results.length) {
            this.frame.setValue((String)subs.get(i), results[i]);
            ++i;
        }
        this.hdf.update(subs, results, time);
    }

    public void simulate(boolean enabled) {
        if (enabled) {
            this.checkInitialization();
            long simulationStepNs = BigDecimal.valueOf(0.1).multiply(BigDecimal.valueOf(1.0E9)).longValue();
            this.thread.setSimulationStepNs(simulationStepNs);
            long runDurationNs = Long.MAX_VALUE;
            this.thread.runDuration(runDurationNs);
        } else {
            this.thread.runDuration(0L);
        }
    }

    public void simulateDuration(double duration) {
        this.checkInitialization();
        long simulationStepNs = BigDecimal.valueOf(duration).multiply(BigDecimal.valueOf(1.0E9)).longValue();
        this.thread.setSimulationStepNs(simulationStepNs);
        this.thread.runDuration(simulationStepNs);
    }

    @Override
    public void simulateDurationSync(double duration) {
        this.checkInitialization();
        long simulationStepNs = BigDecimal.valueOf(duration).multiply(BigDecimal.valueOf(1.0E9)).longValue();
        this.thread.addListener(this.stopListener);
        try {
            try {
                this.thread.setSimulationStepNs(simulationStepNs);
                this.thread.runDuration(simulationStepNs);
                this.stopSemaphore.acquire();
            }
            catch (InterruptedException e) {
                LOGGER.warn("simulateDurationSync interrupted", (Throwable)e);
                this.thread.removeListener(this.stopListener);
            }
        }
        finally {
            this.thread.removeListener(this.stopListener);
        }
    }

    private void checkInitialization() {
        if (!this.initialized) {
            try {
                this.fmu.initializeSimulation();
                this.hdf.start();
                this.fetchSubscriptionsAndTime();
                this.initialized = true;
                this.changeStateL(StandardExperimentStates.INITIALIZED);
            }
            catch (Exception e) {
                LOGGER.error("simulation initialization failed", (Throwable)e);
                this.initialized = false;
            }
        }
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public boolean initializeSimulation() {
        if (this.fmu == null) {
            return false;
        }
        if (!this.initialized) {
            this.checkInitialization();
        }
        return this.initialized;
    }

    @Override
    public FMIExperimentDataFrame getCurrentDataFrame() {
        return this.frame;
    }

    public double getSimulationTime() {
        return this.frame.getTime();
    }

    public void doStep(double stepLengthMilliseconds) {
        try {
            this.fmu.setStepLength(stepLengthMilliseconds * 0.001);
            this.fmu.simulateStep();
            this.fetchSubscriptionsAndTime();
        }
        catch (Exception e) {
            LOGGER.error("Exception while stepping ", (Throwable)e);
            this.thread.changeState(StandardExperimentStates.STOPPED);
        }
    }

    public void setEngineValue(FMINodeBase node, Object value) throws NodeManagerException {
        try {
            String name = node.getVariableName();
            if (this.variableNames.contains(name)) {
                switch (this.variableTypes.get((Object)name)) {
                    case 0: {
                        if (!(value instanceof Number)) {
                            throw new IllegalArgumentException("Illegal value type (" + value.getClass() + ") for real variable '" + name + "'");
                        }
                        this.fmu.setRealValue(name, ((Number)value).doubleValue());
                        break;
                    }
                    case 1: 
                    case 4: {
                        if (!(value instanceof Number)) {
                            throw new IllegalArgumentException("Illegal value type (" + value.getClass() + ") for integer variable '" + name + "'");
                        }
                        this.fmu.setIntegerValue(name, ((Number)value).intValue());
                        break;
                    }
                    case 2: {
                        if (!(value instanceof Boolean)) {
                            throw new IllegalArgumentException("Illegal value type (" + value.getClass() + ") for boolean variable '" + name + "'");
                        }
                        this.fmu.setBooleanValue(name, ((Boolean)value).booleanValue());
                        break;
                    }
                    case 3: {
                        if (!(value instanceof String)) {
                            throw new IllegalArgumentException("Illegal value type (" + value.getClass() + ") for string variable '" + name + "'");
                        }
                        this.fmu.setStringValue(name, (String)value);
                    }
                    default: {
                        throw new IllegalStateException("Unknown FMU type code (" + this.variableTypes.get((Object)name) + ") for variable '" + name + "'");
                    }
                }
            }
            if (this.getStateL() == StandardExperimentStates.STOPPED || this.getStateL() == StandardExperimentStates.INITIALIZED || this.getStateL() == StandardExperimentStates.INSTANTIATED) {
                this.frame.setValue(node.getVariableName(), value);
            }
        }
        catch (FMILException e) {
            throw new NodeManagerException((Throwable)e);
        }
    }

    @Override
    public Object getEngineValueById(String id) throws NodeManagerException {
        try {
            this.subscribe(id);
        }
        catch (FMILException e) {
            throw new NodeManagerException((Throwable)e);
        }
        Object value = this.frame.getValue(id);
        if (value != null) {
            return value;
        }
        try {
            return this.thread.syncExec(() -> {
                Object v = this.getVariableValueById(id);
                this.frame.setValue(id, v);
                return v;
            });
        }
        catch (InterruptedException e) {
            throw new NodeManagerException((Throwable)e);
        }
    }

    public Object getEngineValue(FMINodeBase node) throws NodeManagerException {
        if (node instanceof FMIValueNode) {
            String id = ((FMIChildNode)node.parent).getPath();
            return this.getEngineValueById(id);
        }
        return null;
    }

    public Binding getEngineBinding(FMINodeBase node) throws NodeManagerException {
        if (!FORCE_DOUBLE) {
            String id = node.getVariableName();
            if (this.variableNames.contains(id)) {
                switch (this.variableTypes.get((Object)id)) {
                    case 0: {
                        return Bindings.DOUBLE;
                    }
                    case 1: 
                    case 4: {
                        return Bindings.INTEGER;
                    }
                    case 2: {
                        return Bindings.BOOLEAN;
                    }
                    case 3: {
                        return Bindings.STRING;
                    }
                }
                throw new IllegalStateException("Unknown FMU type code (" + this.variableTypes.get((Object)id) + ") for variable '" + id + "'");
            }
            Object value = this.frame.getValue(id);
            if (value != null) {
                try {
                    return Bindings.getBinding(value.getClass());
                }
                catch (BindingConstructionException e) {
                    throw new NodeManagerException("Value of unknown type (" + value.getClass() + ") for variable '" + id + "'", (Throwable)e);
                }
            }
            throw new NoValueException();
        }
        return Bindings.DOUBLE;
    }

    public String getName(FMINodeBase node) {
        return node.name;
    }

    public Map<String, FMINodeBase> getChildren(FMINodeBase node) {
        if (node instanceof FMIChildNode) {
            List<FMINodeBase> childList = ((FMIChildNode)node).getChildren();
            HashMap<String, FMINodeBase> result = new HashMap<String, FMINodeBase>(childList.size());
            for (FMINodeBase child : childList) {
                result.put(child.name, child);
            }
            return result;
        }
        return Collections.emptyMap();
    }

    public Map<String, FMINodeBase> getProperties(FMINodeBase node) {
        if (node instanceof FMIVariableNode) {
            List<FMINodeBase> childList = ((FMIVariableNode)node).getProperties();
            HashMap<String, FMINodeBase> result = new HashMap<String, FMINodeBase>(childList.size());
            for (FMINodeBase child : childList) {
                result.put(child.name, child);
            }
            return result;
        }
        return Collections.emptyMap();
    }

    class FMISimulatorThread
    extends DynamicExperimentThread {
        final Semaphore started;
        private final File fmuFile;
        private final String id;
        Exception error = null;

        FMISimulatorThread(Semaphore started, File fmuFile, String id) {
            this.started = started;
            this.fmuFile = fmuFile;
            this.id = id;
        }

        public void step(double stepLengthNanoSeconds) {
            this.fireBeforeStep();
            FMIExperiment.this.doStep(stepLengthNanoSeconds * 1.0E-6);
            this.fireAfterStep();
        }

        public void initialize() throws Exception {
            try {
                try {
                    FMIExperiment.this.identifier = this.id;
                    FMIExperiment.this.fmu = null;
                    FMIL tempFmu = new FMIL();
                    String absPath = this.fmuFile.getAbsolutePath();
                    FMIExperiment.this.subscriptions = new HDF5Subscriptions(this.fmuFile.getAbsolutePath());
                    tempFmu.loadFMUFile(absPath);
                    tempFmu.instantiateSimulation();
                    String[] names = tempFmu.getAllVariables();
                    FMIExperiment.this.createNodes(names);
                    int[] types = tempFmu.getAllVariableTypes();
                    FMIExperiment.this.variableTypes = (TObjectIntMap)new TObjectIntHashMap(names.length, 0.5f, -1);
                    int i = 0;
                    while (i < names.length) {
                        FMIExperiment.this.variableTypes.put((Object)names[i], types[i]);
                        ++i;
                    }
                    FMIExperiment.this.variableNames = FMIExperiment.this.variableTypes.keySet();
                    FMIExperiment.this.frame = new FMIExperimentDataFrame(0.0, FMIExperiment.this.variableNames.size());
                    for (String s : FMIExperiment.this.variableNames) {
                        FMIExperiment.this.frame.setValue(s, 0.0);
                    }
                    FMIExperiment.this.changeStateL(StandardExperimentStates.INSTANTIATED);
                    FMIExperiment.this.fmu = tempFmu;
                    ArrayList<String> notSuccessful = new ArrayList<String>();
                    for (String sub : FMIExperiment.this.subscriptions.getAll()) {
                        if (FMIExperiment.this.store(sub, false)) continue;
                        notSuccessful.add(sub);
                    }
                    for (String sub : notSuccessful) {
                        FMIExperiment.this.store(sub, true);
                    }
                }
                catch (FMILException e) {
                    this.error = e;
                    throw new Exception(e);
                }
                catch (IllegalArgumentException e) {
                    this.error = e;
                    throw new Exception(e);
                }
                catch (SecurityException e) {
                    this.error = e;
                    throw new Exception(e);
                }
            }
            finally {
                this.started.release();
            }
        }

        public void deinitialize() throws Exception {
            FMIExperiment.this.doDispose();
        }
    }
}

