/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.structural.ui;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

/**
 * The activator class controls the plug-in life cycle
 */
public class Activator extends AbstractUIPlugin {

    // The plug-in ID
    public static final String PLUGIN_ID = "org.simantics.structural.ui";

    // The shared instance
    private static Activator plugin;

    private static LocalResourceManager resourceManager;

    public static ImageDescriptor SYNCED_ICON;
    public static ImageDescriptor SHOW_ALL_CHILDREN_ICON;
    public static ImageDescriptor LOCK;

    /**
     * The constructor
     */
    public Activator() {
    }

    /*
     * (non-Javadoc)
     * @see org.eclipse.core.runtime.Plugins#start(org.osgi.framework.BundleContext)
     */
    @Override
    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;

        Bundle bundle = context.getBundle();

        SYNCED_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/synced.gif"));
        SHOW_ALL_CHILDREN_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/text_linespacing.png"));
        LOCK = ImageDescriptor.createFromURL(bundle.getResource("icons/lock.png"));
    }

    /*
     * (non-Javadoc)
     * @see org.eclipse.core.runtime.Plugin#stop(org.osgi.framework.BundleContext)
     */
    @Override
    public void stop(BundleContext context) throws Exception {
        if (resourceManager != null) {
            resourceManager.dispose();
            resourceManager = null;
        }

        plugin = null;
        super.stop(context);
    }

    /**
     * Returns the shared instance
     *
     * @return the shared instance
     */
    public static Activator getDefault() {
        return plugin;
    }

    public static ResourceManager initializeResourceManager(Display display) {
        if (resourceManager == null) {
            resourceManager = new LocalResourceManager(JFaceResources.getResources(display));
        }
        return resourceManager;
    }

    public static ResourceManager getResources() {
        if (resourceManager == null)
            throw new IllegalStateException("ResourceManager of bundle '" + PLUGIN_ID + "' is not initialized.");
        return resourceManager;
    }

}
