/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.project.management;

import java.io.IOException;

import org.simantics.db.DatabaseUserAgent;
import org.simantics.db.Driver;
import org.simantics.db.Manager;
import org.simantics.db.exception.DatabaseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerManagerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerManagerFactory.class);

    public static ServerManager create(String databaseDriverId, String address) throws IOException, DatabaseException {
        Driver driver = Manager.getDriver(databaseDriverId);
        if (driver == null)
            throw new IllegalArgumentException("Database driver with ID " + databaseDriverId + " could not be found!");
        LOGGER.info("ServerManagerFactory.create called with id {}, driver is {}.", databaseDriverId, driver);
        DatabaseUserAgent agent = Manager.getUserAgent(databaseDriverId);
        if (agent != null)
            driver.setDatabaseUserAgent(address, agent);
        return new ServerManager(driver);
    }

}