/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.project.adapters;

import java.util.Collection;

import org.eclipse.core.runtime.CoreException;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.adaption.SimpleAdapter;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.exception.ValidationException;
import org.simantics.project.IProject;
import org.simantics.project.ProjectFeatures;
import org.simantics.project.exception.ProjectException;
import org.simantics.project.features.IProjectFeature;
import org.simantics.project.features.registry.IProjectFeatureExtension;
import org.simantics.project.impl.Project;
import org.simantics.project.ontology.ProjectResource;

/**
 * @author Tuukka Lehtonen
 */
public class ProjectAdapter extends SimpleAdapter<IProject> {

    @Override
    public IProject adapt(ReadGraph g, Resource resource) throws DatabaseException {
        ProjectResource PROJ = ProjectResource.getInstance(g);
        if (!g.isInstanceOf(resource, PROJ.Project))
            throw new ValidationException("Cannot adapt resource " + NameUtils.getSafeName(g, resource) + " to IProject. Resource is not an instance of " + ProjectResource.URIs.Project);

        Project p = new Project(g.getSession(), resource);
        //System.out.println("NEW PROJECT: " + p + " (  " + System.identityHashCode(p) + ")");
        try {
            Collection<IProjectFeatureExtension> sorted = ProjectFeatures.getTopologicallySortedFeatures(g, p.get());
            loadFeatures(g, p, sorted);
            return p;
        } catch (ProjectException e) {
            throw new ValidationException("project feature loading failed", e);
        }
    }

    private void loadFeatures(ReadGraph g, Project p, Collection<IProjectFeatureExtension> sortedFeatures) throws ProjectException, ValidationException, ServiceException {
        for (IProjectFeatureExtension feature : sortedFeatures) {
            try {
                IProjectFeature pf = feature.newInstance();
                p.addFeature(pf);
            } catch (CoreException e) {
                throw new ValidationException(e);
            }
        }
    }

}
