/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.utils;

import java.util.Collection;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.CommonDBUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.ModelingUtils;
import org.simantics.modeling.adapters.ChangeHistoryUpdated;
import org.simantics.modeling.adapters.ChangeInformation;

public class OntologicalRequirementEnforceRequest
extends WriteRequest {
    private Collection<Resource> creates;
    private Collection<Resource> modis;
    private Collection<Resource> ids;
    private String author;
    private long time;

    public OntologicalRequirementEnforceRequest(Collection<Resource> creates, Collection<Resource> modis, Collection<Resource> ids) {
        this(creates, modis, ids, System.getProperty("user.name", ""), System.currentTimeMillis());
    }

    public OntologicalRequirementEnforceRequest(Collection<Resource> creates, Collection<Resource> modis, Collection<Resource> ids, String author, long time) {
        this.creates = creates;
        this.modis = modis;
        this.ids = ids;
        this.author = author;
        this.time = time;
    }

    public void perform(WriteGraph graph) throws DatabaseException {
        OntologicalRequirementEnforceRequest.update(graph, this.creates, this.modis, this.ids, true, this.author, this.time, true);
    }

    public static void update(WriteGraph graph, Collection<Resource> creates, Collection<Resource> modis, Collection<Resource> ids, boolean addComment, boolean disableDependencyIndexing) throws DatabaseException {
        OntologicalRequirementEnforceRequest.update(graph, creates, modis, ids, addComment, System.getProperty("user.name", ""), System.currentTimeMillis(), disableDependencyIndexing);
    }

    public static void update(WriteGraph graph, Collection<Resource> creates, Collection<Resource> modis, Collection<Resource> ids, boolean addComment, String author, long time, boolean disableDependencyIndexing) throws DatabaseException {
        if (disableDependencyIndexing) {
            Layer0Utils.setDependenciesIndexingDisabled((WriteOnlyGraph)graph, (boolean)true);
        }
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        if (!creates.isEmpty()) {
            ChangeInformation info = new ChangeInformation();
            info.createdAt = time;
            info.createdBy = author;
            info.modifiedAt = time;
            info.modifiedBy = author;
            for (Resource c : creates) {
                CommonDBUtils.selectClusterSet((WriteGraph)graph, (Resource)c);
                graph.claimLiteral(c, MOD.changeInformation, MOD.changeInformation_Inverse, MOD.ChangeInformation, (Object)info, ChangeInformation.BINDING);
                ModelingUtils.markChanged(graph, c);
            }
        }
        for (Resource m : modis) {
            ChangeInformation info = (ChangeInformation)graph.getPossibleRelatedValue(m, MOD.changeInformation, ChangeInformation.BINDING);
            if (info == null) {
                info = new ChangeInformation();
                info.createdAt = time;
                info.createdBy = author;
            }
            info.modifiedAt = time;
            info.modifiedBy = author;
            CommonDBUtils.selectClusterSet((WriteGraph)graph, (Resource)m);
            graph.claimLiteral(m, MOD.changeInformation, MOD.changeInformation_Inverse, MOD.ChangeInformation, (Object)info, ChangeInformation.BINDING);
            ModelingUtils.markChanged(graph, m);
        }
        for (Resource r : ids) {
            if (graph.hasStatement(r, L0.identifier)) continue;
            CommonDBUtils.selectClusterSet((WriteGraph)graph, (Resource)r);
            Layer0Utils.claimNewIdentifier((WriteGraph)graph, (Resource)r, (boolean)true);
        }
        graph.addMetadata((Metadata)((CommentMetadata)graph.getMetadata(CommentMetadata.class)).add("Updated change information"));
        graph.addMetadata(graph.getMetadata(ChangeHistoryUpdated.class));
    }
}

