/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.QueryIndexUtils;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.modeling.LifeCycleContext;
import org.simantics.modeling.ModelingResources;
import org.simantics.project.exception.ProjectException;
import org.simantics.project.features.AbstractProjectFeature;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.scl.runtime.tuple.Tuple0;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LifeCycleProcesses
extends AbstractProjectFeature {
    private static final Logger LOGGER = LoggerFactory.getLogger(LifeCycleProcesses.class);
    Set<LifeCycleContext> contexts = Collections.emptySet();

    public void configure() throws ProjectException {
        try {
            this.contexts = (Set)Simantics.getSession().syncRequest((Read)new Read<Set<LifeCycleContext>>(){

                public Set<LifeCycleContext> perform(ReadGraph graph) throws DatabaseException {
                    HashSet<LifeCycleContext> contexts = new HashSet<LifeCycleContext>();
                    ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
                    for (Resource indexRoot : Layer0Utils.listIndexRoots((ReadGraph)graph)) {
                        for (Resource lcp : QueryIndexUtils.searchByTypeShallow((ReadGraph)graph, (Resource)indexRoot, (Resource)MOD.LifeCycleProcess)) {
                            Variable unloadProperty;
                            LOGGER.trace("Loading life cycle process " + graph.getURI(lcp));
                            Function1 load = null;
                            Function1 unload = null;
                            Variable loadProperty = Variables.tryGetProperty((ReadGraph)graph, (Resource)lcp, (Resource)MOD.LifeCycleProcess_load);
                            if (loadProperty != null) {
                                load = (Function1)loadProperty.getPossibleValue(graph);
                            }
                            if ((unloadProperty = Variables.tryGetProperty((ReadGraph)graph, (Resource)lcp, (Resource)MOD.LifeCycleProcess_unload)) != null) {
                                unload = (Function1)unloadProperty.getPossibleValue(graph);
                            }
                            LifeCycleContext lcc = new LifeCycleContext(lcp, (Function1<LifeCycleContext, Tuple0>)load, (Function1<LifeCycleContext, Tuple0>)unload);
                            contexts.add(lcc);
                        }
                    }
                    return contexts;
                }
            });
            this.contexts.forEach(LifeCycleContext::load);
        }
        catch (DatabaseException e) {
            throw new ProjectException((Throwable)e);
        }
    }

    public void deconfigure() throws ProjectException {
        this.contexts.forEach(LifeCycleContext::unload);
    }
}

