/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagramEditor;

import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPartSite;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.request.ResourceRead2;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.IsLinkedTo;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.diagram.adapter.GraphToDiagramSynchronizer;
import org.simantics.diagram.content.Change;
import org.simantics.diagram.content.DiagramContentChanges;
import org.simantics.diagram.content.DiagramContentTracker;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.synchronization.runtime.DiagramSelectionUpdater;
import org.simantics.diagram.ui.DiagramModelHints;
import org.simantics.diagram.ui.ElementClassTransferable;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.impl.DependencyReflection;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.DiagramUtils;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.PickContext;
import org.simantics.g2d.diagram.handler.PickRequest;
import org.simantics.g2d.diagram.participant.AbstractDiagramParticipant;
import org.simantics.g2d.dnd.DnDHints;
import org.simantics.g2d.dnd.ElementClassDragItem;
import org.simantics.g2d.dnd.IDnDContext;
import org.simantics.g2d.dnd.IDragItem;
import org.simantics.g2d.dnd.IDropTargetParticipant;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.participant.TransformUtil;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.ui.Activator;
import org.simantics.modeling.ui.diagramEditor.Messages;
import org.simantics.modeling.ui.diagramEditor.WSEDragItem;
import org.simantics.modeling.ui.diagramEditor.dnd.DropSuggestion;
import org.simantics.modeling.ui.diagramEditor.dnd.DropSuggestions;
import org.simantics.scenegraph.g2d.snap.ISnapAdvisor;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.ui.dnd.LocalObjectTransfer;
import org.simantics.ui.dnd.LocalObjectTransferable;
import org.simantics.ui.selection.WorkbenchSelectionElement;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.logging.TimeLogger;
import org.simantics.utils.strings.EString;
import org.simantics.utils.ui.SWTUtils;
import org.simantics.utils.ui.dialogs.ShowError;
import org.simantics.utils.ui.workbench.WorkbenchUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopulateElementDropParticipant
extends AbstractDiagramParticipant
implements IDropTargetParticipant {
    private static final Logger LOGGER = LoggerFactory.getLogger(PopulateElementDropParticipant.class);
    private static final IHintContext.Key KEY_SUGGESTIONS = new IHintContext.KeyOf(List.class);
    @DependencyReflection.Dependency
    PickContext pickContext;
    @DependencyReflection.Dependency
    TransformUtil transformUtil;
    protected GraphToDiagramSynchronizer synchronizer;
    protected IWorkbenchPartSite partSite;

    public PopulateElementDropParticipant(GraphToDiagramSynchronizer synchronizer) {
        this(synchronizer, null);
    }

    public PopulateElementDropParticipant(GraphToDiagramSynchronizer synchronizer, IWorkbenchPartSite partSite) {
        this.synchronizer = synchronizer;
        this.partSite = partSite;
    }

    public void dragEnter(DropTargetDragEvent dtde, IDnDContext dp) {
        if (this.diagram == null) {
            return;
        }
        Transferable tr = dtde.getTransferable();
        if (tr.isDataFlavorSupported(LocalObjectTransferable.FLAVOR)) {
            IStructuredSelection sel;
            Object obj = null;
            try {
                obj = tr.getTransferData(LocalObjectTransferable.FLAVOR);
            }
            catch (UnsupportedFlavorException | IOException e) {
                LOGGER.error("Could not get AWT transferable data", (Throwable)e);
            }
            if (!(obj instanceof IStructuredSelection)) {
                obj = LocalObjectTransfer.getTransfer().getObject();
            }
            if (obj instanceof IStructuredSelection && !(sel = (IStructuredSelection)obj).isEmpty()) {
                for (Object elm : sel.toList()) {
                    if (!(elm instanceof IAdaptable)) continue;
                    ElementClass ec = (ElementClass)((IAdaptable)elm).getAdapter(ElementClass.class);
                    if (ec != null) {
                        dp.add((Object)new ElementClassDragItem(ec));
                        continue;
                    }
                    Resource r = (Resource)((IAdaptable)elm).getAdapter(Resource.class);
                    if (r == null) continue;
                    try {
                        Object errorOrSymbolResource = this.validateDrag((RequestProcessor)this.synchronizer.getSession(), r, (Resource)this.diagram.getHint(DiagramModelHints.KEY_DIAGRAM_RESOURCE), dp.getHints());
                        if (!(errorOrSymbolResource instanceof Resource)) continue;
                        Resource symbol = (Resource)errorOrSymbolResource;
                        ElementClassDragItem item = new ElementClassDragItem(this.synchronizer.getNodeClass(symbol));
                        item.getHintContext().setHint(ElementHints.KEY_TRANSFORM, (Object)AffineTransform.getScaleInstance(1.0, 1.0));
                        item.getHintContext().setHint(ElementHints.KEY_OBJECT, (Object)symbol);
                        dp.add((Object)item);
                    }
                    catch (DatabaseException e) {
                        LOGGER.debug("Could not retrieve node class for dropped symbol", (Throwable)e);
                    }
                }
                dp.getHints().removeHint(DnDHints.KEY_DND_GRID_COLUMNS);
            }
            return;
        }
        if (tr.isDataFlavorSupported(ElementClassTransferable.FLAVOR)) {
            ElementClassTransferable.ResourceElementClassTransferData dada;
            try {
                dada = (ElementClassTransferable.ResourceElementClassTransferData)tr.getTransferData(ElementClassTransferable.FLAVOR);
            }
            catch (UnsupportedFlavorException e) {
                throw new Error(e);
            }
            catch (IOException e) {
                throw new Error(e);
            }
            Session s = this.synchronizer.getSession();
            try {
                String[] stringArray = dada.elementClassResourceRandomAccessReference;
                int n = dada.elementClassResourceRandomAccessReference.length;
                int n2 = 0;
                while (n2 < n) {
                    String rid = stringArray[n2];
                    SerialisationSupport support = (SerialisationSupport)s.getService(SerialisationSupport.class);
                    Resource r = support.getResource(Long.parseLong(rid));
                    dp.add((Object)new ElementClassDragItem(this.synchronizer.getNodeClass(r)));
                    ++n2;
                }
            }
            catch (DatabaseException e) {
                throw new RuntimeException(e);
            }
            return;
        }
    }

    private Object validateDrag(RequestProcessor processor, Resource draggedResource, Resource dropTarget, IHintContext dndHints) throws DatabaseException {
        return processor.syncRequest(graph -> {
            Resource componentType;
            Resource componentTypeFromDiagram;
            ArrayList<DropSuggestion> suggestions = (ArrayList<DropSuggestion>)dndHints.getHint(KEY_SUGGESTIONS);
            if (suggestions == null) {
                suggestions = new ArrayList<DropSuggestion>();
                dndHints.setHint(KEY_SUGGESTIONS, suggestions);
            }
            Resource sourceRoot = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(draggedResource));
            Resource targetRoot = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(dropTarget));
            if (sourceRoot != null && !((Boolean)graph.syncRequest((Read)new IsLinkedTo(targetRoot, sourceRoot))).booleanValue()) {
                if (((Boolean)graph.syncRequest((Read)new IsLinkedTo(sourceRoot, targetRoot))).booleanValue()) {
                    return NLS.bind((String)"Cannot instantiate {0} into namespace {1}. The source namespace ({2}) is already linked to the target namespace. Linking the target to the source would form a dependency cycle.", (Object[])new Object[]{NameUtils.getSafeName((ReadGraph)graph, (Resource)draggedResource), NameUtils.getURIOrSafeNameInternal((ReadGraph)graph, (Resource)targetRoot), NameUtils.getURIOrSafeNameInternal((ReadGraph)graph, (Resource)sourceRoot)});
                }
                suggestions.add(DropSuggestions.linkToLibrary(graph, targetRoot, sourceRoot));
            }
            ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
            StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
            Resource configurationComposite = graph.getPossibleObject(dropTarget, MOD.DiagramToComposite);
            Resource resource3 = componentTypeFromDiagram = configurationComposite != null ? graph.getPossibleObject(configurationComposite, STR.Defines) : null;
            if (componentTypeFromDiagram != null && Layer0Utils.isPublished((ReadGraph)graph, (Resource)componentTypeFromDiagram)) {
                return "Cannot create elements into a diagram that belongs to a published user component.";
            }
            Resource symbol = graph.getPossibleObject(draggedResource, MOD.ComponentTypeToSymbol);
            if (symbol != null) {
                componentType = draggedResource;
            } else {
                componentType = graph.getPossibleObject(draggedResource, MOD.SymbolToComponentType);
                symbol = draggedResource;
            }
            if (componentType != null && configurationComposite != null && componentTypeFromDiagram != null && componentType.equals(componentTypeFromDiagram)) {
                return "Cannot instantiate user component within its own configuration.";
            }
            return symbol;
        });
    }

    public void dragExit(DropTargetEvent dte, IDnDContext dp) {
    }

    public void dragOver(DropTargetDragEvent dtde, IDnDContext dp) {
    }

    private IElement tryPick(Point p) {
        Point2D canvas = this.transformUtil.controlToCanvas((Point2D)p, null);
        this.assertDependencies();
        PickRequest req = new PickRequest(canvas);
        req.pickPolicy = PickRequest.PickPolicy.PICK_INTERSECTING_OBJECTS;
        ArrayList picks = new ArrayList();
        this.pickContext.pick(this.diagram, req, picks);
        if (picks.size() == 1) {
            return (IElement)picks.iterator().next();
        }
        return null;
    }

    public void drop(DropTargetDropEvent dtde, IDnDContext dp) {
        TimeLogger.resetTimeAndLog(((Object)((Object)this)).getClass(), (String)"drop");
        Point loc = dtde.getLocation();
        IDiagram d = this.diagram;
        if (d == null) {
            return;
        }
        try {
            this.validateDrop(d, dp, () -> this.performDrop(d, loc, dp));
        }
        catch (DatabaseException e) {
            LOGGER.error("Element drop validation failed", (Throwable)e);
        }
    }

    private void validateDrop(IDiagram diagram, IDnDContext dp, Runnable dropFunction) throws DatabaseException {
        List reqs = (List)dp.getHints().getHint(KEY_SUGGESTIONS);
        if (reqs != null && !reqs.isEmpty()) {
            Shell parentShell = this.partSite.getWorkbenchWindow().getShell();
            SWTUtils.asyncExec((Widget)parentShell, () -> {
                if (parentShell.isDisposed()) {
                    return;
                }
                if (!DropSuggestions.askSuggestions(parentShell, reqs)) {
                    return;
                }
                try {
                    Simantics.getSession().syncRequest(DropSuggestions.performSuggestionsRequest(reqs));
                    this.getThread().asyncExec(() -> {
                        if (this.isRemoved()) {
                            return;
                        }
                        dropFunction.run();
                    });
                }
                catch (DatabaseException e) {
                    String format = Messages.PopulateElementDropParticipant_PreDropFixesFailed;
                    String formattedSuggestions = EString.implode((Collection)reqs);
                    LOGGER.error(format, (Object)formattedSuggestions, (Object)e);
                    ShowError.showError((String)Messages.PopulateElementDropParticipant_PreDropFixesFailed_Title, (String)NLS.bind((String)format, (Object)formattedSuggestions), (Throwable)e);
                }
            });
        } else {
            dropFunction.run();
        }
    }

    private void performDrop(IDiagram d, Point loc, IDnDContext dp) {
        IElement pick = this.tryPick(loc);
        if (pick != null) {
            List wses = Arrays.stream((IDragItem[])dp.toArray()).filter(WSEDragItem.class::isInstance).map(di -> (WorkbenchSelectionElement)((WSEDragItem)((Object)di)).getObject()).collect(Collectors.toList());
            Resource element = (Resource)ElementUtils.getData((IDiagram)d, (IElement)pick);
            if (element != null && !wses.isEmpty()) {
                try {
                    Session db = Simantics.getSession();
                    DiagramResource DIA = DiagramResource.getInstance((RequestProcessor)db);
                    Variable function = (Variable)db.syncRequest((Read)new PossibleVariableProperty(element, DIA.symbolDropHandler));
                    if (function != null) {
                        db.syncRequest(graph -> {
                            Object object = Simantics.invokeSCLWrite((WriteGraph)graph, (Variable)function, (Object)wses);
                        });
                        return;
                    }
                }
                catch (DatabaseException e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.simantics.modeling.ui", "Invocation to custom symbolDropHandler for element " + element + " failed.", (Throwable)e));
                    return;
                }
            }
        }
        Runnable creator = () -> DiagramUtils.mutateDiagram((IDiagram)d, m -> {
            IDragItem[] items;
            IDragItem[] iDragItemArray = items = (IDragItem[])dp.toArray();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                IDragItem i = iDragItemArray[n2];
                if (i instanceof ElementClassDragItem) {
                    ElementClassDragItem res = (ElementClassDragItem)i;
                    ElementClass ec = res.getElementClass();
                    Point2D pos = dp.getItemPosition(i);
                    assert (pos != null);
                    IElement element = m.newElement(ec);
                    element.setHints(res.getHintContext().getHints());
                    this.setupDroppedElement(element, pos);
                    dp.remove((Object)i);
                }
                ++n2;
            }
        });
        this.selectNewDiagramContentAfter(d, this.partSite, creator);
        this.getContext().getContentContext().setDirty();
    }

    protected void selectNewDiagramContentAfter(IDiagram d, IWorkbenchPartSite activateSite, Runnable diagramModifier) {
        try {
            DiagramContentChanges changes;
            Set addedElements;
            Resource diagramResource = (Resource)d.getHint(DiagramModelHints.KEY_DIAGRAM_RESOURCE);
            DiagramContentTracker tracker = diagramResource == null ? null : DiagramContentTracker.start((ICanvasContext)this.getContext(), (RequestProcessor)Simantics.getSession(), (Resource)diagramResource);
            diagramModifier.run();
            if (tracker != null && !(addedElements = (changes = tracker.update()).pick(changes.elements, Change.ADDED)).isEmpty()) {
                new DiagramSelectionUpdater(this.getContext()).setNewSelection(0, addedElements).setOneshot(true).track();
                if (activateSite != null) {
                    WorkbenchUtils.activatePart((IWorkbenchPartSite)activateSite);
                }
            }
        }
        catch (DatabaseException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.simantics.modeling.ui", "Diagram content change tracking failed.", (Throwable)e));
        }
    }

    protected void setupDroppedElement(IElement element, Point2D dropPos) {
        IElement parent;
        ISnapAdvisor snapAdvisor = (ISnapAdvisor)this.getContext().getHintStack().getHint(DiagramHints.SNAP_ADVISOR);
        if (snapAdvisor != null) {
            snapAdvisor.snap(dropPos);
        }
        if ((parent = (IElement)element.getHint(ElementHints.KEY_PARENT_ELEMENT)) != null) {
            Point2D parentPos = ElementUtils.getPos((IElement)parent);
            Point2D.Double pos = new Point2D.Double(dropPos.getX() - parentPos.getX(), dropPos.getY() - parentPos.getY());
            ElementUtils.setPos((IElement)element, (Point2D)pos);
        } else {
            ElementUtils.setPos((IElement)element, (Point2D)dropPos);
        }
    }

    public void dropActionChanged(DropTargetDragEvent dtde, IDnDContext dp) {
        dtde.acceptDrag(1);
    }

    public int getAllowedOps() {
        return 1;
    }

    public double getPriority() {
        return 10.0;
    }

    private static class PossibleVariableProperty
    extends ResourceRead2<Variable> {
        public PossibleVariableProperty(Resource entity, Resource property) {
            super(entity, property);
        }

        public Variable perform(ReadGraph graph) throws DatabaseException {
            return Variables.tryGetProperty((ReadGraph)graph, (Resource)this.resource, (Resource)this.resource2);
        }
    }
}

