/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.representation;

import java.util.TreeMap;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.graph.representation.External;
import org.simantics.graph.representation.Identity;
import org.simantics.graph.representation.IdentityDefinition;
import org.simantics.graph.representation.Internal;
import org.simantics.graph.representation.Root;
import org.simantics.graph.representation.Value;

public class TransferableGraph1 {
    public static Binding BINDING = Bindings.getBindingUnchecked(TransferableGraph1.class);
    public static Serializer SERIALIZER = Bindings.getSerializerUnchecked((Binding)BINDING);
    public int resourceCount;
    public TreeMap<String, Variant> extensions;
    public Identity[] identities;
    public int[] statements;
    public Value[] values;

    public TransferableGraph1() {
    }

    public TransferableGraph1(int resourceCount, Identity[] identities, int[] statements, Value[] values) {
        this(resourceCount, identities, statements, values, new TreeMap<String, Variant>());
    }

    public TransferableGraph1(int resourceCount, Identity[] identities, int[] statements, Value[] values, TreeMap<String, Variant> extensions) {
        this.resourceCount = resourceCount;
        this.identities = identities;
        this.statements = statements;
        this.values = values;
        this.extensions = extensions;
    }

    public void print() {
        System.out.println("Identities");
        Identity[] identityArray = this.identities;
        int n = this.identities.length;
        int n2 = 0;
        while (n2 < n) {
            IdentityDefinition def;
            Identity id = identityArray[n2];
            System.out.print("    " + id.resource + " = ");
            if (id.definition instanceof Root) {
                def = (Root)id.definition;
                System.out.println("ROOT(" + def.name + ")");
            } else if (id.definition instanceof External) {
                def = (External)id.definition;
                System.out.println("EXTERNAL(" + ((External)def).parent + ", " + ((External)def).name + ")");
            } else if (id.definition instanceof Internal) {
                def = (Internal)id.definition;
                System.out.println("INTERNAL(" + ((Internal)def).parent + ", " + ((Internal)def).name + ")");
            }
            ++n2;
        }
        System.out.println("Statements:");
        int i = 0;
        while (i < this.statements.length) {
            System.out.println("    " + this.statements[i] + " " + this.statements[i + 1] + " " + this.statements[i + 2] + " " + this.statements[i + 3]);
            i += 4;
        }
    }
}

