package org.simantics.document.ui.wizard;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Text;

public class FileSelectionPage extends WizardPage {
	
	Text fileText;
	Button browseButton;
	
	String fileName;

	public FileSelectionPage() {
		super(Messages.FileSelectionPage_FileSelection,Messages.FileSelectionPage_SelectAFile,null);
	}

	@Override
	public void createControl(Composite parent) {
		parent.setLayout(new GridLayout(3,false));
		fileText = new Text(parent,SWT.BORDER|SWT.SINGLE);
		browseButton = new Button(parent, SWT.PUSH);
		browseButton.setText(Messages.FileSelectionPage_Browse);
		
		GridData data;
		data = new GridData();
		data.grabExcessHorizontalSpace = true;
		data.horizontalAlignment = SWT.FILL;
		data.horizontalSpan = 2;
		fileText.setLayoutData(data);
		
		data = new GridData();
		data.horizontalAlignment = SWT.FILL;
		browseButton.setLayoutData(data);
		
		browseButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(),SWT.OPEN);
				// TODO : is there any way to read file/executable bindings from OS?
				//        if is, use those extensions to filter this list.
				//        note: in windows using "reg query ..." to read bindings form registry would work.
				dialog.setFilterExtensions(new String[]{"*.*"}); //$NON-NLS-1$
				String name = dialog.open();
				if (name != null) {
					fileText.setText(name);
					fileName = name;
				}
			}
		});
		
		fileText.addKeyListener(new KeyAdapter() {
			@Override
			public void keyReleased(KeyEvent e) {
				fileName = fileText.getText();
			}
		});
		
	}
	
	public String getFileName() {
		return fileName;
	}
	
	

}
