/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.profile.view;

import org.eclipse.ui.IWorkbenchPart;
import org.simantics.Simantics;
import org.simantics.databoard.util.URIStringUtils;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.modeling.ModelingResources;
import org.simantics.ui.workbench.IPropertyPage;
import org.simantics.views.swt.ModelledView;

/**
 * @author Antti Villberg
 */
public class ProfilesView extends ModelledView {

    @Override
    protected String configurationURI() {
        return DiagramResource.URIs.ProfilesView;
    }

    @Override
    protected void inputChanged(IWorkbenchPart part, Object input) {
        //System.out.println("input: " + input);
        updateViewDescription(input);
        super.inputChanged(part, input);
    }

    private void updateViewDescription(Object input) {
        if (input instanceof Resource) {
            Resource r = (Resource) input;
            ISessionContext ctx = getSessionContext();
            if (ctx != null) {
                try {
                    String desc = ctx.getSession().syncRequest(new ResourceRead<String>(r) {
                        @Override
                        public String perform(ReadGraph graph) throws DatabaseException {
                            Resource r = resource;
                            Resource config = getConfiguration(graph, r);
                            if (config != null)
                                r = config;

                            return formName(graph, r);
                        }

                        private String formName(ReadGraph graph, Resource r) throws DatabaseException {
                            String name = NameUtils.getSafeName(graph, r);
                            final Resource project = Simantics.getProjectResource();
                            String projectUri = project != null ? graph.getPossibleURI(project) : "";
                            String uri = graph.getPossibleURI(r);
                            if (uri != null) {
                                if (uri.startsWith(projectUri))
                                    uri = uri.substring(projectUri.length());
                                uri = URIStringUtils.unescape(uri); 
                            }
                            return uri != null ? name + " (" + uri + ")" : name;
                        }

                        private Resource getConfiguration(ReadGraph graph, Resource r) throws DatabaseException {
                            DiagramResource DIA = DiagramResource.getInstance(graph);
                            Resource diagram = graph.getPossibleObject(r, DIA.RuntimeDiagram_HasConfiguration);
                            if (diagram == null)
                                return r;
                            ModelingResources MOD = ModelingResources.getInstance(graph);
                            Resource config = graph.getPossibleObject(diagram, MOD.DiagramToComposite);
                            if (config == null)
                                return diagram;
                            return config;
                        }
                    });
                    setContentDescription(desc);
                } catch (DatabaseException e) {
                    setContentDescription(e.getMessage());
                }
            }
            setVisible(true);
        } else {
            setContentDescription("Profiles not available.");
            setVisible(false);
        }
    }

    @Override
    protected IPropertyPage getPropertyPage() {
        //return new PropertyPage(getSite());
        return null;
    }

}
