/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.maps.elevation.server.ui;

import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.simantics.maps.elevation.server.SingletonTiffTileInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapsElevationServerPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final Logger LOGGER = LoggerFactory.getLogger(MapsElevationServerPreferencePage.class);

    public MapsElevationServerPreferencePage() {
        super(1);
        this.setDescription("Maps elevation server preferences");
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.simantics.maps.elevation.server");
    }

    private void createGeneralGroup() {
        Group serverGroup = new Group(this.getFieldEditorParent(), 0);
        serverGroup.setText("General");
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)serverGroup);
        BooleanFieldEditor automatically = new BooleanFieldEditor("org.simantics.maps.elevation.server.useElevationServer", "Use elevation server", (Composite)serverGroup);
        this.addField((FieldEditor)automatically);
        StringFieldEditor tifFolderPath = new StringFieldEditor("org.simantics.maps.elevation.server.tifsFolderPath", "Tiff folder path", (Composite)serverGroup);
        this.addField((FieldEditor)tifFolderPath);
        IntegerFieldEditor pipeDepth = new IntegerFieldEditor("org.simantics.maps.elevation.server.pipeDepthUnderGround", "Pipe depth under ground", (Composite)serverGroup);
        pipeDepth.setValidRange(Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.addField((FieldEditor)pipeDepth);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).extendedMargins(12, 12, 12, 12).spacing(5, 4).applyTo((Composite)serverGroup);
    }

    protected void createFieldEditors() {
        this.createGeneralGroup();
    }

    protected void performApply() {
        super.performApply();
    }

    public boolean performOk() {
        boolean ok = super.performOk();
        if (ok) {
            try {
                SingletonTiffTileInterface.reloadElevationServer();
            }
            catch (Exception e) {
                LOGGER.error("Could not reload elevation server", (Throwable)e);
                this.setErrorMessage(e.getMessage());
                return false;
            }
        }
        return ok;
    }

    public void init(IWorkbench workbench) {
    }
}

