/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.selection;

import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.QueryIndexUtils;
import org.simantics.db.layer0.request.ActiveModels;
import org.simantics.db.layer0.request.ActiveRuns;
import org.simantics.db.layer0.request.Configuration;
import org.simantics.db.layer0.request.PossibleActiveModel;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.district.network.ontology.DistrictNetworkResource;
import org.simantics.district.region.ontology.DiagramRegionsResource;
import org.simantics.district.selection.ElementSelectionResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.utils.datastructures.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElementSelector {
    String name;
    String expression;
    Resource resource;
    Generator generator;
    Selector selector;
    Condition condition;
    static Logger LOG = LoggerFactory.getLogger(ElementSelector.class);
    static ElementSelectionResource ES;
    static Layer0 L0;
    static StructuralResource2 STR;
    static ModelingResources MOD;
    static DiagramResource DIA;
    static DistrictNetworkResource DN;
    private static Logger LOGGER;

    static {
        LOGGER = LoggerFactory.getLogger(ElementSelector.class);
    }

    ElementSelector(ReadGraph graph, Resource resource) throws DatabaseException {
        L0 = Layer0.getInstance((ReadGraph)graph);
        ES = ElementSelectionResource.getInstance(graph);
        STR = StructuralResource2.getInstance((ReadGraph)graph);
        MOD = ModelingResources.getInstance((ReadGraph)graph);
        DIA = DiagramResource.getInstance((ReadGraph)graph);
        DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        this.resource = resource;
        try {
            this.name = (String)graph.getRelatedValue(resource, ElementSelector.L0.HasLabel);
            this.expression = ElementSelector.getExpression((RequestProcessor)graph, resource);
        }
        catch (DatabaseException e) {
            LOG.error("Error reading element selector", (Throwable)e);
            throw e;
        }
    }

    public static ElementSelector getSelector(RequestProcessor graph, Resource resource) throws DatabaseException {
        return (ElementSelector)graph.syncRequest((Read)new ElementSelectorQuery(resource));
    }

    public static String getExpression(RequestProcessor graph, Resource resource) throws DatabaseException {
        return (String)graph.syncRequest((Read)new SelectionExpressionRequest(resource));
    }

    public static Condition getCondition(RequestProcessor graph, Resource condition) throws DatabaseException {
        return (Condition)graph.syncRequest((Read)new SelectionConditionRequest(condition));
    }

    public String getName() {
        return this.name;
    }

    public String getExpression() {
        return this.expression;
    }

    public Resource getResource() {
        return this.resource;
    }

    public Generator getGenerator() {
        return this.generator;
    }

    public Selector getSelector() {
        return this.selector;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public void buildSelection(ReadGraph graph) throws DatabaseException {
        Resource selector = graph.getSingleObject(this.resource, ElementSelector.ES.Selection_HasSelector);
        Resource generator = graph.getSingleObject(this.resource, ElementSelector.ES.Selection_HasGenerator);
        Resource condition = graph.getPossibleObject(this.resource, ElementSelector.ES.Selection_HasCondition);
        this.selector = ElementSelector.buildSelector(graph, selector);
        this.generator = ElementSelector.buildGenerator(graph, generator);
        this.condition = ElementSelector.buildCondition(graph, condition);
    }

    public static Map<Resource, String> findDiagrams() {
        try {
            return (Map)Simantics.getSession().syncRequest((Read)new Read<Map<Resource, String>>(){

                public Map<Resource, String> perform(ReadGraph graph) throws DatabaseException {
                    HashMap<Resource, String> result = new HashMap<Resource, String>();
                    Resource model = (Resource)graph.syncRequest((Read)new PossibleActiveModel(Simantics.getProjectResource()));
                    List composites = QueryIndexUtils.searchByType((ReadGraph)graph, (Resource)model, (Resource)StructuralResource2.getInstance((ReadGraph)graph).Composite);
                    for (Resource r : composites) {
                        Resource parent;
                        Resource diagram = graph.getPossibleObject(r, ModelingResources.getInstance((ReadGraph)graph).CompositeToDiagram);
                        if (diagram == null || (parent = graph.getPossibleObject(r, Layer0.getInstance((ReadGraph)graph).PartOf)) == null || graph.isInheritedFrom(parent, StructuralResource2.getInstance((ReadGraph)graph).Component)) continue;
                        result.put(r, (String)graph.getRelatedValue(r, Layer0.getInstance((ReadGraph)graph).HasName));
                    }
                    return result;
                }
            });
        }
        catch (DatabaseException e) {
            LOGGER.error("Query for model diagrams failed", (Throwable)e);
            return Collections.emptyMap();
        }
    }

    public static Variable getVariableForElement(ReadGraph graph, Resource element) throws DatabaseException {
        Resource component = graph.getPossibleObject(element, ElementSelector.MOD.ElementToComponent);
        if (component != null) {
            Variable var = Variables.getVariable((ReadGraph)graph, (Resource)component);
            RVI realRvi = var.getRVI(graph);
            for (Resource activeModel : (Collection)graph.syncRequest((Read)new ActiveModels(Simantics.getProjectResource()))) {
                Variable v;
                for (Variable run : (Collection)graph.syncRequest((Read)new ActiveRuns(activeModel))) {
                    Variable v2 = realRvi.resolvePossible(graph, run);
                    if (v2 == null) continue;
                    return v2;
                }
                Variable configuration = Variables.getPossibleConfigurationContext((ReadGraph)graph, (Resource)activeModel);
                if (configuration == null || (v = realRvi.resolvePossible(graph, configuration)) == null) continue;
                return v;
            }
        }
        return null;
    }

    public static Double getPropertyValue(ReadGraph graph, Resource element, String propertyName) {
        try {
            Number value;
            Variable v = ElementSelector.getVariableForElement(graph, element);
            if (v != null && (value = (Number)v.getPossiblePropertyValue(graph, propertyName)) != null) {
                return value.doubleValue();
            }
            Resource mappedElement = graph.getPossibleObject(element, ElementSelector.DN.MappedComponent);
            if (mappedElement != null) {
                return ElementSelector.getPropertyValue(graph, mappedElement, propertyName);
            }
        }
        catch (DatabaseException databaseException) {}
        return null;
    }

    public SelectionResult selectElementsFrom(ReadGraph graph, Resource model) throws DatabaseException {
        if (this.selector == null) {
            this.buildSelection(graph);
        }
        return this.gather(graph, model);
    }

    private static Generator buildGenerator(ReadGraph graph, Resource resource) throws DatabaseException {
        if (!graph.isInstanceOf(resource, ElementSelector.ES.Generator)) {
            throw new IllegalArgumentException("Resource " + resource + " is not a valid generator");
        }
        if (graph.isInstanceOf(resource, ElementSelector.ES.Generator_Model)) {
            return new ModelGenerator();
        }
        if (graph.isInstanceOf(resource, ElementSelector.ES.Generator_Diagram)) {
            return new DiagramGenerator(graph.getSingleObject(resource, ElementSelector.ES.Generator_HasDiagram));
        }
        if (graph.isInstanceOf(resource, ElementSelector.ES.Generator_Explicit)) {
            return new ExplicitGenerator(graph.getObjects(resource, ElementSelector.ES.Generator_HasSelectedElement));
        }
        throw new IllegalArgumentException("Unknown generator type " + graph.getURI(graph.getSingleType(resource)));
    }

    private static Selector buildSelector(ReadGraph graph, Resource resource) throws DatabaseException {
        Selector s;
        if (!graph.isInstanceOf(resource, ElementSelector.ES.Selector)) {
            throw new IllegalArgumentException("Resource " + resource + " is not a valid selector");
        }
        if (graph.isInstanceOf(resource, ElementSelector.ES.Selector_All)) {
            s = new All();
        } else if (graph.isInstanceOf(resource, ElementSelector.ES.PropertySelector)) {
            String propertyName = (String)graph.getRelatedValue(resource, ElementSelector.ES.PropertySelector_HasSelectionPropertyName);
            Integer resultCount = (Integer)graph.getRelatedValue(resource, ElementSelector.ES.PropertySelector_HasResultCount);
            boolean isSmallest = graph.isInstanceOf(resource, ElementSelector.ES.Selector_NLowest);
            s = new PropertySelector(isSmallest, propertyName, resultCount);
        } else {
            throw new IllegalArgumentException("Unknown selector type " + graph.getURI(graph.getSingleType(resource)));
        }
        return s;
    }

    private static Condition buildCondition(ReadGraph graph, Resource resource) throws DatabaseException {
        Condition cond;
        if (resource == null) {
            return null;
        }
        if (!graph.isInstanceOf(resource, ElementSelector.ES.Condition)) {
            throw new IllegalArgumentException("Resource " + resource + " is not a valid condition");
        }
        if (graph.isInstanceOf(resource, ElementSelector.ES.PropertyCondition)) {
            String propertyName = (String)graph.getRelatedValue(resource, ElementSelector.ES.PropertyCondition_HasPropertyName);
            Double lowerLimit = (Double)graph.getPossibleRelatedValue(resource, ElementSelector.ES.PropertyCondition_HasLowerLimit);
            Double upperLimit = (Double)graph.getPossibleRelatedValue(resource, ElementSelector.ES.PropertyCondition_HasUpperLimit);
            cond = new PropertyCondition(resource, propertyName, lowerLimit, upperLimit);
        } else if (graph.isInstanceOf(resource, ElementSelector.ES.RegionCondition)) {
            DiagramRegionsResource DR = DiagramRegionsResource.getInstance((ReadGraph)graph);
            Resource regionResource = graph.getSingleObject(resource, ElementSelector.ES.RegionCondition_HasRegion);
            double[] region = (double[])graph.getRelatedValue(regionResource, DR.Region_area);
            cond = new RegionCondition(resource, regionResource, region);
        } else if (graph.isInstanceOf(resource, ElementSelector.ES.RouteCondition)) {
            Resource routeResource = graph.getSingleObject(resource, ElementSelector.ES.RouteCondition_HasRoute);
            HashSet<Resource> routePoints = new HashSet<Resource>(ListUtils.toList((ReadGraph)graph, (Resource)routeResource));
            cond = new RouteCondition(resource, routeResource, routePoints);
        } else if (graph.isInstanceOf(resource, ElementSelector.ES.AggregateCondition)) {
            AggregateCondition.Type type;
            Collection conditionResources = graph.getObjects(resource, ElementSelector.ES.HasSubcondition);
            ArrayList<Condition> conditions = new ArrayList<Condition>(conditionResources.size());
            for (Resource c : conditionResources) {
                conditions.add(ElementSelector.buildCondition(graph, c));
            }
            if (graph.isInstanceOf(resource, ElementSelector.ES.Conjunction)) {
                type = AggregateCondition.Type.CONJUNCTION;
            } else if (graph.isInstanceOf(resource, ElementSelector.ES.Negation)) {
                type = AggregateCondition.Type.NEGATION;
            } else if (graph.isInstanceOf(resource, ElementSelector.ES.Disjunction)) {
                type = AggregateCondition.Type.DISJUNCTION;
            } else {
                throw new IllegalArgumentException("Unknown aggreate condition type " + graph.getURI(graph.getSingleType(resource)));
            }
            cond = new AggregateCondition(resource, type, conditions);
        } else {
            throw new IllegalArgumentException("Unknown condition type " + graph.getURI(graph.getSingleType(resource)));
        }
        return cond;
    }

    private static String buildExpression(ReadGraph graph, Resource r) throws DatabaseException {
        if (graph.isInstanceOf(r, ElementSelector.ES.Selection)) {
            String exp = "select " + ElementSelector.getExpression((RequestProcessor)graph, graph.getSingleObject(r, ElementSelector.ES.Selection_HasSelector)) + " from " + ElementSelector.getExpression((RequestProcessor)graph, graph.getSingleObject(r, ElementSelector.ES.Selection_HasGenerator));
            Resource cond = graph.getPossibleObject(r, ElementSelector.ES.Selection_HasCondition);
            return cond != null ? String.valueOf(exp) + " where {" + ElementSelector.getExpression((RequestProcessor)graph, cond) + "}" : exp;
        }
        if (graph.isInstanceOf(r, ElementSelector.ES.Condition)) {
            if (graph.isInstanceOf(r, ElementSelector.ES.PropertyCondition)) {
                return ElementSelector.buildPropertyConditionExpression(graph, r);
            }
            if (graph.isInstanceOf(r, ElementSelector.ES.RegionCondition)) {
                Resource region = graph.getSingleObject(r, ElementSelector.ES.RegionCondition_HasRegion);
                String name = (String)graph.getRelatedValue(region, ElementSelector.L0.HasLabel);
                return "in region " + name;
            }
            if (graph.isInstanceOf(r, ElementSelector.ES.RouteCondition)) {
                Resource route = graph.getSingleObject(r, ElementSelector.ES.RouteCondition_HasRoute);
                String name = (String)graph.getRelatedValue(route, ElementSelector.L0.HasLabel);
                return "in route " + name;
            }
            if (graph.isInstanceOf(r, ElementSelector.ES.AggregateCondition)) {
                String op = graph.isInstanceOf(r, ElementSelector.ES.Conjunction) ? " and " : " or ";
                ArrayList<String> exps = new ArrayList<String>();
                Collection objects = graph.getObjects(r, ElementSelector.ES.HasSubcondition);
                for (Resource c : objects) {
                    String exp = ElementSelector.getExpression((RequestProcessor)graph, c);
                    exps.add(objects.size() > 1 ? "{" + exp + "}" : exp);
                }
                String result = String.join((CharSequence)op, exps);
                if (graph.isInstanceOf(r, ElementSelector.ES.Negation)) {
                    result = "not {" + result + "}";
                }
                return result;
            }
            throw new DatabaseException("Unsupported condition resource type <" + graph.getURI(graph.getSingleType(r)) + ">");
        }
        if (graph.isInstanceOf(r, ElementSelector.ES.Selector)) {
            if (graph.isInstanceOf(r, ElementSelector.ES.Selector_All)) {
                return "all";
            }
            if (graph.isInstanceOf(r, ElementSelector.ES.PropertySelector)) {
                String op;
                if (graph.isInstanceOf(r, ElementSelector.ES.Selector_NLowest)) {
                    op = "bottom";
                } else if (graph.isInstanceOf(r, ElementSelector.ES.Selector_NHighest)) {
                    op = "top";
                } else {
                    throw new DatabaseException("Unsupported property selector resource type <" + graph.getURI(graph.getSingleType(r)) + ">");
                }
                String name = (String)graph.getRelatedValue(r, ElementSelector.ES.PropertySelector_HasSelectionPropertyName);
                Integer count = (Integer)graph.getRelatedValue(r, ElementSelector.ES.PropertySelector_HasResultCount);
                return String.valueOf(op) + " " + count + " of " + name;
            }
            throw new DatabaseException("Unsupported selector resource type <" + graph.getURI(graph.getSingleType(r)) + ">");
        }
        if (graph.isInstanceOf(r, ElementSelector.ES.Generator)) {
            if (graph.isInstanceOf(r, ElementSelector.ES.Generator_Model)) {
                return "model";
            }
            if (graph.isInstanceOf(r, ElementSelector.ES.Generator_Diagram)) {
                return "diagram \"" + graph.getRelatedValue(graph.getSingleObject(r, ElementSelector.ES.Generator_HasDiagram), ElementSelector.L0.HasName) + "\"";
            }
            if (graph.isInstanceOf(r, ElementSelector.ES.Generator_Explicit)) {
                return "<list of " + graph.getObjects(r, ElementSelector.ES.Generator_HasSelectedElement).size() + " elements>";
            }
            throw new DatabaseException("Unsupported generator resource type <" + graph.getURI(graph.getSingleType(r)) + ">");
        }
        throw new DatabaseException("Unsupported resource type <" + graph.getURI(graph.getSingleType(r)) + ">");
    }

    private static String buildPropertyConditionExpression(ReadGraph graph, Resource r) throws DatabaseException {
        String propertyName = (String)graph.getRelatedValue(r, ElementSelector.ES.PropertyCondition_HasPropertyName);
        Double lowerLimit = (Double)graph.getPossibleRelatedValue(r, ElementSelector.ES.PropertyCondition_HasLowerLimit);
        Double upperLimit = (Double)graph.getPossibleRelatedValue(r, ElementSelector.ES.PropertyCondition_HasUpperLimit);
        if (lowerLimit == null && upperLimit == null) {
            return "has property " + propertyName;
        }
        StringBuilder result = new StringBuilder();
        if (lowerLimit != null) {
            result.append(lowerLimit);
            result.append(" < ");
        }
        result.append(propertyName);
        if (upperLimit != null) {
            result.append(" < ");
            result.append(upperLimit);
        }
        return result.toString();
    }

    private static Collection<Resource> elementsOfDiagram(ReadGraph graph, Resource diagram) throws DatabaseException {
        if (graph.isInstanceOf(diagram, ElementSelector.STR.Composite)) {
            return ElementSelector.elementsOfDiagram(graph, graph.getSingleObject(diagram, ElementSelector.MOD.CompositeToDiagram));
        }
        Collection elements = graph.getObjects(diagram, ElementSelector.L0.ConsistsOf);
        ArrayList<Resource> result = new ArrayList<Resource>();
        for (Resource r : elements) {
            if (!graph.isInstanceOf(r, ElementSelector.DIA.Element)) continue;
            result.add(r);
        }
        return result;
    }

    private Collection<Resource> filterElementsFrom(ReadGraph graph, Collection<Resource> elements) throws DatabaseException {
        if (this.condition == null) {
            return elements;
        }
        ArrayList<Resource> result = new ArrayList<Resource>();
        for (Resource r : elements) {
            if (!this.condition.match(graph, r)) continue;
            result.add(r);
        }
        return result;
    }

    private SelectionResult gather(ReadGraph graph, Resource model) throws DatabaseException {
        return this.selector.select(graph, this.filterElementsFrom(graph, this.generator.generate(graph, model)));
    }

    public static class AggregateCondition
    extends Condition {
        public Type type;
        public List<Condition> conditions;

        public AggregateCondition(Resource r, Type type, List<Condition> conditions) {
            super(r);
            this.type = type;
            this.conditions = conditions;
        }

        @Override
        boolean match(ReadGraph graph, Resource r) throws DatabaseException {
            switch (this.type) {
                case DISJUNCTION: {
                    for (Condition c : this.conditions) {
                        if (!c.match(graph, r)) continue;
                        return true;
                    }
                    return false;
                }
                case CONJUNCTION: {
                    for (Condition c : this.conditions) {
                        if (c.match(graph, r)) continue;
                        return false;
                    }
                    return true;
                }
                case NEGATION: {
                    for (Condition c : this.conditions) {
                        if (!c.match(graph, r)) continue;
                        return false;
                    }
                    return true;
                }
            }
            throw new IllegalArgumentException("Unknown aggregate condition type " + (Object)((Object)this.type));
        }

        public static enum Type {
            DISJUNCTION,
            CONJUNCTION,
            NEGATION;

        }
    }

    public static class All
    extends Selector {
        @Override
        SelectionResult select(ReadGraph graph, Collection<Resource> elements) {
            return new SelectionResult(elements, 0, 0);
        }
    }

    public static abstract class Condition {
        public Resource resource;

        Condition(Resource r) {
            this.resource = r;
        }

        abstract boolean match(ReadGraph var1, Resource var2) throws DatabaseException;
    }

    public static class DiagramGenerator
    extends Generator {
        public Resource diagram;

        public DiagramGenerator(Resource diagram) {
            this.diagram = diagram;
        }

        @Override
        Collection<Resource> generate(ReadGraph graph, Resource model) throws DatabaseException {
            return ElementSelector.elementsOfDiagram(graph, this.diagram);
        }
    }

    public static class ElementSelectorQuery
    extends ResourceRead<ElementSelector> {
        public ElementSelectorQuery(Resource resource) {
            super(resource);
        }

        public ElementSelector perform(ReadGraph graph) throws DatabaseException {
            return new ElementSelector(graph, this.resource);
        }
    }

    public static class ExplicitGenerator
    extends Generator {
        public Collection<Resource> elements;

        public ExplicitGenerator(Collection<Resource> elements) {
            this.elements = elements;
        }

        @Override
        Collection<Resource> generate(ReadGraph graph, Resource model) {
            return this.elements;
        }
    }

    public static abstract class Generator {
        abstract Collection<Resource> generate(ReadGraph var1, Resource var2) throws DatabaseException;
    }

    public static class ModelGenerator
    extends Generator {
        @Override
        Collection<Resource> generate(ReadGraph graph, Resource model) throws DatabaseException {
            Resource conf = (Resource)graph.syncRequest((Read)new Configuration(model));
            HashMap<Resource, Resource> fromMapped = new HashMap<Resource, Resource>();
            for (Resource comp : graph.getObjects(conf, ElementSelector.L0.ConsistsOf)) {
                Resource diagram;
                if (!graph.isInstanceOf(comp, ElementSelector.STR.Composite) || (diagram = graph.getPossibleObject(comp, ElementSelector.MOD.CompositeToDiagram)) == null) continue;
                for (Resource elem : ElementSelector.elementsOfDiagram(graph, diagram)) {
                    Resource mapped = graph.getPossibleObject(elem, ElementSelector.DN.MappedComponent);
                    if (mapped != null) {
                        fromMapped.put(mapped, elem);
                        continue;
                    }
                    if (fromMapped.containsKey(elem)) continue;
                    fromMapped.put(elem, elem);
                }
            }
            return new ArrayList<Resource>(fromMapped.values());
        }
    }

    public static class PropertyCondition
    extends Condition {
        public String propertyName;
        public Double lowerLimit;
        public Double upperLimit;

        public PropertyCondition(Resource r, String propertyName, Double lowerLimit, Double upperLimit) {
            super(r);
            this.propertyName = propertyName;
            this.lowerLimit = lowerLimit;
            this.upperLimit = upperLimit;
        }

        @Override
        boolean match(ReadGraph graph, Resource r) {
            Double value = ElementSelector.getPropertyValue(graph, r, this.propertyName);
            return value != null && (this.lowerLimit == null || value >= this.lowerLimit) && (this.upperLimit == null || value <= this.upperLimit);
        }
    }

    public static class PropertySelector
    extends Selector {
        public boolean smallest;
        public String propertyName;
        public int resultCount;

        public PropertySelector(boolean smallest, String propertyName, int resultCount) {
            this.smallest = smallest;
            this.propertyName = propertyName;
            this.resultCount = resultCount;
        }

        @Override
        SelectionResult select(ReadGraph graph, Collection<Resource> elements) {
            Comparator comparator = this.smallest ? (p1, p2) -> Double.compare((Double)p1.second, (Double)p2.second) : (p1, p2) -> Double.compare((Double)p1.second, (Double)p2.second);
            List result2 = elements.stream().map(r -> Pair.make((Object)r, (Object)ElementSelector.getPropertyValue(graph, r, this.propertyName))).filter(t -> t.second != null).sorted(comparator).collect(Collectors.toList());
            int count = Math.min(this.resultCount, result2.size());
            int tailCount = 0;
            double tailValue = count > 0 ? (Double)((Pair)result2.get((int)(count - 1))).second : 0.0;
            int i = count - 1;
            while (i >= 0) {
                if ((Double)((Pair)result2.get((int)i)).second != tailValue) break;
                ++tailCount;
                --i;
            }
            int tailSize = tailCount;
            int i2 = count;
            while (i2 < result2.size()) {
                if ((Double)((Pair)result2.get((int)i2)).second != tailValue) break;
                ++tailSize;
                ++i2;
            }
            if (count < result2.size()) {
                result2 = result2.subList(0, this.resultCount);
            }
            List<Resource> selection = result2.stream().map(p -> (Resource)p.first).collect(Collectors.toList());
            return new SelectionResult(selection, tailCount, tailSize);
        }
    }

    public static class RegionCondition
    extends Condition {
        public Resource regionResource;
        double[] region;
        Path2D path;

        public RegionCondition(Resource r, Resource regionResoruce, double[] region) {
            super(r);
            this.region = region;
            Path2D.Double path = new Path2D.Double();
            double startX = region[0];
            double startY = region[1];
            ((Path2D)path).moveTo(startX, startY);
            int i = 2;
            while (i < region.length) {
                ((Path2D)path).lineTo(region[i], region[i + 1]);
                i += 2;
            }
            path.closePath();
            this.path = path;
            this.regionResource = regionResoruce;
        }

        @Override
        boolean match(ReadGraph graph, Resource r) throws DatabaseException {
            double[] transform = (double[])graph.getRelatedValue(r, ElementSelector.DIA.HasTransform);
            double x = transform[4];
            double y = transform[5];
            return this.path.contains(x, y);
        }
    }

    public static class RouteCondition
    extends Condition {
        public Resource routeResource;
        Set<Resource> routePoints;

        public RouteCondition(Resource r, Resource routeResource, Set<Resource> routePoints) {
            super(r);
            this.routePoints = routePoints;
            this.routeResource = routeResource;
        }

        @Override
        boolean match(ReadGraph graph, Resource r) throws DatabaseException {
            return this.routePoints.contains(r);
        }
    }

    public static final class SelectionConditionRequest
    extends ResourceRead<Condition> {
        public SelectionConditionRequest(Resource resource) {
            super(resource);
        }

        public Condition perform(ReadGraph graph) throws DatabaseException {
            return ElementSelector.buildCondition(graph, this.resource);
        }
    }

    public static final class SelectionExpressionRequest
    extends ResourceRead<String> {
        public SelectionExpressionRequest(Resource condition) {
            super(condition);
        }

        public String perform(ReadGraph graph) throws DatabaseException {
            return ElementSelector.buildExpression(graph, this.resource);
        }
    }

    public static class SelectionResult {
        public final Collection<Resource> elements;
        public final int tailCount;
        public final int tailSize;

        public SelectionResult(Collection<Resource> elements, int tailCount, int tailSize) {
            this.elements = elements;
            this.tailCount = tailCount;
            this.tailSize = tailSize;
        }
    }

    public static abstract class Selector {
        abstract SelectionResult select(ReadGraph var1, Collection<Resource> var2);
    }
}

