/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.selection.ui.parts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.inject.Inject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.RowLayoutFactory;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.RuntimeDatabaseException;
import org.simantics.db.layer0.QueryIndexUtils;
import org.simantics.db.layer0.request.ActiveModels;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.Write;
import org.simantics.db.request.WriteResult;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.district.region.ontology.DiagramRegionsResource;
import org.simantics.district.route.ontology.RouteResource;
import org.simantics.district.selection.ElementSelectionResource;
import org.simantics.district.selection.ElementSelectionUtils;
import org.simantics.district.selection.ElementSelector;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.utils.datastructures.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditSelectorDialog
extends Dialog {
    private static Logger LOGGER = LoggerFactory.getLogger(EditSelectorDialog.class);
    private ElementSelector elementSelector;
    Collection<Resource> currentSelection;
    Map<Resource, String> diagrams;
    private String[] regionNames;
    private Resource[] regionResources;
    private String[] routeNames;
    private Resource[] routeResources;
    private int generatorIndex;
    private Combo sourceField;
    private String name;
    private Text nameField;
    private Resource diagram;
    private Combo diagramField;
    private int selectorIndex;
    private Combo selectorField;
    private String propertyName;
    private Text propertyField;
    private int numberOfItems;
    private Text nField;
    private ElementSelector.Condition condition;
    private Button removeConditionButton;
    private Text conditionLabel;
    private Composite content;

    @Inject
    public EditSelectorDialog(Shell shell, final ElementSelector elementSelector, Collection<Resource> currentSelection) {
        super(shell);
        this.elementSelector = elementSelector;
        if (elementSelector != null) {
            try {
                Simantics.getSession().sync((ReadInterface)new ReadRequest(){

                    public void run(ReadGraph graph) throws DatabaseException {
                        elementSelector.buildSelection(graph);
                    }
                });
            }
            catch (DatabaseException e1) {
                LOGGER.error("Failed to read element selector resource " + elementSelector.getResource(), (Throwable)e1);
                throw new RuntimeDatabaseException((Throwable)e1);
            }
        }
        this.currentSelection = currentSelection;
        final HashMap regions = new HashMap();
        final HashMap routes = new HashMap();
        try {
            Simantics.getSession().syncRequest((Read)new Read<Void>(){

                public Void perform(ReadGraph graph) throws DatabaseException {
                    Resource model = ActiveModels.getPossibleActiveModel((ReadGraph)graph, (Resource)Simantics.getProjectResource());
                    List regionCollection = QueryIndexUtils.searchByType((ReadGraph)graph, (Resource)model, (Resource)DiagramRegionsResource.getInstance((ReadGraph)graph).Region);
                    for (Resource r : regionCollection) {
                        String name = (String)graph.getRelatedValue(r, Layer0.getInstance((ReadGraph)graph).HasName);
                        regions.put(r, name);
                    }
                    List routeCollection = QueryIndexUtils.searchByType((ReadGraph)graph, (Resource)model, (Resource)RouteResource.getInstance((ReadGraph)graph).Route);
                    for (Resource r : routeCollection) {
                        String name = (String)graph.getRelatedValue(r, Layer0.getInstance((ReadGraph)graph).HasName);
                        routes.put(r, name);
                    }
                    return null;
                }
            });
        }
        catch (DatabaseException e) {
            LOGGER.error("Failed to read routes and/or regions in the model", (Throwable)e);
        }
        this.regionNames = regions.values().toArray(new String[regions.size()]);
        this.regionResources = regions.keySet().toArray(new Resource[regions.size()]);
        this.routeNames = routes.values().toArray(new String[routes.size()]);
        this.routeResources = routes.keySet().toArray(new Resource[routes.size()]);
        this.name = elementSelector != null ? elementSelector.getName() : "";
        this.propertyName = "";
        this.numberOfItems = 1;
        this.generatorIndex = 0;
        this.selectorIndex = 0;
        this.diagram = null;
        this.condition = null;
        if (elementSelector != null) {
            ElementSelector.Generator generator = elementSelector.getGenerator();
            if (generator instanceof ElementSelector.ModelGenerator) {
                this.generatorIndex = 0;
            } else if (generator instanceof ElementSelector.DiagramGenerator) {
                this.generatorIndex = 1;
                this.diagram = ((ElementSelector.DiagramGenerator)generator).diagram;
            } else if (generator instanceof ElementSelector.ExplicitGenerator) {
                this.generatorIndex = 2;
            } else {
                throw new IllegalStateException("Unknown generator type " + generator.getClass().getName());
            }
            ElementSelector.Selector selector = elementSelector.getSelector();
            if (selector instanceof ElementSelector.All) {
                this.selectorIndex = 0;
            } else if (selector instanceof ElementSelector.PropertySelector) {
                ElementSelector.PropertySelector propertySelector = (ElementSelector.PropertySelector)selector;
                this.selectorIndex = propertySelector.smallest ? 1 : 2;
                this.propertyName = propertySelector.propertyName;
                this.numberOfItems = propertySelector.resultCount;
            } else {
                throw new IllegalStateException("Unknwon selector type " + selector.getClass().getName());
            }
            this.condition = elementSelector.getCondition();
        }
    }

    protected void okPressed() {
        this.generatorIndex = this.sourceField.getSelectionIndex();
        if (this.generatorIndex == 1) {
            int selectionIndex = this.diagramField.getSelectionIndex();
            if (selectionIndex < 0) {
                ErrorDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Please select a diagram", (IStatus)new Status(4, "org.simantics.district.selection.ui", "No diagram selected"));
                return;
            }
            this.diagram = new ArrayList<Resource>(this.diagrams.keySet()).get(selectionIndex);
        }
        this.name = this.nameField.getText();
        this.selectorIndex = this.selectorField.getSelectionIndex();
        this.propertyName = this.propertyField.getText();
        String text = this.nField.getText();
        this.numberOfItems = "".equals(text) ? 0 : Integer.parseInt(text);
        super.okPressed();
    }

    public void writeSelection() throws DatabaseException {
        Simantics.getSession().syncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                Resource selectorType;
                Resource generatorType;
                Resource selection;
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                ElementSelectionResource ES = ElementSelectionResource.getInstance((ReadGraph)graph);
                ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
                DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
                graph.markUndoPoint();
                Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)"Created new element selection");
                Resource lib = ElementSelectionUtils.ensureSelectionLibrary((RequestProcessor)graph);
                if (EditSelectorDialog.this.elementSelector != null) {
                    selection = EditSelectorDialog.this.elementSelector.getResource();
                    graph.deny(selection);
                } else {
                    selection = graph.newResource();
                }
                graph.claim(selection, L0.InstanceOf, ES.Selection);
                graph.claimLiteral(selection, L0.HasName, L0.String, (Object)UUID.randomUUID().toString());
                graph.claimLiteral(selection, L0.HasLabel, L0.String, (Object)EditSelectorDialog.this.name);
                graph.claim(selection, L0.PartOf, lib);
                Resource generator = graph.newResource();
                switch (EditSelectorDialog.this.generatorIndex) {
                    case 0: {
                        generatorType = ES.Generator_Model;
                        break;
                    }
                    case 1: {
                        generatorType = ES.Generator_Diagram;
                        Resource composite = graph.getPossibleObject(EditSelectorDialog.this.diagram, MOD.DiagramToComposite);
                        graph.claim(generator, ES.Generator_HasDiagram, composite != null ? composite : EditSelectorDialog.this.diagram);
                        break;
                    }
                    case 2: {
                        generatorType = ES.Generator_Explicit;
                        for (Resource r : EditSelectorDialog.this.currentSelection) {
                            if (graph.isInstanceOf(r, DIA.Connection) || !graph.isInstanceOf(r, DIA.Element) && (!graph.hasStatement(r, MOD.ComponentToElement) || (r = graph.getPossibleObject(r, MOD.ComponentToElement)) == null)) continue;
                            graph.claim(generator, ES.Generator_HasSelectedElement, r);
                        }
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Invalid source index " + EditSelectorDialog.this.generatorIndex);
                    }
                }
                graph.claim(generator, L0.InstanceOf, generatorType);
                graph.claim(selection, ES.Selection_HasGenerator, generator);
                Resource selector = graph.newResource();
                switch (EditSelectorDialog.this.selectorIndex) {
                    case 0: {
                        selectorType = ES.Selector_All;
                        break;
                    }
                    case 1: {
                        selectorType = ES.Selector_NLowest;
                        break;
                    }
                    case 2: {
                        selectorType = ES.Selector_NHighest;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Invalid selector index " + EditSelectorDialog.this.selectorIndex);
                    }
                }
                graph.claim(selector, L0.InstanceOf, selectorType);
                graph.claim(selection, ES.Selection_HasSelector, selector);
                if (EditSelectorDialog.this.selectorIndex > 0) {
                    graph.claimLiteral(selector, ES.PropertySelector_HasSelectionPropertyName, L0.String, (Object)EditSelectorDialog.this.propertyName);
                    graph.claimLiteral(selector, ES.PropertySelector_HasResultCount, L0.Integer, (Object)EditSelectorDialog.this.numberOfItems);
                }
                if (EditSelectorDialog.this.condition != null) {
                    graph.claim(selection, ES.Selection_HasCondition, ((EditSelectorDialog)EditSelectorDialog.this).condition.resource);
                }
            }
        });
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Edit element selector");
        this.content = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().numColumns(3).applyTo(this.content);
        Label nameLabel = new Label(this.content, 0);
        nameLabel.setText("Name");
        GridDataFactory.swtDefaults().applyTo((Control)nameLabel);
        this.nameField = new Text(this.content, 2048);
        this.nameField.setEditable(true);
        this.nameField.setText(this.name);
        GridDataFactory.swtDefaults().span(2, 1).hint(200, -1).applyTo((Control)this.nameField);
        Label sourceLabel = new Label(this.content, 0);
        sourceLabel.setText("Source");
        GridDataFactory.swtDefaults().applyTo((Control)sourceLabel);
        this.sourceField = new Combo(this.content, 2056);
        this.sourceField.setItems(new String[]{"Model", "Diagram", "Current selection"});
        this.sourceField.select(this.generatorIndex);
        GridDataFactory.swtDefaults().span(1, 1).applyTo((Control)this.sourceField);
        this.diagramField = new Combo(this.content, 2056);
        GridDataFactory.swtDefaults().span(1, 1).applyTo((Control)this.diagramField);
        this.diagrams = ElementSelector.findDiagrams();
        this.diagramField.setItems(this.diagrams.values().toArray(new String[this.diagrams.size()]));
        int diagramIndex = this.diagram != null ? new ArrayList<Resource>(this.diagrams.keySet()).indexOf(this.diagram) : -1;
        this.diagramField.select(diagramIndex);
        this.sourceField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditSelectorDialog.this.generatorIndex = EditSelectorDialog.this.sourceField.getSelectionIndex();
                EditSelectorDialog.this.diagramField.setVisible(EditSelectorDialog.this.isDiagramFieldVisible());
            }
        });
        this.sourceField.select(this.generatorIndex);
        this.diagramField.setVisible(this.isDiagramFieldVisible());
        Label selectorLabel = new Label(this.content, 0);
        selectorLabel.setText("Select");
        GridDataFactory.swtDefaults().span(1, 1).applyTo((Control)selectorLabel);
        this.selectorField = new Combo(this.content, 2056);
        this.selectorField.setItems(new String[]{"All", "N lowest", "N highest"});
        this.selectorField.select(this.selectorIndex);
        GridDataFactory.swtDefaults().span(1, 1).applyTo((Control)this.selectorField);
        final Composite selectorComposite = new Composite(this.content, 0);
        GridDataFactory.swtDefaults().span(1, 1).applyTo((Control)selectorComposite);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(selectorComposite);
        Label propertyLabel = new Label(selectorComposite, 0);
        propertyLabel.setText("Property name");
        GridDataFactory.swtDefaults().applyTo((Control)propertyLabel);
        this.propertyField = new Text(selectorComposite, 2048);
        this.propertyField.setText(this.propertyName);
        GridDataFactory.swtDefaults().hint(80, -1).applyTo((Control)this.propertyField);
        Label nLabel = new Label(selectorComposite, 0);
        nLabel.setText("Number of elements");
        GridDataFactory.swtDefaults().applyTo((Control)nLabel);
        this.nField = new Text(selectorComposite, 2048);
        this.nField.setText(Integer.toString(this.numberOfItems));
        GridDataFactory.swtDefaults().hint(40, -1).applyTo((Control)this.nField);
        this.selectorField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditSelectorDialog.this.selectorIndex = EditSelectorDialog.this.selectorField.getSelectionIndex();
                selectorComposite.setVisible(EditSelectorDialog.this.isSelectorCompositeVisible());
            }
        });
        this.selectorField.select(this.selectorIndex);
        selectorComposite.setVisible(this.isSelectorCompositeVisible());
        new Label(this.content, 0).setText("Condition");
        this.conditionLabel = new Text(this.content, 8);
        GridDataFactory.swtDefaults().span(2, 1).applyTo((Control)this.conditionLabel);
        new Label(this.content, 0);
        Composite conditionPanel = new Composite(this.content, 0);
        GridDataFactory.swtDefaults().span(2, 1).applyTo((Control)conditionPanel);
        GridLayoutFactory.swtDefaults().margins(0, 0).numColumns(2).applyTo(conditionPanel);
        Button conditionButton = new Button(conditionPanel, 8);
        conditionButton.setText("Edit...");
        GridDataFactory.swtDefaults().span(1, 1).applyTo((Control)conditionButton);
        this.removeConditionButton = new Button(conditionPanel, 8);
        this.removeConditionButton.setText("Remove");
        GridDataFactory.swtDefaults().span(1, 1).applyTo((Control)this.removeConditionButton);
        this.updateCondition();
        conditionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConditionDialog dialog = new ConditionDialog(EditSelectorDialog.this.getShell(), EditSelectorDialog.this.condition);
                if (dialog.open() == 0) {
                    try {
                        EditSelectorDialog.this.condition = dialog.createCondition();
                    }
                    catch (DatabaseException e1) {
                        LOGGER.error("Creating a condition object failed", (Throwable)e1);
                    }
                    EditSelectorDialog.this.updateCondition();
                }
            }
        });
        this.removeConditionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditSelectorDialog.this.condition = null;
                EditSelectorDialog.this.updateCondition();
            }
        });
        return this.content;
    }

    private void updateCondition() {
        if (this.condition != null) {
            this.removeConditionButton.setEnabled(true);
            try {
                this.conditionLabel.setText(ElementSelector.getExpression((RequestProcessor)Simantics.getSession(), (Resource)this.condition.resource));
            }
            catch (DatabaseException databaseException) {
                LOGGER.error("Error getting expression string for " + this.condition.resource);
            }
        } else {
            this.conditionLabel.setText("No condition");
            this.removeConditionButton.setEnabled(false);
        }
        this.content.layout();
    }

    private boolean isDiagramFieldVisible() {
        return this.generatorIndex == 1;
    }

    private boolean isSelectorCompositeVisible() {
        return this.selectorIndex != 0;
    }

    class ConditionDialog
    extends Dialog {
        private Resource existingResource;
        private boolean isInverse;
        private Button inverseField;
        private int typeIndex;
        private Combo typeField;
        private Composite stackPanel;
        private StackLayout stack;
        private Composite propertyPanel;
        private Composite regionPanel;
        private Composite routePanel;
        private Composite aggregatePanel;
        private Double lowerLimit;
        private Double upperLimit;
        private String propertyName;
        private Text propertyNameField;
        private Text lowerLimitField;
        private Text upperLimitField;
        private Resource region;
        private Combo regionField;
        private Resource route;
        private Combo routeField;
        private List<ElementSelector.Condition> subConditions;
        private boolean isConjunction;
        private org.eclipse.swt.widgets.List subConditionField;
        private Combo operatorField;

        public ConditionDialog(Shell shell, ElementSelector.Condition condition) {
            super(shell);
            this.typeIndex = 0;
            this.isInverse = false;
            this.propertyName = "";
            this.upperLimit = null;
            this.lowerLimit = null;
            this.subConditions = new ArrayList<ElementSelector.Condition>();
            Resource resource = this.existingResource = condition != null ? condition.resource : null;
            if (condition != null) {
                if (condition instanceof ElementSelector.PropertyCondition) {
                    this.typeIndex = 0;
                    ElementSelector.PropertyCondition propertyCondition = (ElementSelector.PropertyCondition)condition;
                    this.propertyName = propertyCondition.propertyName;
                    this.upperLimit = propertyCondition.upperLimit;
                    this.lowerLimit = propertyCondition.lowerLimit;
                } else if (condition instanceof ElementSelector.RegionCondition) {
                    this.typeIndex = 1;
                    this.region = ((ElementSelector.RegionCondition)condition).regionResource;
                } else if (condition instanceof ElementSelector.RouteCondition) {
                    this.typeIndex = 2;
                    this.route = ((ElementSelector.RouteCondition)condition).routeResource;
                } else if (condition instanceof ElementSelector.AggregateCondition) {
                    this.typeIndex = 3;
                    this.subConditions = new ArrayList<ElementSelector.Condition>(((ElementSelector.AggregateCondition)condition).conditions);
                    this.isConjunction = ((ElementSelector.AggregateCondition)condition).type == ElementSelector.AggregateCondition.Type.CONJUNCTION;
                    this.isInverse = ((ElementSelector.AggregateCondition)condition).type == ElementSelector.AggregateCondition.Type.NEGATION;
                }
            }
        }

        protected Control createDialogArea(Composite parent) {
            this.getShell().setText("Edit selector condition");
            Composite content = (Composite)super.createDialogArea(parent);
            GridLayoutFactory.swtDefaults().numColumns(1).applyTo(content);
            GridDataFactory defaultWidth = GridDataFactory.swtDefaults().hint(200, -1);
            this.inverseField = new Button(content, 32);
            this.inverseField.setText("Is inverse");
            this.inverseField.setSelection(this.isInverse);
            this.typeField = new Combo(content, 2056);
            this.typeField.setItems(new String[]{"Property value", "In region", "On route", "Combination"});
            this.typeField.select(this.typeIndex);
            this.stackPanel = new Composite(content, 0);
            this.stack = new StackLayout();
            this.stackPanel.setLayout((Layout)this.stack);
            this.propertyPanel = new Composite(this.stackPanel, 0);
            GridLayoutFactory.swtDefaults().numColumns(2).applyTo(this.propertyPanel);
            new Label(this.propertyPanel, 0).setText("Property name");
            this.propertyNameField = new Text(this.propertyPanel, 2048);
            this.propertyNameField.setText(this.propertyName);
            defaultWidth.applyTo((Control)this.propertyNameField);
            new Label(this.propertyPanel, 0).setText("Lower limit");
            this.lowerLimitField = new Text(this.propertyPanel, 2048);
            defaultWidth.applyTo((Control)this.lowerLimitField);
            if (this.lowerLimit != null) {
                this.lowerLimitField.setText(this.lowerLimit.toString());
            }
            new Label(this.propertyPanel, 0).setText("Upper limit");
            this.upperLimitField = new Text(this.propertyPanel, 2048);
            defaultWidth.applyTo((Control)this.upperLimitField);
            if (this.upperLimit != null) {
                this.upperLimitField.setText(this.upperLimit.toString());
            }
            this.regionPanel = new Composite(this.stackPanel, 0);
            GridLayoutFactory.swtDefaults().numColumns(2).applyTo(this.regionPanel);
            new Label(this.regionPanel, 0).setText("Region");
            this.regionField = new Combo(this.regionPanel, 2056);
            this.regionField.setItems(EditSelectorDialog.this.regionNames);
            defaultWidth.applyTo((Control)this.regionField);
            if (this.region != null) {
                int regionIndex = Arrays.indexOf((Object[])EditSelectorDialog.this.regionResources, (Object)this.region);
                this.regionField.select(regionIndex);
            } else {
                this.regionField.select(0);
            }
            this.routePanel = new Composite(this.stackPanel, 0);
            GridLayoutFactory.swtDefaults().numColumns(2).applyTo(this.routePanel);
            new Label(this.routePanel, 0).setText("Route");
            this.routeField = new Combo(this.routePanel, 2056);
            this.routeField.setItems(EditSelectorDialog.this.routeNames);
            defaultWidth.applyTo((Control)this.routeField);
            if (this.route != null) {
                int routeIndex = Arrays.indexOf((Object[])EditSelectorDialog.this.routeResources, (Object)this.route);
                this.routeField.select(routeIndex);
            } else {
                this.routeField.select(0);
            }
            this.aggregatePanel = new Composite(this.stackPanel, 0);
            GridLayoutFactory.swtDefaults().numColumns(2).applyTo(this.aggregatePanel);
            new Label(this.aggregatePanel, 0).setText("Operator");
            this.operatorField = new Combo(this.aggregatePanel, 8);
            this.operatorField.setItems(new String[]{"And", "Or"});
            this.operatorField.select(this.isConjunction ? 0 : 1);
            new Label(this.aggregatePanel, 0).setText("Sub-conditions");
            Composite buttons = new Composite(this.aggregatePanel, 0);
            RowLayoutFactory.swtDefaults().justify(true).fill(true).extendedMargins(0, 0, 0, 0).type(256).applyTo(buttons);
            Button addButton = new Button(buttons, 8);
            addButton.setText("Add");
            final Button removeButton = new Button(buttons, 8);
            removeButton.setText("Remove");
            final Button editButton = new Button(buttons, 8);
            editButton.setText("Edit");
            new Label(this.aggregatePanel, 0);
            this.subConditionField = new org.eclipse.swt.widgets.List(this.aggregatePanel, 2048);
            GridDataFactory.swtDefaults().hint(200, 150).applyTo((Control)this.subConditionField);
            if (this.subConditions != null) {
                Session session = Simantics.getSession();
                ArrayList<String> items = new ArrayList<String>();
                for (ElementSelector.Condition c : this.subConditions) {
                    try {
                        items.add(ElementSelector.getExpression((RequestProcessor)session, (Resource)c.resource));
                    }
                    catch (DatabaseException e1) {
                        LOGGER.error("Condition expression read failed", (Throwable)e1);
                        items.add("<Unknown expression>");
                    }
                }
                this.subConditionField.setItems(items.toArray(new String[items.size()]));
            }
            addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ConditionDialog conditionDialog = new ConditionDialog(ConditionDialog.this.getShell(), null);
                    if (conditionDialog.open() == 0) {
                        try {
                            ElementSelector.Condition condition = conditionDialog.createCondition();
                            ConditionDialog.this.subConditions.add(condition);
                            try {
                                ConditionDialog.this.subConditionField.add(ElementSelector.getExpression((RequestProcessor)Simantics.getSession(), (Resource)condition.resource));
                            }
                            catch (DatabaseException e1) {
                                LOGGER.error("Condition expression read failed", (Throwable)e1);
                                ConditionDialog.this.subConditionField.add("<Unknown expression>");
                            }
                        }
                        catch (DatabaseException e2) {
                            LOGGER.error("Create condition failed", (Throwable)e2);
                        }
                    }
                }
            });
            removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int index = ConditionDialog.this.subConditionField.getSelectionIndex();
                    if (index >= 0) {
                        ConditionDialog.this.subConditionField.deselectAll();
                        ConditionDialog.this.subConditionField.remove(index);
                        ConditionDialog.this.subConditions.remove(index);
                        if (index < ConditionDialog.this.subConditions.size()) {
                            ConditionDialog.this.subConditionField.setSelection(index);
                        }
                    }
                    boolean selected = ConditionDialog.this.subConditionField.getSelectionIndex() >= 0;
                    removeButton.setEnabled(selected);
                    editButton.setEnabled(selected);
                }
            });
            editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int index = ConditionDialog.this.subConditionField.getSelectionIndex();
                    if (index >= 0) {
                        ElementSelector.Condition condition = (ElementSelector.Condition)ConditionDialog.this.subConditions.get(index);
                        ConditionDialog conditionDialog = new ConditionDialog(ConditionDialog.this.getShell(), condition);
                        if (conditionDialog.open() == 0) {
                            try {
                                condition = conditionDialog.createCondition();
                                ConditionDialog.this.subConditions.set(index, condition);
                                try {
                                    ConditionDialog.this.subConditionField.setItem(index, ElementSelector.getExpression((RequestProcessor)Simantics.getSession(), (Resource)condition.resource));
                                }
                                catch (DatabaseException e1) {
                                    LOGGER.error("Condition expression read failed", (Throwable)e1);
                                    ConditionDialog.this.subConditionField.setItem(index, "<Unknown expression>");
                                }
                            }
                            catch (DatabaseException e2) {
                                LOGGER.error("Create condition failed", (Throwable)e2);
                            }
                        }
                    }
                }
            });
            this.subConditionField.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean selected = ConditionDialog.this.subConditionField.getSelectionIndex() >= 0;
                    removeButton.setEnabled(selected);
                    editButton.setEnabled(selected);
                }
            });
            this.typeField.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ConditionDialog.this.updateStack();
                }
            });
            this.updateStack();
            return content;
        }

        protected void okPressed() {
            this.isInverse = this.inverseField.getSelection();
            switch (this.typeIndex) {
                case 0: {
                    this.propertyName = this.propertyNameField.getText();
                    try {
                        String lowerLimitText = this.lowerLimitField.getText();
                        this.lowerLimit = lowerLimitText.equals("") ? null : Double.valueOf(lowerLimitText);
                        String upperLimitText = this.upperLimitField.getText();
                        this.upperLimit = upperLimitText.equals("") ? null : Double.valueOf(upperLimitText);
                        break;
                    }
                    catch (NumberFormatException e) {
                        ErrorDialog.openError((Shell)this.getShell(), (String)"Error", (String)("Invalid numeric value: " + e.getMessage()), (IStatus)new Status(0, "org.simantics.district.selection.ui", e.getMessage()));
                        return;
                    }
                }
                case 1: {
                    int selectionIndex = this.regionField.getSelectionIndex();
                    if (selectionIndex < 0) {
                        ErrorDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Please select a region", (IStatus)new Status(0, "org.simantics.district.selection.ui", "No region selection"));
                        return;
                    }
                    this.region = EditSelectorDialog.this.regionResources[selectionIndex];
                    break;
                }
                case 2: {
                    this.route = EditSelectorDialog.this.routeResources[this.routeField.getSelectionIndex()];
                    break;
                }
                case 3: {
                    this.isConjunction = this.operatorField.getSelectionIndex() == 0;
                }
            }
            super.okPressed();
        }

        protected ElementSelector.Condition createCondition() throws DatabaseException {
            if (this.isInverse && (this.typeIndex != 3 || this.isConjunction)) {
                final Resource resource0 = this.createCondition0();
                Resource resource = (Resource)Simantics.getSession().syncRequest((WriteResult)new WriteResult<Resource>(){

                    public Resource perform(WriteGraph graph) throws DatabaseException {
                        ElementSelectionResource ES = ElementSelectionResource.getInstance((ReadGraph)graph);
                        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                        Resource r = graph.newResource();
                        graph.claim(r, L0.InstanceOf, ES.Negation);
                        graph.claim(r, ES.HasSubcondition, resource0);
                        return r;
                    }
                });
                return ElementSelector.getCondition((RequestProcessor)Simantics.getSession(), (Resource)resource);
            }
            return ElementSelector.getCondition((RequestProcessor)Simantics.getSession(), (Resource)this.createCondition0());
        }

        private Resource createCondition0() throws DatabaseException {
            switch (this.typeIndex) {
                case 0: {
                    return this.createPropertyCondition();
                }
                case 1: {
                    return this.createRegionCondition();
                }
                case 2: {
                    return this.createRouteCondition();
                }
                case 3: {
                    return this.createAggregateCondition();
                }
            }
            throw new IllegalStateException("Invalid condition type code " + this.typeIndex);
        }

        private Resource createPropertyCondition() throws DatabaseException {
            return (Resource)Simantics.getSession().syncRequest((WriteResult)new WriteResult<Resource>(){

                public Resource perform(WriteGraph graph) throws DatabaseException {
                    ElementSelectionResource ES = ElementSelectionResource.getInstance((ReadGraph)graph);
                    Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                    Resource r = graph.newResource();
                    graph.claim(r, L0.InstanceOf, ES.PropertyCondition);
                    graph.claimLiteral(r, ES.PropertyCondition_HasPropertyName, (Object)ConditionDialog.this.propertyName);
                    if (ConditionDialog.this.lowerLimit != null) {
                        graph.claimLiteral(r, ES.PropertyCondition_HasLowerLimit, L0.Double, (Object)ConditionDialog.this.lowerLimit);
                    }
                    if (ConditionDialog.this.upperLimit != null) {
                        graph.claimLiteral(r, ES.PropertyCondition_HasUpperLimit, L0.Double, (Object)ConditionDialog.this.upperLimit);
                    }
                    return r;
                }
            });
        }

        private Resource createAggregateCondition() throws DatabaseException {
            return (Resource)Simantics.getSession().syncRequest((WriteResult)new WriteResult<Resource>(){

                public Resource perform(WriteGraph graph) throws DatabaseException {
                    Resource r;
                    ElementSelectionResource ES = ElementSelectionResource.getInstance((ReadGraph)graph);
                    Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                    if (ConditionDialog.this.existingResource != null) {
                        r = ConditionDialog.this.existingResource;
                        graph.deny(ConditionDialog.this.existingResource);
                    } else {
                        r = graph.newResource();
                    }
                    Resource type = ConditionDialog.this.isConjunction ? ES.Conjunction : (ConditionDialog.this.isInverse ? ES.Negation : ES.Disjunction);
                    graph.claim(r, L0.InstanceOf, type);
                    for (ElementSelector.Condition c : ConditionDialog.this.subConditions) {
                        graph.claim(r, ES.HasSubcondition, c.resource);
                    }
                    return r;
                }
            });
        }

        private Resource createRouteCondition() throws DatabaseException {
            return (Resource)Simantics.getSession().syncRequest((WriteResult)new WriteResult<Resource>(){

                public Resource perform(WriteGraph graph) throws DatabaseException {
                    ElementSelectionResource ES = ElementSelectionResource.getInstance((ReadGraph)graph);
                    Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                    Resource r = graph.newResource();
                    graph.claim(r, L0.InstanceOf, ES.RouteCondition);
                    graph.claim(r, ES.RouteCondition_HasRoute, ConditionDialog.this.route);
                    return r;
                }
            });
        }

        private Resource createRegionCondition() throws DatabaseException {
            return (Resource)Simantics.getSession().syncRequest((WriteResult)new WriteResult<Resource>(){

                public Resource perform(WriteGraph graph) throws DatabaseException {
                    ElementSelectionResource ES = ElementSelectionResource.getInstance((ReadGraph)graph);
                    Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                    Resource r = graph.newResource();
                    graph.claim(r, L0.InstanceOf, ES.RegionCondition);
                    graph.claim(r, ES.RegionCondition_HasRegion, ConditionDialog.this.region);
                    return r;
                }
            });
        }

        private void updateStack() {
            this.typeIndex = this.typeField.getSelectionIndex();
            switch (this.typeIndex) {
                case 0: {
                    this.stack.topControl = this.propertyPanel;
                    break;
                }
                case 1: {
                    this.stack.topControl = this.regionPanel;
                    break;
                }
                case 2: {
                    this.stack.topControl = this.routePanel;
                    break;
                }
                case 3: {
                    this.stack.topControl = this.aggregatePanel;
                }
            }
            this.stackPanel.layout();
        }
    }
}

