/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.selection.ui.handlers;

import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.workbench.IWorkbench;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.swt.widgets.Shell;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.district.selection.ui.parts.EditSelectorDialog;
import org.simantics.utils.ui.AdaptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateNewElementSelector {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateNewElementSelector.class);

    @CanExecute
    public boolean canExecute(ESelectionService selectionService) {
        return true;
    }

    @Execute
    public void createNewElementSelector(IEclipseContext context, IWorkbench workbench) {
        Object currentSelection = context.get("org.eclipse.ui.selection");
        Shell shell = (Shell)context.getActive(Shell.class);
        EditSelectorDialog dialog = new EditSelectorDialog(shell, null, AdaptionUtils.adaptToCollection((Object)currentSelection, Resource.class));
        LOGGER.debug("Opening dialog");
        int result = dialog.open();
        LOGGER.debug("Dialog closed with result code " + result);
        if (result == 0) {
            try {
                dialog.writeSelection();
            }
            catch (DatabaseException e) {
                LOGGER.error("Writing new element selection failed", (Throwable)e);
            }
        }
    }
}

