/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.selection.ui;

import java.util.Collection;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.common.procedure.adapter.SyncListenerAdapter;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.SyncListener;
import org.simantics.db.request.Read;
import org.simantics.district.selection.ElementSelector;
import org.simantics.district.selection.ui.ElementSelectionTools;
import org.simantics.district.selection.ui.parts.ElementSelectionView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElementSelectorTableUI
extends Composite {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElementSelectorTableUI.class);
    private TreeViewer viewer;
    private ElementSelectionView view;

    public ElementSelectorTableUI(Composite parent, int style, ElementSelectionView view) {
        super(parent, style);
        this.view = view;
        parent.setLayout((Layout)new FillLayout());
        this.setLayout((Layout)new FillLayout());
        this.viewer = this.createViewer();
        this.addSelectionListener();
        this.setContentProvider();
        this.createSelectorListener(parent);
        this.enableToolTips();
        this.configureTable();
    }

    public Tree getTree() {
        return this.viewer.getTree();
    }

    public ElementSelector getSelectedItem() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        return selection != null ? (ElementSelector)selection.getFirstElement() : null;
    }

    private TreeViewer createViewer() {
        return new TreeViewer((Composite)this, 65536);
    }

    private void configureTable() {
        Tree table = this.viewer.getTree();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.createNameColumn();
        this.createQueryColumn();
    }

    private void enableToolTips() {
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer);
    }

    private void setContentProvider() {
        this.viewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public boolean hasChildren(Object element) {
                return false;
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement == null || !(inputElement instanceof Collection)) {
                    return new Object[0];
                }
                return ((Collection)inputElement).toArray();
            }

            public Object[] getChildren(Object parentElement) {
                return null;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                super.inputChanged(viewer, oldInput, newInput);
            }
        });
    }

    private TreeViewerColumn createNameColumn() {
        TreeViewerColumn column = new TreeViewerColumn(this.viewer, 0);
        column.getColumn().setText("Name");
        column.getColumn().setWidth(200);
        column.getColumn().setResizable(true);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ElementSelector selector = (ElementSelector)element;
                return selector.getName();
            }

            public Image getImage(Object element) {
                return null;
            }
        });
        return column;
    }

    private TreeViewerColumn createQueryColumn() {
        TreeViewerColumn column = new TreeViewerColumn(this.viewer, 0);
        column.getColumn().setText("Query");
        column.getColumn().setWidth(600);
        column.getColumn().setResizable(true);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ElementSelector selector = (ElementSelector)element;
                return selector.getExpression();
            }

            public Image getImage(Object element) {
                return null;
            }
        });
        return column;
    }

    private void createSelectorListener(final Composite parent) {
        Simantics.getSession().asyncRequest((Read)new ElementSelectionTools.SelectionsRequest(), (SyncListener)new SyncListenerAdapter<Collection<ElementSelector>>(){

            public void execute(ReadGraph graph, Collection<ElementSelector> result) {
                parent.getDisplay().asyncExec(() -> ElementSelectorTableUI.this.viewer.setInput((Object)result));
            }

            public void exception(ReadGraph graph, Throwable t) throws DatabaseException {
                LOGGER.error("Error getting element selector list", t);
            }

            public boolean isDisposed() {
                return ElementSelectorTableUI.this.isDisposed();
            }
        });
    }

    private void addSelectionListener() {
        this.viewer.addDoubleClickListener((IDoubleClickListener)new DoubleClickListener());
    }

    private final class DoubleClickListener
    implements IDoubleClickListener {
        private DoubleClickListener() {
        }

        public void doubleClick(DoubleClickEvent event) {
            TreeSelection selection = (TreeSelection)event.getViewer().getSelection();
            Display display = event.getViewer().getControl().getDisplay();
            ElementSelector query = (ElementSelector)selection.getFirstElement();
            ElementSelectorTableUI.this.view.performSelection(display, query);
        }
    }
}

