/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.visualisations.model;

import java.util.List;

public class DynamicSizeMap {
    private String label;
    private List<Double> sizes;

    public DynamicSizeMap(String label, List<Double> sizes) {
        this.label = label;
        this.sizes = sizes;
    }

    public String getLabel() {
        return this.label;
    }

    public List<Double> getSizes() {
        return this.sizes;
    }

    public double getSize(double value, boolean useGradient, double defaultMin, double defaultMax) {
        List<Double> sizes = this.getSizes();
        double gap = defaultMax - defaultMin;
        double singleGap = gap / (double)sizes.size();
        double threshold = defaultMin;
        int i = 0;
        while (i < sizes.size() - 1) {
            if (value <= (threshold += singleGap)) break;
            ++i;
        }
        Double size = sizes.get(i);
        if (useGradient) {
            Double upperSize = i + 1 != sizes.size() ? sizes.get(i + 1) : size;
            double delta = Math.max(value - (defaultMin + singleGap * (double)i), 0.0);
            double d = delta / singleGap;
            double sizeDelta = (upperSize - size) * d;
            return size + sizeDelta;
        }
        return size;
    }
}

