/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.profile;

import java.util.ArrayList;
import java.util.Collection;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.district.network.ontology.DistrictNetworkResource;
import org.simantics.district.network.visualisations.DynamicVisualisations;
import org.simantics.layer0.Layer0;

public class DynamicVisualisationsRequest
extends ResourceRead<Collection<NamedResource>> {
    public DynamicVisualisationsRequest(Resource parent) {
        super(parent);
    }

    public Collection<NamedResource> perform(ReadGraph graph) throws DatabaseException {
        Collection visualisationResources;
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        ArrayList<NamedResource> results = new ArrayList<NamedResource>();
        Resource visualisationFolder = DynamicVisualisations.getVisualisationFolder(graph, this.resource);
        if (visualisationFolder != null && (visualisationResources = graph.getObjects(visualisationFolder, DN.Diagram_hasVisualisation)) != null && !visualisationResources.isEmpty()) {
            for (Resource visualisationResource : visualisationResources) {
                String name = (String)graph.getRelatedValue(visualisationResource, Layer0.getInstance((ReadGraph)graph).HasName);
                results.add(new NamedResource(name, visualisationResource));
            }
        }
        return results;
    }
}

