/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.profile;

import java.awt.Color;
import java.util.Map;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.Read;
import org.simantics.district.network.ontology.DistrictNetworkResource;
import org.simantics.district.network.profile.RuntimeDynamicVisualisationsRequest;
import org.simantics.district.network.profile.ThrottledStyleBase;
import org.simantics.district.network.visualisations.DynamicVisualisationsContributions;
import org.simantics.district.network.visualisations.model.DynamicColorContribution;
import org.simantics.district.network.visualisations.model.DynamicColorMap;
import org.simantics.district.network.visualisations.model.DynamicVisualisation;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.nodes.SingleElementNode;
import org.simantics.scenegraph.profile.EvaluationContext;
import org.simantics.scenegraph.profile.common.ProfileVariables;
import org.simantics.scl.runtime.SCLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DNElementColorStyle
extends ThrottledStyleBase<Color> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DNElementColorStyle.class);
    private static final boolean DEBUG = false;

    @Override
    public Color calculateThrottledStyle(ReadGraph graph, Resource runtimeDiagram, Resource entry, Resource groupItem) throws DatabaseException {
        DynamicVisualisation dv = (DynamicVisualisation)graph.syncRequest((Read)new RuntimeDynamicVisualisationsRequest(runtimeDiagram), (AsyncProcedure)TransientCacheAsyncListener.instance());
        boolean wasSynchronous = graph.setSynchronous(true);
        try {
            if (dv != null) {
                String mappingName;
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
                ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
                Resource mapping = graph.getSingleObject(groupItem, DN.HasMapping);
                Map<String, DynamicColorContribution> colorContributions = dv.getColorContributions();
                DynamicColorContribution dcc = colorContributions.get(mappingName = (String)graph.getRelatedValue(mapping, L0.HasName));
                if (dcc != null && dcc.isUsed()) {
                    Resource mappedComponent = graph.getPossibleObject(groupItem, DN.MappedComponent);
                    if (mappedComponent != null) {
                        Resource component = graph.getSingleObject(mappedComponent, MOD.ElementToComponent);
                        Variable variable = Variables.getVariable((ReadGraph)graph, (Resource)component);
                        Variable possibleActiveVariable = Variables.possibleActiveVariable((ReadGraph)graph, (Variable)variable);
                        if (possibleActiveVariable != null) {
                            Variable module = possibleActiveVariable.getPossibleChild(graph, dcc.getModuleName());
                            if (module != null) {
                                Variable attribute = module.getPossibleProperty(graph, dcc.getAttributeName());
                                if (attribute != null) {
                                    Double possibleValue = (Double)attribute.getPossibleValue(graph, (Binding)Bindings.DOUBLE);
                                    if (possibleValue != null) {
                                        Color color;
                                        double maxValue;
                                        double minValue;
                                        if (dcc.isUseDefault()) {
                                            DynamicVisualisationsContributions.DynamicColoringObject dynamicColoringObject = dv.getDefaultColorContributions().get(mappingName);
                                            Object currentGraph = SCLContext.getCurrent().get((Object)"graph");
                                            try {
                                                SCLContext.getCurrent().put((Object)"graph", (Object)graph);
                                                DynamicColorContribution ddcc = dynamicColoringObject.getColorContributions().get(dcc.getLabel());
                                                minValue = ddcc.getDefaultMin();
                                                maxValue = ddcc.getDefaultMax();
                                            }
                                            finally {
                                                SCLContext.getCurrent().put((Object)"graph", currentGraph);
                                            }
                                        } else {
                                            minValue = dcc.getDefaultMin();
                                            maxValue = dcc.getDefaultMax();
                                        }
                                        double adjustedValue = possibleValue * dcc.getVariableGain() + dcc.getVariableBias();
                                        DynamicColorMap defaultColorMap = dcc.getDefaultColorMap();
                                        Color color2 = color = defaultColorMap.getColor(adjustedValue, dv.getColorBarOptions().isUseGradients(), minValue, maxValue);
                                        return color2;
                                    }
                                    LOGGER.warn("No value for {}", (Object)attribute.getURI(graph));
                                } else {
                                    LOGGER.warn("Wrong attribute name {} for {} !!", (Object)dcc.getAttributeName(), (Object)module.getURI(graph));
                                }
                            } else {
                                LOGGER.warn("Wrong modulename {} for {} !!", (Object)dcc.getModuleName(), (Object)possibleActiveVariable.getURI(graph));
                            }
                        } else {
                            LOGGER.debug("No active experiment for {}", (Object)variable.getURI(graph));
                        }
                    } else {
                        LOGGER.debug("No mapped component for {} to calculate dynamic color style", (Object)groupItem);
                    }
                }
            }
        }
        finally {
            graph.setSynchronous(wasSynchronous);
        }
        return null;
    }

    @Override
    public void applyThrottledStyleForNode(EvaluationContext observer, INode node, Color color) {
        SingleElementNode n = (SingleElementNode)node;
        for (INode nn : n.getNodes()) {
            ProfileVariables.claimNodeProperty((INode)nn, (String)"dynamicColor", (Object)color, (EvaluationContext)observer);
        }
    }

    protected void cleanupStyleForNode(EvaluationContext evaluationContext, INode node) {
        SingleElementNode n = (SingleElementNode)node;
        for (INode nn : n.getNodes()) {
            ProfileVariables.claimNodeProperty((INode)nn, (String)"dynamicColor", null, (EvaluationContext)evaluationContext);
        }
    }
}

