/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.datatypes.literal.RGB;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.request.IndexRoot;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.BindingException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ManyObjectsForFunctionalRelationException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.indexing.IndexUtils;
import org.simantics.db.layer0.request.PossibleVariable;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.diagram.synchronization.graph.layer.GraphLayer;
import org.simantics.diagram.synchronization.graph.layer.IGraphLayerUtil;
import org.simantics.district.network.CRS;
import org.simantics.district.network.ontology.DistrictNetworkResource;
import org.simantics.layer0.Layer0;
import org.simantics.maps.elevation.server.SingletonTiffTileInterface;
import org.simantics.maps.elevation.server.prefs.MapsElevationServerPreferences;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.adapters.NewCompositeActionFactory;
import org.simantics.operation.Layer0X;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistrictNetworkUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(DistrictNetworkUtil.class);

    public static Resource createEdge(WriteGraph graph, Resource composite, double[] detailedGeometryCoords) throws DatabaseException {
        return DistrictNetworkUtil.createEdge(graph, composite, graph.getPossibleObject(composite, DistrictNetworkResource.getInstance((ReadGraph)graph).EdgeDefaultMapping), detailedGeometryCoords);
    }

    public static Resource createEdge(WriteGraph graph, Resource composite, Resource mapping, double[] detailedGeometryCoords) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        if (mapping == null) {
            mapping = graph.getSingleObject(composite, DN.EdgeDefaultMapping);
        }
        Resource edge = graph.newResource();
        graph.claim(edge, L0.InstanceOf, DN.Edge);
        graph.claim(edge, DN.HasMapping, null, mapping);
        OrderedSetUtils.addFirst((WriteGraph)graph, (Resource)composite, (Resource)edge);
        graph.claim(composite, L0.ConsistsOf, L0.PartOf, edge);
        DistrictNetworkUtil.claimFreshElementName(graph, composite, edge);
        for (Resource layer : graph.getObjects(composite, DiagramResource.getInstance((ReadGraph)graph).HasLayer)) {
            IGraphLayerUtil layerUtil = (IGraphLayerUtil)graph.adapt(graph.getSingleObject(layer, Layer0.getInstance((ReadGraph)graph).InstanceOf), IGraphLayerUtil.class);
            GraphLayer gl = layerUtil.loadLayer((ReadGraph)graph, layer);
            gl.forEachTag(tag -> DiagramGraphUtil.tag((WriteGraph)graph, (Resource)edge, (Resource)tag, (boolean)true));
        }
        graph.claimLiteral(edge, DN.Edge_HasGeometry, (Object)detailedGeometryCoords, (Binding)Bindings.DOUBLE_ARRAY);
        return edge;
    }

    public static Resource createVertex(WriteGraph graph, Resource composite, double[] coords, double elevation) throws DatabaseException {
        Resource defaultVertexMapping = graph.getPossibleObject(composite, DistrictNetworkResource.getInstance((ReadGraph)graph).VertexDefaultMapping);
        return DistrictNetworkUtil.createVertex(graph, composite, coords, elevation, defaultVertexMapping);
    }

    public static Resource createVertex(WriteGraph graph, Resource composite, double[] coords, double elevation, Resource mapping) throws DatabaseException {
        if (elevation == Double.MAX_VALUE) {
            if (MapsElevationServerPreferences.useElevationServer()) {
                try {
                    elevation = SingletonTiffTileInterface.lookup((double)coords[1], (double)coords[0]).doubleValue();
                }
                catch (Exception ee) {
                    LOGGER.error("Could not get elevation from tiff interface", (Throwable)ee);
                }
            } else {
                elevation = 0.0;
            }
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Resource vertex = graph.newResource();
        graph.claim(vertex, L0.InstanceOf, DN.Vertex);
        graph.claimLiteral(vertex, DIA.HasLocation, (Object)coords);
        graph.claimLiteral(vertex, DN.Vertex_HasElevation, (Object)elevation, (Binding)Bindings.DOUBLE);
        graph.claim(vertex, DN.HasMapping, null, mapping);
        OrderedSetUtils.add((WriteGraph)graph, (Resource)composite, (Resource)vertex);
        graph.claim(composite, L0.ConsistsOf, L0.PartOf, vertex);
        DistrictNetworkUtil.claimFreshElementName(graph, composite, vertex);
        for (Resource layer : graph.getObjects(composite, DiagramResource.getInstance((ReadGraph)graph).HasLayer)) {
            IGraphLayerUtil layerUtil = (IGraphLayerUtil)graph.adapt(graph.getSingleObject(layer, Layer0.getInstance((ReadGraph)graph).InstanceOf), IGraphLayerUtil.class);
            GraphLayer gl = layerUtil.loadLayer((ReadGraph)graph, layer);
            gl.forEachTag(tag -> DiagramGraphUtil.tag((WriteGraph)graph, (Resource)vertex, (Resource)tag, (boolean)true));
        }
        return vertex;
    }

    public static Resource joinVertices(WriteGraph graph, Collection<Resource> vertices) throws DatabaseException {
        if (vertices.isEmpty()) {
            throw new IllegalArgumentException("vertices-collection should not be empty for joining vertices!");
        }
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        Iterator<Resource> verticeIterator = vertices.iterator();
        Resource master = verticeIterator.next();
        while (verticeIterator.hasNext()) {
            Resource slave = verticeIterator.next();
            Resource composite = graph.getSingleObject(slave, Layer0.getInstance((ReadGraph)graph).PartOf);
            Collection startVertexEdges = graph.getObjects(slave, DN.HasStartVertex_Inverse);
            for (Resource startVertexEdge : startVertexEdges) {
                graph.deny(startVertexEdge, DN.HasStartVertex);
                graph.claim(startVertexEdge, DN.HasStartVertex, master);
            }
            Collection endVertexEdges = graph.getObjects(slave, DN.HasEndVertex_Inverse);
            for (Resource endVertexEdge : endVertexEdges) {
                graph.deny(endVertexEdge, DN.HasEndVertex);
                graph.claim(endVertexEdge, DN.HasEndVertex, master);
            }
            OrderedSetUtils.remove((WriteGraph)graph, (Resource)composite, (Resource)slave);
            graph.deny(composite, Layer0.getInstance((ReadGraph)graph).ConsistsOf, slave);
        }
        return master;
    }

    public static double calculateDistance(ReadGraph graph, Resource startVertex, Resource endVertex) throws DatabaseException {
        Resource endComposite;
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource startComposite = graph.getSingleObject(startVertex, L0.PartOf);
        if (!startComposite.equalsResource(endComposite = graph.getSingleObject(endVertex, L0.PartOf))) {
            throw new DatabaseException("Can not calculate distance between vertices on different composites! " + startVertex + " -> " + endVertex);
        }
        Resource crs = graph.getSingleObject(startComposite, DistrictNetworkResource.getInstance((ReadGraph)graph).HasSpatialRefSystem);
        CRS crsClass = (CRS)graph.adapt(crs, CRS.class);
        double[] startCoords = (double[])graph.getRelatedValue2(startVertex, DiagramResource.getInstance((ReadGraph)graph).HasLocation, (Binding)Bindings.DOUBLE_ARRAY);
        double[] endCoords = (double[])graph.getRelatedValue2(endVertex, DiagramResource.getInstance((ReadGraph)graph).HasLocation, (Binding)Bindings.DOUBLE_ARRAY);
        return crsClass.calculateDistance(startCoords, endCoords);
    }

    public static final String claimFreshElementName(WriteGraph graph, Resource diagram, Resource element) throws DatabaseException {
        Long l;
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        String namePrefix = (String)graph.getPossibleRelatedValue2(diagram, Layer0X.getInstance((ReadGraph)graph).HasGeneratedNamePrefix);
        if (namePrefix == null) {
            namePrefix = "";
        }
        if ((l = (Long)graph.getPossibleRelatedValue(diagram, DIA.HasModCount, (Binding)Bindings.LONG)) == null) {
            l = 0L;
        }
        String name = String.valueOf(namePrefix) + l.toString();
        graph.claimLiteral(element, L0.HasName, (Object)name, (Binding)Bindings.STRING);
        l = l + 1L;
        graph.claimLiteral(diagram, DIA.HasModCount, (Object)l, (Binding)Bindings.LONG);
        return name;
    }

    public static Resource getDiagramElement(ReadGraph graph, Resource component) throws DatabaseException {
        if (component == null) {
            return null;
        }
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        if (graph.isInstanceOf(component, DIA.Element)) {
            return component;
        }
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        Resource element = graph.getPossibleObject(component, MOD.ComponentToElement);
        return element != null && graph.isInstanceOf(element, DIA.Element) ? element : null;
    }

    public static Resource getMappedElement(ReadGraph graph, Resource element) throws DatabaseException {
        if (element == null) {
            return null;
        }
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        return graph.getPossibleObject(element, DN.MappedComponent);
    }

    public static Resource getMappedComponent(ReadGraph graph, Resource element) throws DatabaseException {
        if (element == null) {
            return null;
        }
        Resource mappedElement = DistrictNetworkUtil.getMappedElement(graph, element);
        if (mappedElement == null) {
            return null;
        }
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        return graph.getPossibleObject(mappedElement, MOD.ElementToComponent);
    }

    public static Resource getMappedComponentCached(ReadGraph graph, Resource vertex) throws DatabaseException {
        return (Resource)graph.syncRequest((Read)new MappedComponentRequest(vertex), (Listener)TransientCacheListener.instance());
    }

    public static Resource getMappedDNElement(ReadGraph graph, Resource element) throws DatabaseException {
        if (element == null) {
            return null;
        }
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        return graph.getPossibleObject(element, DN.MappedFromElement);
    }

    public static Variable toMappedConfigurationModule(ReadGraph graph, Resource input) throws DatabaseException {
        if (input == null) {
            return null;
        }
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        if (graph.isInstanceOf(input, DN.Element)) {
            Resource mappedElement = DistrictNetworkUtil.getMappedElement(graph, input);
            if (mappedElement == null) {
                return null;
            }
            ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
            Resource mappedComponent = graph.getPossibleObject(mappedElement, MOD.ElementToComponent);
            if (mappedComponent == null) {
                return null;
            }
            return (Variable)graph.syncRequest((Read)new PossibleVariable(mappedComponent));
        }
        return null;
    }

    public static void toggleDrawMap(WriteGraph graph, Resource diagram) throws ManyObjectsForFunctionalRelationException, BindingException, ServiceException {
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        Boolean current = (Boolean)graph.getPossibleRelatedValue(diagram, DN.Diagram_drawMapEnabled, (Binding)Bindings.BOOLEAN);
        if (current == null) {
            current = true;
        }
        graph.claimLiteral(diagram, DN.Diagram_drawMapEnabled, (Object)(current == false ? 1 : 0), (Binding)Bindings.BOOLEAN);
    }

    public static Boolean drawMapEnabled(ReadGraph graph, Resource diagram) throws ManyObjectsForFunctionalRelationException, BindingException, ServiceException {
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        Boolean current = (Boolean)graph.getPossibleRelatedValue(diagram, DN.Diagram_drawMapEnabled, (Binding)Bindings.BOOLEAN);
        return current != null ? current : true;
    }

    public static void changeMapBackgroundColor(WriteGraph graph, Resource diagram, RGB.Integer integer) throws DatabaseException {
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        graph.claimLiteral(diagram, DN.Diagram_backgroundColor, (Object)integer, Bindings.getBindingUnchecked(RGB.Integer.class));
    }

    public static Boolean trackChangesEnabled(ReadGraph graph, Resource diagram) throws DatabaseException {
        if (diagram != null && graph.hasStatement(diagram)) {
            return Boolean.TRUE.equals(graph.getPossibleRelatedValue(diagram, DistrictNetworkResource.getInstance((ReadGraph)graph).Diagram_trackChangesEnabled));
        }
        return false;
    }

    public static RGB.Integer backgroundColor(ReadGraph graph, Resource diagram) throws DatabaseException {
        return (RGB.Integer)graph.getPossibleRelatedValue(diagram, DistrictNetworkResource.getInstance((ReadGraph)graph).Diagram_backgroundColor, Bindings.getBindingUnchecked(RGB.Integer.class));
    }

    public static Resource createNetworkDiagram(WriteGraph graph, Resource target, Resource compositeType, String defaultName, Resource defaultEdgeMapping, Resource defaultVertexMapping, Resource rightClickVertexMapping, Resource leftClickVertexMapping, Resource crs) throws DatabaseException {
        Resource composite = NewCompositeActionFactory.createComposite((WriteGraph)graph, (Resource)target, (String)defaultName, (Resource)compositeType);
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        Resource diagram = graph.getSingleObject(composite, ModelingResources.getInstance((ReadGraph)graph).CompositeToDiagram);
        graph.claim(diagram, DN.EdgeDefaultMapping, defaultEdgeMapping);
        graph.claim(diagram, DN.VertexDefaultMapping, defaultVertexMapping);
        graph.claim(diagram, DN.RightClickDefaultMapping, rightClickVertexMapping);
        graph.claim(diagram, DN.LeftClickDefaultMapping, leftClickVertexMapping);
        graph.claim(diagram, DN.HasSpatialRefSystem, crs);
        String compositeName = (String)graph.getRelatedValue2(composite, Layer0.getInstance((ReadGraph)graph).HasName, (Binding)Bindings.STRING);
        graph.claimLiteral(diagram, Layer0X.getInstance((ReadGraph)graph).HasGeneratedNamePrefix, (Object)("N" + compositeName.substring(compositeName.length() - 1, compositeName.length())));
        return composite;
    }

    public static void changeMappingType(WriteGraph graph, Resource newMapping, List<Resource> elements) throws DatabaseException {
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        for (Resource element : elements) {
            graph.deny(element, DN.HasMapping);
            graph.claim(element, DN.HasMapping, newMapping);
        }
    }

    public static Stream<Resource> findDNElementsById(ReadGraph graph, Resource context, String idToFind) throws DatabaseException {
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        return IndexUtils.findByType((ReadGraph)graph, (Resource)((Resource)graph.syncRequest((Read)new IndexRoot(context))), (Resource)DN.Element).stream().filter(element -> {
            try {
                String id = (String)graph.getPossibleRelatedValue(element, districtNetworkResource.HasId, (Binding)Bindings.STRING);
                return id != null && id.contains(idToFind);
            }
            catch (DatabaseException e) {
                LOGGER.error("Could not read id for element {]", element, (Object)e);
                return false;
            }
        });
    }

    public static Resource findDNElementById(ReadGraph graph, Resource context, String idToFind) throws DatabaseException {
        List elements = DistrictNetworkUtil.findDNElementsById(graph, context, idToFind).collect(Collectors.toList());
        if (elements.size() == 1) {
            return (Resource)elements.iterator().next();
        }
        return null;
    }

    public static List<Resource> findDNElementByXYCoordinates(ReadGraph graph, Resource context, double lat, double lon, double padding) throws DatabaseException {
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        ArrayList<Resource> results = new ArrayList<Resource>();
        Collection vertices = IndexUtils.findByType((ReadGraph)graph, (Resource)((Resource)graph.syncRequest((Read)new IndexRoot(context))), (Resource)DN.Vertex);
        Rectangle2D.Double rect = new Rectangle2D.Double(lat, lon, padding, padding);
        for (Resource vertex : vertices) {
            double[] location = (double[])graph.getRelatedValue(vertex, DIA.HasLocation, (Binding)Bindings.DOUBLE_ARRAY);
            if (!rect.contains(location[0], location[1])) continue;
            results.add(vertex);
        }
        return results;
    }

    public static final class MappedComponentRequest
    extends ResourceRead<Resource> {
        public MappedComponentRequest(Resource element) {
            super(element);
        }

        public Resource perform(ReadGraph graph) throws DatabaseException {
            return DistrictNetworkUtil.getMappedComponent(graph, this.resource);
        }
    }

    public static class ResourceVertex {
        public final boolean isConsumer;
        public final Resource vertex;
        public final double[] coords;

        public ResourceVertex(Resource vertex, double[] coords, boolean isConsumer) {
            this.vertex = vertex;
            this.coords = coords;
            this.isConsumer = isConsumer;
        }
    }
}

