/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.maps.tile;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import org.simantics.maps.ProvisionException;
import org.simantics.maps.internal.ImageUtil;
import org.simantics.maps.tile.ITileProvider;
import org.simantics.maps.tile.TileKey;

public class Shp2ImgTileProvider
implements ITileProvider {
    private static final String SHP2IMG_EXECUTABLE = "c:\\ms4w\\tools\\mapserv\\shp2img.exe";
    private static final String SCHEME = "shp2img";
    final URI source;
    final File mapDirectory;
    final String mapName;
    final int tilePixelSize;
    final String tileSizeString;
    Rectangle2D extentDegrees;
    Rectangle2D extentMeters;
    double deWidthRecip;
    double deHeightRecip;
    String[] ENVP = null;
    BufferedImage outOfBoundsImage;

    public Shp2ImgTileProvider(String mapDirectory, String mapName, int tilePixelSize, Rectangle2D extentDegrees, Rectangle2D extentMeters) {
        String[] segments;
        this.mapDirectory = new File(mapDirectory);
        this.mapName = mapName;
        this.tilePixelSize = tilePixelSize;
        this.tileSizeString = String.valueOf(tilePixelSize);
        this.extentDegrees = extentDegrees;
        this.extentMeters = extentMeters;
        this.deWidthRecip = 1.0 / extentDegrees.getWidth();
        this.deHeightRecip = 1.0 / extentDegrees.getHeight();
        if (!this.mapDirectory.exists()) {
            throw new IllegalArgumentException("Map directory '" + mapDirectory + "' does not exist");
        }
        StringBuilder host = new StringBuilder();
        boolean first = true;
        String[] stringArray = segments = mapDirectory.split(File.pathSeparator);
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            String seg = stringArray[n2];
            if (!first) {
                host.append('.');
            }
            first = false;
            host.append(seg);
            ++n2;
        }
        host.append('.');
        host.append(mapName);
        try {
            this.source = new URI(SCHEME, host.toString(), null, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Shp2ImgTileProvider: Problem in URI generation with mapDirectory=" + mapDirectory + ", mapName= " + mapName, e);
        }
        ArrayList<String> envp = new ArrayList<String>();
        envp.add("GDAL_DATA=c:\\ms4w\\gdaldata");
        envp.add("GDAL_DRIVER_PATH=c:\\ms4w\\gdalplugins");
        envp.add("PROJ_LIB=c:\\ms4w\\proj\\nad");
        envp.add("PATH=c:\\ms4w\\Apache\\cgi-bin;c:\\ms4w\\tools\\gdal-ogr;c:\\ms4w\\tools\\mapserv;c:\\ms4w\\tools\\shapelib;c:\\ms4w\\proj\\bin;c:\\ms4w\\tools\\shp2tile;c:\\ms4w\\tools\\shpdiff;c:\\ms4w\\tools\\avce00;c:\\ms4w\\tools\\demtools;");
        this.ENVP = envp.toArray(new String[0]);
    }

    @Override
    public URI getSource() {
        return this.source;
    }

    @Override
    public Rectangle2D getExtent() {
        return this.extentDegrees;
    }

    @Override
    public Image get(TileKey key) throws ProvisionException {
        int level = key.getLevel();
        int x = key.getX();
        int y = key.getY();
        double xTiles = Math.pow(2.0, level + 1);
        double yTiles = Math.pow(2.0, level);
        if (level < 0) {
            throw new IllegalArgumentException("invalid tile level " + level + " (tile=" + key + ")");
        }
        if (x < 0 || x >= (int)xTiles) {
            throw new IllegalArgumentException("tile x out of bounds " + x + " (tile=" + key + ")");
        }
        if (y < 0 || y >= (int)yTiles) {
            throw new IllegalArgumentException("tile y out of bounds " + y + " (tile=" + key + ")");
        }
        Rectangle2D.Double r = new Rectangle2D.Double();
        double minx = -180.0;
        double miny = -90.0;
        double w = 360.0;
        double h = 180.0;
        double xdelta = w / xTiles;
        double ydelta = h / yTiles;
        double xx = x;
        double yy = yTiles - (double)y - 1.0;
        r.setFrame(minx + xdelta * xx, miny + ydelta * yy, xdelta, ydelta);
        if (r.intersects(this.extentDegrees)) {
            Rectangle2D meters = this.transformDegreesToMeters(r);
            try {
                return this.getImage(meters);
            }
            catch (IOException e) {
                throw new ProvisionException(e);
            }
        }
        return this.getOutOfBoundsImage();
    }

    private Image getOutOfBoundsImage() {
        if (this.outOfBoundsImage != null) {
            return this.outOfBoundsImage;
        }
        BufferedImage image = ImageUtil.createScreenCompatibleImage(1, 1, 1);
        Graphics2D g = image.createGraphics();
        try {
            g.setColor(Color.PINK);
            g.fillRect(0, 0, 1, 1);
            this.outOfBoundsImage = image;
            BufferedImage bufferedImage = image;
            return bufferedImage;
        }
        finally {
            g.dispose();
        }
    }

    private Rectangle2D transformDegreesToMeters(Rectangle2D r) {
        double nx1 = (r.getMinX() - this.extentDegrees.getMinX()) * this.deWidthRecip;
        double ny1 = (r.getMinY() - this.extentDegrees.getMinY()) * this.deHeightRecip;
        double nx2 = (r.getMaxX() - this.extentDegrees.getMinX()) * this.deWidthRecip;
        double ny2 = (r.getMaxY() - this.extentDegrees.getMinY()) * this.deHeightRecip;
        double dw = this.extentMeters.getWidth();
        double dh = this.extentMeters.getHeight();
        Rectangle2D.Double result = new Rectangle2D.Double();
        result.setFrameFromDiagonal(this.extentMeters.getMinX() + nx1 * dw, this.extentMeters.getMinY() + ny1 * dh, this.extentMeters.getMinX() + nx2 * dw, this.extentMeters.getMinY() + ny2 * dh);
        return result;
    }

    private BufferedImage getImage(Rectangle2D r) throws IOException {
        BufferedImage bufferedImage;
        block11: {
            String tileSizeStringY;
            String tileSizeStringX;
            double h;
            double w = r.getWidth();
            if (w > (h = r.getHeight())) {
                tileSizeStringX = this.tileSizeString;
                tileSizeStringY = "" + (int)Math.round((double)this.tilePixelSize * (h / w));
            } else {
                tileSizeStringX = "" + (int)Math.round((double)this.tilePixelSize * (w / h));
                tileSizeStringY = this.tileSizeString;
            }
            File tempFile = File.createTempFile("map", ".png");
            String[] cmd = new String[]{SHP2IMG_EXECUTABLE, "-m", this.mapName, "-o", tempFile.getAbsolutePath(), "-s", tileSizeStringX, tileSizeStringY, "-e", String.valueOf(r.getMinX()), String.valueOf(r.getMinY()), String.valueOf(r.getMaxX()), String.valueOf(r.getMaxY())};
            try {
                Process p = Runtime.getRuntime().exec(cmd, this.ENVP, this.mapDirectory);
                int result = p.waitFor();
                if (result != 0) {
                    throw new ProvisionException("c:\\ms4w\\tools\\mapserv\\shp2img.exe returned error code: " + result);
                }
                BufferedImage img = ImageIO.read(tempFile);
                if (img == null) {
                    throw new ProvisionException("Failed to provide image for rectangle: " + r);
                }
                bufferedImage = ImageUtil.toScreenCompatibleImage(img);
                if (!tempFile.exists()) break block11;
                tempFile.delete();
            }
            catch (Throwable throwable) {
                try {
                    if (tempFile.exists()) {
                        tempFile.delete();
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ProvisionException(e);
                }
                catch (InterruptedException e) {
                    throw new ProvisionException(e);
                }
            }
        }
        return bufferedImage;
    }

    public static void main(String[] args) {
        try {
            Rectangle2D.Double degreeExtent = new Rectangle2D.Double();
            Rectangle2D.Double meterExtent = new Rectangle2D.Double();
            degreeExtent.setFrameFromDiagonal(24.8, 60.175, 24.84, 60.195);
            meterExtent.setFrameFromDiagonal(2544800.0, 6674000.0, 2546842.4, 6676000.0);
            Shp2ImgTileProvider p = new Shp2ImgTileProvider("d:/TerrasolidOtaniemiMalli/ortho", "global.map", 512, degreeExtent, meterExtent);
            BufferedImage buf = p.getImage(meterExtent);
            ImageIO.write((RenderedImage)buf, "png", new File("d:\\temp\\test.png"));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

