/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.maps.sg;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.geotools.referencing.CRS;
import org.geotools.referencing.GeodeticCalculator;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.simantics.maps.sg.Formatting;
import org.simantics.maps.sg.MapInfoConstants;
import org.simantics.maps.sg.MapInfoNode;
import org.simantics.scenegraph.utils.DPIUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapScaleNode
extends MapInfoNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(MapScaleNode.class);
    private static final long serialVersionUID = -2738682328944298290L;
    private static final Color GRAY = new Color(50, 50, 50);
    private static final transient int SCALE_VERTICAL_MARGIN = 4;
    private static final transient int SCALE_MAJOR_TICK_HEIGHT = 8;
    private static final transient int SCALE_MINOR_TICK_HEIGHT = 5;
    private static final transient int SCALE_MICRO_TICK_HEIGHT = 3;
    private static final transient double SCALE_RIGHT_MARGIN = 20.0;
    private static final transient int MAX_DIGITS = 0;
    private static final transient double TRIM_THRESHOLD_MAX_VALUE = Math.pow(10.0, 2.0);
    private static final transient String[] SI_LENGTH_UNIT = new String[]{"m", "km"};
    private static final transient double[] SCALE_VALUES = new double[]{2.0, 5.0, 10.0, 20.0, 50.0, 100.0, 200.0, 500.0, 1000.0, 2000.0, 5000.0, 10000.0, 20000.0, 50000.0, 100000.0, 200000.0, 500000.0, 1000000.0, 2000000.0, 5000000.0, 1.0E7, 2.0E7, 5.0E7};
    private GeodeticCalculator calculator;

    public void render(Graphics2D g) {
        if (!this.enabled || this.calculator == null) {
            return;
        }
        AffineTransform ot = g.getTransform();
        g.transform(this.transform);
        AffineTransform tr = g.getTransform();
        double scaleX = Math.abs(tr.getScaleX());
        double scaleY = Math.abs(tr.getScaleY());
        if (scaleX <= 0.0 || scaleY <= 0.0) {
            return;
        }
        double offsetX = tr.getTranslateX();
        double offsetY = tr.getTranslateY();
        g.setTransform(new AffineTransform());
        Rectangle controlBounds = g.getClipBounds();
        if (controlBounds == null) {
            return;
        }
        Font font = MapInfoConstants.getInfoFont();
        g.setFont(font);
        FontMetrics fm = g.getFontMetrics();
        int majorTickHeight = DPIUtil.upscale((int)8);
        int minorTickHeight = DPIUtil.upscale((int)5);
        int microTickHeight = DPIUtil.upscale((int)3);
        double yOffsetFromBottom = this.getMapInfoNextY(g);
        double scaleTotalHeight = Math.max(majorTickHeight + 8, font.getSize() + 4);
        double scaleMaxX = controlBounds.getMaxX() - 20.0;
        double scaleMaxY = controlBounds.getMaxY() - yOffsetFromBottom;
        double scaleMinY = scaleMaxY - scaleTotalHeight;
        int textY = (int)scaleMinY + 2 + fm.getMaxAscent();
        double meterPerPixel = this.getMeterPerPixel(scaleMaxX - offsetX, scaleMinY - offsetY, scaleX, scaleY);
        if (meterPerPixel < 0.005) {
            return;
        }
        double scaleWidth = this.findScaleWidth(meterPerPixel);
        double scaleMinX = scaleMaxX - scaleWidth;
        double value = scaleWidth * meterPerPixel;
        String formattedValue = this.formatValue(value);
        Rectangle2D textBounds = fm.getStringBounds(formattedValue, g);
        double addedTextWidth = textBounds.getWidth() + 20.0;
        scaleMaxX -= addedTextWidth;
        this.rect.setFrame(scaleMinX -= addedTextWidth, scaleMinY, scaleWidth + addedTextWidth, scaleTotalHeight);
        Composite oc = g.getComposite();
        g.setComposite(AlphaComposite.getInstance(3, 0.8f));
        g.setStroke(MapInfoConstants.INFO_STROKE);
        g.setColor(MapInfoConstants.TEXT_BG_COLOR);
        g.fill(this.rect);
        g.setColor(Color.BLACK);
        g.drawString(formattedValue, (int)(scaleMinX + scaleWidth) + 10, textY);
        double stepX = scaleWidth;
        g.setColor(GRAY);
        int yOffset = -4;
        g.drawLine((int)scaleMinX, (int)scaleMaxY + yOffset + 1, (int)scaleMaxX, (int)scaleMaxY + yOffset + 1);
        g.drawLine((int)scaleMinX, (int)scaleMaxY - majorTickHeight + yOffset, (int)scaleMinX, (int)scaleMaxY + yOffset);
        g.drawLine((int)scaleMaxX, (int)scaleMaxY - majorTickHeight + yOffset, (int)scaleMaxX, (int)scaleMaxY + yOffset);
        double x = scaleMinX;
        if (stepX / 5.0 > 2.0) {
            double x2 = x + stepX / 5.0;
            while (x2 < x + stepX) {
                if (x2 > 20.0) {
                    g.drawLine((int)x2, (int)scaleMaxY - minorTickHeight + yOffset, (int)x2, (int)scaleMaxY + yOffset);
                }
                x2 += stepX / 5.0;
            }
            x2 = x + stepX / 10.0;
            while (x2 < x + stepX) {
                if (x2 > 20.0) {
                    g.drawLine((int)x2, (int)scaleMaxY - microTickHeight + yOffset, (int)x2, (int)scaleMaxY + yOffset);
                }
                x2 += stepX / 5.0;
            }
        }
        g.setComposite(oc);
        g.setTransform(ot);
        this.setMapInfoNextY(g, yOffsetFromBottom + scaleTotalHeight + 4.0);
    }

    private String formatValue(double value) {
        int lengthUnit = 0;
        if (value > 1000.0) {
            value /= 1000.0;
            lengthUnit = 1;
        }
        return String.valueOf(Formatting.formatValue(value, 0, true, Formatting.FormatMode.LIMIT_DECIMALS, TRIM_THRESHOLD_MAX_VALUE, false)) + " " + SI_LENGTH_UNIT[lengthUnit];
    }

    public void init() {
        try {
            CoordinateReferenceSystem EPSG4326 = CRS.decode((String)"EPSG:4326");
            this.calculator = new GeodeticCalculator(EPSG4326);
        }
        catch (FactoryException e) {
            LOGGER.error("Failed to initialize GeodeticCalculator with coordinate reference system EPSG:4326", (Throwable)e);
        }
        super.init();
    }

    private double getMeterPerPixel(double screenX, double screenY, double scaleX, double scaleY) {
        double startLon = screenX / scaleX;
        double val = screenY / scaleY;
        double startLat = val = Math.toDegrees(Math.atan(Math.sinh(Math.toRadians(val))));
        double endLon = (screenX + 1.0) / scaleX;
        double endLat = val;
        this.calculator.setStartingGeographicPoint(startLon, startLat);
        this.calculator.setDestinationGeographicPoint(endLon, endLat);
        double distance = this.calculator.getOrthodromicDistance();
        return distance;
    }

    private double findScaleWidth(double meterPerPixel) {
        double scaleWidth = 0.0;
        int i = 0;
        while (i < SCALE_VALUES.length) {
            scaleWidth = SCALE_VALUES[i] / meterPerPixel;
            if (scaleWidth > 100.0) break;
            ++i;
        }
        return scaleWidth;
    }
}

