/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.maps.eclipse;

import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.ForkJoinPool;
import javax.imageio.ImageIO;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.simantics.maps.ProvisionException;
import org.simantics.maps.internal.ImageUtil;
import org.simantics.maps.tile.ITileProvider;
import org.simantics.maps.tile.TileKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskCachingTileProvider
implements ITileProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(DiskCachingTileProvider.class);
    private final String CACHED_IMAGE_FORMAT = "png";
    ITileProvider provider;
    IPath cachePath;
    boolean supportAlpha;

    public DiskCachingTileProvider(ITileProvider provider, Boolean supportAlpha) {
        this.provider = provider;
        this.supportAlpha = supportAlpha;
        this.initCache();
    }

    @Override
    public URI getSource() {
        return this.provider.getSource();
    }

    @Override
    public Rectangle2D getExtent() {
        return this.provider.getExtent();
    }

    private void initCache() {
        Bundle b = Platform.getBundle((String)"org.simantics.maps");
        if (b == null) {
            return;
        }
        IPath statePath = Platform.getStateLocation((Bundle)b);
        URI source = this.provider.getSource();
        IPath cache = statePath.append("cache").append(source.getScheme()).append(source.getHost());
        File f = cache.toFile();
        if (!f.exists()) {
            f.mkdirs();
        } else if (!f.isDirectory()) {
            LOGGER.error("Tile cache directory " + f.toString() + " already exists as a file, cannot use it as a cache directory", (Throwable)new Exception());
            return;
        }
        this.cachePath = cache;
    }

    private IPath toTileCachePath(TileKey key) {
        return this.cachePath.append(String.valueOf(key.getLevel()) + "." + key.getX() + "." + key.getY());
    }

    private Image lookupFromDisk(TileKey key) {
        if (this.cachePath == null) {
            return null;
        }
        IPath cachePath = this.toTileCachePath(key).addFileExtension("png");
        File f = cachePath.toFile();
        if (f.exists()) {
            try {
                BufferedImage img = ImageIO.read(f);
                if (img != null) {
                    return ImageUtil.toScreenCompatibleImage(img);
                }
            }
            catch (IOException e) {
                LOGGER.warn("Failed to load cached tile from {}", (Object)f.toString(), (Object)e);
            }
            f.delete();
        }
        return null;
    }

    private void cacheToDisk(TileKey key, Image img) {
        if (this.cachePath == null) {
            return;
        }
        if (!(img instanceof RenderedImage)) {
            return;
        }
        IPath cachePath = this.toTileCachePath(key).addFileExtension("png");
        File f = cachePath.toFile();
        try {
            ImageIO.write((RenderedImage)((Object)img), "png", f);
        }
        catch (IOException iOException) {}
    }

    @Override
    public Image get(TileKey key) throws ProvisionException {
        Image img = this.lookupFromDisk(key);
        if (img == null) {
            Image image = img = this.provider.get(key);
            if (this.cachePath != null) {
                ForkJoinPool.commonPool().submit(() -> this.cacheToDisk(key, image));
            }
        }
        return img;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " [" + this.provider.toString() + "]";
    }
}

