/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.header;

import java.util.List;
import org.simantics.scl.compiler.elaboration.expressions.EVar;
import org.simantics.scl.compiler.elaboration.expressions.annotations.AnnotationUtils;
import org.simantics.scl.compiler.elaboration.expressions.records.FieldAssignment;
import org.simantics.scl.compiler.errors.ErrorLog;

public class ModuleHeader {
    public String deprecated;
    public String classLoader;
    public long classLoaderLocation;
    public String defaultLocalName;
    public List<EVar> export;
    public boolean chr;
    public boolean fields;
    public boolean edo;

    private void read(ErrorLog errorLog, FieldAssignment[] fields) {
        FieldAssignment[] fieldAssignmentArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            FieldAssignment assignment = fieldAssignmentArray[n2];
            switch (assignment.name) {
                case "bundle": {
                    if (assignment.value == null) {
                        errorLog.log(assignment.location, "Property classLoader needs to be given a string value.");
                        break;
                    }
                    this.classLoader = AnnotationUtils.extractString(assignment.value);
                    if (this.classLoader == null) {
                        errorLog.log(assignment.value.location, "Expected bundle name here.");
                        break;
                    }
                    this.classLoaderLocation = assignment.location;
                    break;
                }
                case "export": {
                    if (assignment.value == null) {
                        errorLog.log(assignment.location, "Property export needs to be given a list of exported symbols.");
                        break;
                    }
                    this.export = AnnotationUtils.extractIdentifierList(assignment.value);
                    if (this.export != null) break;
                    errorLog.log(assignment.value.location, "Expected a list of exported symbols.");
                    break;
                }
                case "features": {
                    if (assignment.value == null) {
                        errorLog.log(assignment.location, "Property features needs to be given a list of features (identifiers).");
                        break;
                    }
                    List<EVar> features = AnnotationUtils.extractIdentifierList(assignment.value);
                    if (features == null) {
                        errorLog.log(assignment.value.location, "Expected a list of features (identifiers).");
                    }
                    for (EVar feature : features) {
                        this.handleFeature(errorLog, feature);
                    }
                    break;
                }
                case "defaultLocalName": {
                    if (assignment.value == null) {
                        errorLog.log(assignment.location, "Property defaultLocalName needs to be given a string value.");
                        break;
                    }
                    this.defaultLocalName = AnnotationUtils.extractString(assignment.value);
                    if (this.defaultLocalName != null) break;
                    errorLog.log(assignment.value.location, "Expected string here.");
                    break;
                }
                case "deprecated": {
                    if (assignment.value == null) {
                        this.deprecated = "";
                        break;
                    }
                    this.deprecated = AnnotationUtils.extractString(assignment.value);
                    if (this.deprecated != null) break;
                    errorLog.log(assignment.value.location, "Expected string here.");
                    break;
                }
                default: {
                    errorLog.logWarning(assignment.location, "Unknown module header field was skipped.");
                }
            }
            ++n2;
        }
    }

    private void handleFeature(ErrorLog errorLog, EVar feature) {
        switch (feature.name) {
            case "chr": {
                this.chr = true;
                break;
            }
            case "fields": {
                this.fields = true;
                break;
            }
            case "edo": {
                this.edo = true;
                break;
            }
            default: {
                errorLog.log(feature.location, "Unknown feature " + feature.name + ".");
            }
        }
    }

    public static ModuleHeader process(ErrorLog errorLog, FieldAssignment[] fields) {
        if (fields == null) {
            return null;
        }
        ModuleHeader result = new ModuleHeader();
        result.read(errorLog, fields);
        return result;
    }
}

