/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.elaboration.constraints;

import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.internal.elaboration.constraints.Constraint;
import org.simantics.scl.compiler.internal.elaboration.constraints.ConstraintComparator;
import org.simantics.scl.compiler.internal.elaboration.constraints.ConstraintEnvironment;
import org.simantics.scl.compiler.internal.elaboration.constraints.ConstraintSet;
import org.simantics.scl.compiler.internal.elaboration.constraints.ReducedConstraints;
import org.simantics.scl.compiler.internal.elaboration.constraints.Reduction;
import org.simantics.scl.compiler.types.TCon;
import org.simantics.scl.compiler.types.TMetaVar;
import org.simantics.scl.compiler.types.TPred;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.exceptions.UnificationException;
import org.simantics.scl.compiler.types.util.TConComparator;

public class ConstraintSolver {
    public static THashSet<TCon> DEFAULTS_IGNORE = new THashSet();
    public static THashMap<List<TCon>, Type> DEFAULTS = new THashMap();

    static {
        DEFAULTS_IGNORE.add((Object)Types.SHOW);
        DEFAULTS_IGNORE.add((Object)Types.con("Json2", "JSON"));
        DEFAULTS_IGNORE.add((Object)Types.VEC_COMP);
        DEFAULTS_IGNORE.add((Object)Types.ORD);
        DEFAULTS_IGNORE.add((Object)Types.TYPEABLE);
        DEFAULTS_IGNORE.add((Object)Types.SERIALIZABLE);
        DEFAULTS_IGNORE.add((Object)Types.con("Formatting", "FormatArgument"));
        DEFAULTS.put(Arrays.asList(Types.ADDITIVE), (Object)Types.INTEGER);
        DEFAULTS.put(Arrays.asList(Types.RING), (Object)Types.INTEGER);
        DEFAULTS.put(Arrays.asList(Types.ORDERED_RING), (Object)Types.INTEGER);
        DEFAULTS.put(Arrays.asList(Types.INTEGRAL), (Object)Types.INTEGER);
        DEFAULTS.put(Arrays.asList(Types.REAL), (Object)Types.DOUBLE);
        TCon RCOMPATIBLE = Types.con("R/RExp", "RCompatible");
        TCon REXP = Types.con("R/RExp", "RExp");
        DEFAULTS.put(Arrays.asList(RCOMPATIBLE), (Object)REXP);
        DEFAULTS.put(Arrays.asList(RCOMPATIBLE, Types.ADDITIVE), (Object)Types.DOUBLE);
        DEFAULTS.put(Arrays.asList(RCOMPATIBLE, Types.RING), (Object)Types.DOUBLE);
        DEFAULTS.put(Arrays.asList(RCOMPATIBLE, Types.ORDERED_RING), (Object)Types.DOUBLE);
        DEFAULTS.put(Arrays.asList(RCOMPATIBLE, Types.INTEGRAL), (Object)Types.DOUBLE);
        DEFAULTS.put(Arrays.asList(RCOMPATIBLE, Types.REAL), (Object)Types.DOUBLE);
    }

    public static ReducedConstraints solve(ConstraintEnvironment environment, ArrayList<TPred> given, ArrayList<EVariable> demands, boolean applyDefaults) {
        Object tuc = null;
        ConstraintSet cs = new ConstraintSet(environment);
        ArrayList<Constraint> givenConstraints = new ArrayList<Constraint>(given.size());
        for (TPred g : given) {
            givenConstraints.add(cs.addGiven(g));
        }
        for (EVariable d : demands) {
            cs.addDemand(d);
        }
        cs.reduce();
        ArrayList<Constraint> unsolvedConstraints = new ArrayList<Constraint>();
        ArrayList<Constraint> solvedConstraints = new ArrayList<Constraint>();
        cs.collect(unsolvedConstraints, solvedConstraints);
        if (applyDefaults && !unsolvedConstraints.isEmpty()) {
            ArrayList<ArrayList<Constraint>> groups = ConstraintSolver.groupConstraintsByCommonMetavars(unsolvedConstraints);
            unsolvedConstraints.clear();
            ArrayList<Constraint> newSolvedConstraints = new ArrayList<Constraint>(unsolvedConstraints.size() + solvedConstraints.size());
            for (ArrayList<Constraint> group : groups) {
                ArrayList<TCon> cons = new ArrayList<TCon>(group.size());
                for (Constraint constraint : group) {
                    if (DEFAULTS_IGNORE.contains((Object)constraint.constraint.typeClass)) continue;
                    cons.add(constraint.constraint.typeClass);
                }
                Collections.sort(cons, TConComparator.INSTANCE);
                Type defaultType = (Type)DEFAULTS.get(cons);
                if (defaultType != null) {
                    TMetaVar var = null;
                    for (Constraint constraint : group) {
                        if (constraint.constraint.parameters.length != 1) {
                            var = null;
                            break;
                        }
                        Type parameter = Types.canonical(constraint.constraint.parameters[0]);
                        if (!(parameter instanceof TMetaVar)) {
                            var = null;
                            break;
                        }
                        if (var != null) continue;
                        var = (TMetaVar)parameter;
                    }
                    if (var != null) {
                        try {
                            var.setRef(defaultType);
                        }
                        catch (UnificationException unificationException) {
                            throw new InternalCompilerError();
                        }
                        for (Constraint constraint : group) {
                            Reduction reduction = environment.reduce(constraint.demandLocation, constraint.constraint);
                            if (reduction.demands.length > 0) {
                                throw new InternalCompilerError();
                            }
                            constraint.setGenerator(1, reduction.generator, reduction.parameters, new Constraint[0]);
                            newSolvedConstraints.add(constraint);
                        }
                        continue;
                    }
                }
                unsolvedConstraints.addAll(group);
            }
            Collections.sort(unsolvedConstraints, ConstraintComparator.INSTANCE);
            newSolvedConstraints.addAll(solvedConstraints);
            solvedConstraints = newSolvedConstraints;
        }
        return new ReducedConstraints(givenConstraints, solvedConstraints, unsolvedConstraints);
    }

    private static <K, V> void add(THashMap<K, ArrayList<V>> map, K k, V v) {
        ArrayList<V> list = (ArrayList<V>)map.get(k);
        if (list == null) {
            list = new ArrayList<V>(2);
            map.put(k, list);
        }
        list.add(v);
    }

    private static TMetaVar canonical(THashMap<TMetaVar, TMetaVar> cMap, TMetaVar v) {
        TMetaVar temp;
        while ((temp = (TMetaVar)cMap.get((Object)v)) != null) {
            v = temp;
        }
        return v;
    }

    private static void merge(THashMap<TMetaVar, TMetaVar> cMap, THashMap<TMetaVar, ArrayList<Constraint>> groups, TMetaVar a, TMetaVar b) {
        if (a != b) {
            cMap.put((Object)b, (Object)a);
            ArrayList listB = (ArrayList)groups.remove((Object)b);
            if (listB != null) {
                ArrayList listA = (ArrayList)groups.get((Object)a);
                if (listA == null) {
                    groups.put((Object)a, (Object)listB);
                } else {
                    listA.addAll(listB);
                }
            }
        }
    }

    private static ArrayList<ArrayList<Constraint>> groupConstraintsByCommonMetavars(ArrayList<Constraint> constraints) {
        THashMap groups = new THashMap();
        THashMap cMap = new THashMap();
        ArrayList<TMetaVar> vars = new ArrayList<TMetaVar>();
        for (Constraint constraint : constraints) {
            constraint.constraint.collectMetaVars(vars);
            if (vars.isEmpty()) {
                ConstraintSolver.add(groups, null, constraint);
                continue;
            }
            TMetaVar first = ConstraintSolver.canonical((THashMap<TMetaVar, TMetaVar>)cMap, vars.get(0));
            int i = 1;
            while (i < vars.size()) {
                ConstraintSolver.merge((THashMap<TMetaVar, TMetaVar>)cMap, (THashMap<TMetaVar, ArrayList<Constraint>>)groups, first, ConstraintSolver.canonical((THashMap<TMetaVar, TMetaVar>)cMap, vars.get(i)));
                ++i;
            }
            vars.clear();
            ConstraintSolver.add(groups, first, constraint);
        }
        return new ArrayList<ArrayList<Constraint>>(groups.values());
    }
}

