/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.graph.celleditor;

import java.util.function.Consumer;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.MutableVariant;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.Write;
import org.simantics.spreadsheet.CellEditor;
import org.simantics.spreadsheet.OperationMode;
import org.simantics.spreadsheet.Transaction;
import org.simantics.spreadsheet.util.SpreadsheetUtils;

public class GraphCellEditorAdapter
implements CellEditor<Write> {
    protected final Variable cell;

    public GraphCellEditorAdapter(Variable cell) {
        this.cell = cell;
    }

    public <T> void edit(WriteGraph graph, Transaction<Write> transaction, String location, String property, T value, Binding binding) throws DatabaseException {
    }

    public <T> void edit(WriteGraph graph, Transaction<Write> transaction, String location, Variant value) throws DatabaseException {
    }

    public <T> void copy(WriteGraph graph, Transaction<Write> transaction, String location, MutableVariant variant) throws DatabaseException {
    }

    public <T> void edit(final Transaction<Write> transaction, final String location, final String property, final T value, final Binding binding, final Consumer<?> callback) {
        SpreadsheetUtils.schedule(transaction, (Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                GraphCellEditorAdapter.this.edit(graph, (Transaction<Write>)transaction, location, property, value, binding);
                Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)("Modified cell in location " + location + " with value " + value));
                if (callback != null) {
                    callback.accept(null);
                }
            }
        });
    }

    public void edit(final Transaction<Write> transaction, final String location, final Variant value, final Consumer<?> callback) {
        SpreadsheetUtils.schedule(transaction, (Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                GraphCellEditorAdapter.this.edit(graph, (Transaction<Write>)transaction, location, value);
                Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)("Modified cell on location " + location + " with value " + value));
                if (callback != null) {
                    callback.accept(null);
                }
            }
        });
    }

    public void copy(final Transaction<Write> transaction, final String location, final MutableVariant variant, Consumer<?> callback) {
        SpreadsheetUtils.schedule(transaction, (Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                GraphCellEditorAdapter.this.copy(graph, (Transaction<Write>)transaction, location, variant);
            }
        });
    }

    public Transaction<Write> startTransaction(OperationMode mode) {
        return SpreadsheetUtils.startTransaction((OperationMode)mode);
    }
}

