/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.simantics.db.Resource;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.utils.Logger;

public class Indexing {
    private static final boolean PROFILE = false;
    private static Set<UUID> indexPendings = new HashSet<UUID>();
    private static AtomicBoolean dependenciesIndexingDisabled = new AtomicBoolean();
    private static int indexPendingCounter = 0;
    private static Map<Resource, Map<Class<?>, Object>> caches = new HashMap();
    private static boolean useIndexing = true;
    private static long totalWaitTime = 0L;

    public static <T> T getCache(Resource root, Class<T> clazz) {
        Map<Class<?>, Object> cache = caches.get(root);
        if (cache == null) {
            return null;
        }
        return (T)cache.get(clazz);
    }

    public static <T> T createCache(Resource root, T object) {
        Map<Class<?>, Object> cache = caches.get(root);
        if (cache == null) {
            cache = new HashMap();
            caches.put(root, cache);
        }
        cache.put(object.getClass(), object);
        return object;
    }

    public static void clearCaches(Resource root) {
        caches.remove(root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UUID makeIndexPending() {
        Set<UUID> set = indexPendings;
        synchronized (set) {
            UUID guid = UUID.randomUUID();
            indexPendings.add(guid);
            return guid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseIndexPending(UUID guid) {
        Set<UUID> set = indexPendings;
        synchronized (set) {
            indexPendings.remove(guid);
            if (indexPendings.isEmpty()) {
                indexPendings.notifyAll();
                ++indexPendingCounter;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getIndexPendingCounter() {
        Set<UUID> set = indexPendings;
        synchronized (set) {
            return indexPendingCounter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isIndexPending() {
        Set<UUID> set = indexPendings;
        synchronized (set) {
            return !indexPendings.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void waitIndexPending() {
        long startTime = 0L;
        boolean waited = false;
        int time = 1;
        Set<UUID> set = indexPendings;
        synchronized (set) {
            while (true) {
                if (!Indexing.isIndexPending()) {
                    return;
                }
                try {
                    waited = true;
                    indexPendings.wait(time++);
                    if (time <= 10) continue;
                    time = 10;
                }
                catch (InterruptedException e) {
                    Logger.defaultLogError(e);
                }
            }
        }
    }

    public static boolean setDependenciesIndexingDisabled(WriteOnlyGraph graph, boolean disabled) {
        if (graph == null) {
            throw new NullPointerException("null write graph");
        }
        return dependenciesIndexingDisabled.getAndSet(disabled);
    }

    public static boolean resetDependenciesIndexingDisabled() {
        return dependenciesIndexingDisabled.compareAndSet(true, false);
    }

    public static boolean isDependenciesIndexingDisabled() {
        if (!useIndexing) {
            return true;
        }
        return dependenciesIndexingDisabled.get();
    }

    public static void setDefaultDependenciesIndexingEnabled(boolean b) {
        useIndexing = b;
    }
}

