/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagram.monitor;

import java.util.ArrayList;
import java.util.Collections;
import org.simantics.common.color.Color;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.RelationContext;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.common.adaption.SimpleContextualAdapter;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.property.OrderedResource;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.operation.Layer0X;

public class ObtainedColorAdapter
extends SimpleContextualAdapter<Color, RelationContext> {
    public Color adapt(ReadGraph graph, Resource source, RelationContext context) throws DatabaseException {
        Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        ArrayList<OrderedResource> order = new ArrayList<OrderedResource>();
        for (Statement stm : graph.getStatements(context.getSubject(), L0X.ObtainsProperty)) {
            Integer position = (Integer)graph.getRelatedValue(stm.getPredicate(), L0X.NaturalNumberOrderRelation, (Binding)Bindings.INTEGER);
            order.add(new OrderedResource(position, stm.getObject()));
        }
        if (order.size() > 1) {
            Collections.sort(order);
        }
        for (OrderedResource or : order) {
            Color result = (Color)graph.getPossibleRelatedAdapter(or.r, DIA.HasColor, Color.class);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

