/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.simulator.toolkit;

import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.tuple.Tuple0;
import org.simantics.simulator.toolkit.StandardNodeManager;
import org.simantics.simulator.toolkit.StandardNodeManagerSupport;
import org.simantics.simulator.variable.Realm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StandardRealm<Node, Engine extends StandardNodeManagerSupport<Node>>
implements Realm {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandardRealm.class);
    private String id;
    protected Thread executorThread;
    private StandardRealmThreadFactory factory = new StandardRealmThreadFactory(this);
    private ThreadPoolExecutor executor = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), this.factory);
    private Semaphore beginSyncExec = new Semaphore(0);
    private Semaphore endSyncExec = new Semaphore(0);
    private Engine engine;
    protected StandardNodeManager<Node, Engine> nodeManager;
    private boolean disposed = false;
    private Runnable scheduleSyncExec = new Runnable(){

        @Override
        public void run() {
            StandardRealm.this.beginSyncExec.release();
            try {
                StandardRealm.this.endSyncExec.acquire();
            }
            catch (InterruptedException interruptedException) {}
        }
    };

    protected StandardRealm(Engine engine, String id) {
        this.engine = engine;
        this.id = id;
        this.nodeManager = this.createManager();
    }

    protected StandardNodeManager<Node, Engine> createManager(Node root) {
        return new StandardNodeManager(this, root);
    }

    protected StandardNodeManager<Node, Engine> createManager() {
        return this.createManager(this.createRootNode());
    }

    protected Node createRootNode() {
        throw new UnsupportedOperationException();
    }

    protected String getSCLContextKey() {
        return this.getClass().getSimpleName();
    }

    public String getId() {
        return this.id;
    }

    public Engine getEngine() {
        return this.engine;
    }

    public Thread getThread() {
        return this.executorThread;
    }

    public Object syncExec(Function fun) throws InterruptedException {
        this.executor.execute(this.scheduleSyncExec);
        SCLContext context = SCLContext.getCurrent();
        StandardNodeManagerSupport oldConnection = (StandardNodeManagerSupport)context.put((Object)this.getSCLContextKey(), this.engine);
        try {
            this.beginSyncExec.acquire();
            Thread oldThread = this.executorThread;
            this.executorThread = Thread.currentThread();
            try {
                Object r = fun.apply(Tuple0.INSTANCE);
                this.executorThread = oldThread;
                this.endSyncExec.release();
                return r;
            }
            catch (Throwable throwable) {
                this.executorThread = oldThread;
                this.endSyncExec.release();
                throw throwable;
            }
        }
        finally {
            context.put((Object)this.getSCLContextKey(), (Object)oldConnection);
        }
    }

    public void asyncExec(final Function fun) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                SCLContext context = SCLContext.getCurrent();
                context.put((Object)StandardRealm.this.getSCLContextKey(), (Object)StandardRealm.this.engine);
                fun.apply(Tuple0.INSTANCE);
            }
        });
    }

    public void syncExec(Runnable runnable) throws InterruptedException {
        if (this.executorThread == Thread.currentThread()) {
            try {
                runnable.run();
            }
            catch (Throwable t) {
                LOGGER.error("Error executing runnable in realm", t);
            }
            return;
        }
        this.executor.execute(this.scheduleSyncExec);
        this.beginSyncExec.acquire();
        Thread oldThread = this.executorThread;
        this.executorThread = Thread.currentThread();
        try {
            try {
                runnable.run();
            }
            catch (Throwable t) {
                LOGGER.error("Error executing runnable in realm", t);
                this.executorThread = oldThread;
                this.endSyncExec.release();
            }
        }
        finally {
            this.executorThread = oldThread;
            this.endSyncExec.release();
        }
    }

    public void asyncExec(Runnable runnable) {
        if (this.executorThread == Thread.currentThread()) {
            try {
                runnable.run();
            }
            catch (Throwable t) {
                LOGGER.error("Error executing runnable in realm", t);
            }
            return;
        }
        this.executor.execute(runnable);
    }

    public void close() {
        this.executor.shutdown();
        try {
            List<Runnable> runnablesLeft;
            if (!this.executor.awaitTermination(500L, TimeUnit.MILLISECONDS) && !(runnablesLeft = this.executor.shutdownNow()).isEmpty()) {
                this.getLogger().info("Runnables left for realm " + this + " after executor shutdown! " + runnablesLeft);
            }
        }
        catch (InterruptedException e) {
            this.getLogger().info("Could not shutdown executor " + this.executor + " for realm " + this, (Throwable)e);
        }
        this.factory.clear();
        this.factory = null;
        if (!this.executorThread.isAlive()) {
            this.executorThread.interrupt();
        }
        this.executorThread = null;
        this.executor = null;
        this.nodeManager.clear();
        this.nodeManager = null;
        this.disposed = true;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public StandardNodeManager<Node, Engine> getNodeManager() {
        return this.nodeManager;
    }

    public abstract Logger getLogger();

    private void setExecutorThread(Thread t) {
        this.executorThread = t;
    }

    private static class StandardRealmThreadFactory
    implements ThreadFactory {
        private StandardRealm<?, ?> realm;

        public StandardRealmThreadFactory(StandardRealm<?, ?> realm) {
            this.realm = realm;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            ((StandardRealm)this.realm).setExecutorThread(t);
            return t;
        }

        void clear() {
            this.realm = null;
        }
    }
}

