/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.server.request;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.ProxyVariables;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.document.server.ConsoleSCLReportingHandler;
import org.simantics.document.server.JSONObject;
import org.simantics.document.server.io.IConsole;
import org.simantics.document.server.io.IConsoleSupport;
import org.simantics.document.server.request.DocumentRequest;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.reporting.SCLReportingHandler;

public class URIDocumentRequest
extends UnaryRead<String, List<JSONObject>> {
    private static final Comparator<JSONObject> COMPARATOR = (o1, o2) -> o1.id.compareTo(o2.id);

    public URIDocumentRequest(String var) {
        super((Object)var);
    }

    public List<JSONObject> perform(ReadGraph graph) throws DatabaseException {
        Variable var = Variables.getPossibleVariable((ReadGraph)graph, (String)((String)this.parameter));
        if (var == null) {
            Variables.getPossibleVariable((ReadGraph)graph, (String)((String)this.parameter));
            return Collections.emptyList();
        }
        IConsole console = null;
        IConsoleSupport cs = (IConsoleSupport)Simantics.getSession().peekService(IConsoleSupport.class);
        if (cs != null) {
            Variable root = ProxyVariables.proxyVariableRoot((ReadGraph)graph, (Variable)var);
            if (root == null) {
                return Collections.emptyList();
            }
            Variable session = root.getParent(graph);
            String guid = session.getName(graph);
            console = cs.getConsole(guid);
        }
        SCLContext sclContext = SCLContext.getCurrent();
        ConsoleSCLReportingHandler printer = console != null ? new ConsoleSCLReportingHandler(console) : (SCLReportingHandler)sclContext.get((Object)"reportingHandler");
        Object oldPrinter = sclContext.put((Object)"reportingHandler", (Object)printer);
        try {
            ArrayList<JSONObject> result = new ArrayList<JSONObject>((Collection)graph.syncRequest((Read)new DocumentRequest(var)));
            Collections.sort(result, COMPARATOR);
            ArrayList<JSONObject> arrayList = result;
            return arrayList;
        }
        finally {
            sclContext.put((Object)"reportingHandler", oldPrinter);
        }
    }
}

